/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.liftover;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.liftover.Chain;
import net.sf.picard.util.Interval;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.SAMSequenceDictionary;

public class LiftOver {
    private static final Log LOG = Log.getInstance(LiftOver.class);
    public static final double DEFAULT_LIFTOVER_MINMATCH = 0.95;
    private double liftOverMinMatch = 0.95;
    private final OverlapDetector<Chain> chains;

    public LiftOver(File file) {
        IoUtil.assertFileIsReadable(file);
        this.chains = Chain.loadChains(file);
    }

    public void validateToSequences(SAMSequenceDictionary sAMSequenceDictionary) {
        for (Chain chain2 : this.chains.getAll()) {
            if (sAMSequenceDictionary.getSequence(chain2.toSequenceName) != null) continue;
            throw new PicardException("Sequence " + chain2.toSequenceName + " from chain file is not found in sequence dictionary.");
        }
    }

    public Interval liftOver(Interval interval) {
        return this.liftOver(interval, this.liftOverMinMatch);
    }

    public Interval liftOver(Interval interval, double d) {
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        Chain chain2 = null;
        TargetIntersection targetIntersection = null;
        double d2 = d * (double)interval.length();
        for (Chain chain3 : this.chains.getOverlaps(interval)) {
            TargetIntersection targetIntersection2 = LiftOver.targetIntersection(chain3, interval);
            if (targetIntersection2 != null && (double)targetIntersection2.intersectionLength >= d2) {
                if (chain2 != null) {
                    return null;
                }
                chain2 = chain3;
                targetIntersection = targetIntersection2;
                continue;
            }
            if (targetIntersection2 == null) continue;
            LOG.info("Interval " + interval.getName() + " failed to match chain " + chain3.id + " because intersection length " + targetIntersection2.intersectionLength + " < minMatchSize " + d2 + " (" + (float)targetIntersection2.intersectionLength / (float)interval.length() + " < " + d + ")");
        }
        if (chain2 == null) {
            return null;
        }
        return LiftOver.createToInterval(interval.getName(), targetIntersection);
    }

    public List<PartialLiftover> diagnosticLiftover(Interval interval) {
        ArrayList<PartialLiftover> arrayList = new ArrayList<PartialLiftover>();
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        for (Chain chain2 : this.chains.getOverlaps(interval)) {
            Interval interval2;
            TargetIntersection targetIntersection = LiftOver.targetIntersection(chain2, interval2 = interval.intersect(chain2.interval));
            if (targetIntersection == null) {
                arrayList.add(new PartialLiftover(interval2, chain2.id));
                continue;
            }
            Interval interval3 = LiftOver.createToInterval(interval.getName(), targetIntersection);
            float f = (float)targetIntersection.intersectionLength / (float)interval.length();
            arrayList.add(new PartialLiftover(interval2, interval3, targetIntersection.chain.id, f));
        }
        return arrayList;
    }

    private static Interval createToInterval(String string2, TargetIntersection targetIntersection) {
        int n = targetIntersection.chain.getBlock((int)targetIntersection.firstBlockIndex).toStart + targetIntersection.startOffset;
        int n2 = targetIntersection.chain.getBlock(targetIntersection.lastBlockIndex).getToEnd() - targetIntersection.offsetFromEnd;
        if (n2 <= n || n < 0) {
            throw new PicardException("Something strange lifting over interval " + string2);
        }
        if (targetIntersection.chain.toNegativeStrand) {
            int n3 = targetIntersection.chain.toSequenceSize - n2;
            int n4 = targetIntersection.chain.toSequenceSize - n;
            n = n3;
            n2 = n4;
        }
        return new Interval(targetIntersection.chain.toSequenceName, n + 1, n2, targetIntersection.chain.toNegativeStrand, string2);
    }

    private static TargetIntersection targetIntersection(Chain chain2, Interval interval) {
        int n = 0;
        int n2 = interval.getStart() - 1;
        int n3 = interval.getEnd();
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        List<Chain.ContinuousBlock> list = chain2.getBlocks();
        for (int i = 0; i < list.size(); ++i) {
            Chain.ContinuousBlock continuousBlock = list.get(i);
            if (continuousBlock.fromStart >= n3) break;
            if (continuousBlock.getFromEnd() <= n2) continue;
            if (n4 == -1) {
                n4 = i;
                n6 = n2 > continuousBlock.fromStart ? n2 - continuousBlock.fromStart : 0;
            }
            n5 = i;
            n7 = continuousBlock.getFromEnd() > n3 ? continuousBlock.getFromEnd() - n3 : 0;
            int n8 = Math.min(n3, continuousBlock.getFromEnd()) - Math.max(n2, continuousBlock.fromStart);
            if (n8 <= 0) {
                throw new PicardException("Should have been some intersection.");
            }
            n += n8;
        }
        if (n == 0) {
            return null;
        }
        return new TargetIntersection(chain2, n, n6, n7, n4, n5);
    }

    public double getLiftOverMinMatch() {
        return this.liftOverMinMatch;
    }

    public void setLiftOverMinMatch(double d) {
        this.liftOverMinMatch = d;
    }

    public static class PartialLiftover {
        final Interval fromInterval;
        final Interval toInterval;
        final int chainId;
        final float percentLiftedOver;

        PartialLiftover(Interval interval, Interval interval2, int n, float f) {
            this.fromInterval = interval;
            this.toInterval = interval2;
            this.chainId = n;
            this.percentLiftedOver = f;
        }

        PartialLiftover(Interval interval, int n) {
            this.fromInterval = interval;
            this.toInterval = null;
            this.chainId = n;
            this.percentLiftedOver = 0.0f;
        }

        public String toString() {
            if (this.toInterval == null) {
                return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>null using chain " + this.chainId;
            }
            String string2 = this.toInterval.isNegativeStrand() ? "-" : "+";
            return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>" + this.toInterval + "(" + string2 + ") using chain " + this.chainId + " ; pct matched " + this.percentLiftedOver;
        }
    }

    private static class TargetIntersection {
        final Chain chain;
        final int intersectionLength;
        final int startOffset;
        final int offsetFromEnd;
        final int firstBlockIndex;
        final int lastBlockIndex;

        TargetIntersection(Chain chain2, int n, int n2, int n3, int n4, int n5) {
            this.chain = chain2;
            this.intersectionLength = n;
            this.startOffset = n2;
            this.offsetFromEnd = n3;
            this.firstBlockIndex = n4;
            this.lastBlockIndex = n5;
        }
    }
}

