/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.StringUtil;

public class CreateSequenceDictionary
extends CommandLineProgram {
    @Usage
    public String USAGE = "Usage: " + this.getClass().getName() + " [options]\n\n" + "Read fasta or fasta.gz containing reference sequences, and write as a SAM or BAM file with only sequence dictionary.\n";
    @Option(doc="Input reference fasta or fasta.gz", shortName="R")
    public File REFERENCE;
    @Option(doc="Output SAM or BAM file containing only the sequence dictionary", shortName="O")
    public File OUTPUT;
    @Option(doc="Put into AS field of sequence dictionary entry if supplied", optional=true)
    public String GENOME_ASSEMBLY;
    @Option(doc="Put into UR field of sequence dictionary entry.  If not supplied, input reference file is used", optional=true)
    public String URI;
    @Option(doc="Put into SP field of sequence dictionary entry", optional=true)
    public String SPECIES;
    @Option(doc="Make sequence name the first word from the > line in the fasta file.  By default the entire contents of the > line is used, excluding leading and trailing whitespace.")
    public boolean TRUNCATE_NAMES_AT_WHITESPACE = true;
    @Option(doc="Stop after writing this many sequences.  For testing.")
    public int NUM_SEQUENCES = Integer.MAX_VALUE;
    private final MessageDigest md5;

    public CreateSequenceDictionary() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PicardException("MD5 algorithm not found", noSuchAlgorithmException);
        }
    }

    public static void main(String[] stringArray) {
        System.exit(new CreateSequenceDictionary().instanceMain(stringArray));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.URI == null) {
            this.URI = "file:" + this.REFERENCE.getAbsolutePath();
        }
        return null;
    }

    @Override
    protected int doWork() {
        if (this.OUTPUT.exists()) {
            throw new PicardException(this.OUTPUT.getAbsolutePath() + " already exists.  Delete this file and try again, or specify a different output file.");
        }
        SAMSequenceDictionary sAMSequenceDictionary = this.makeSequenceDictionary(this.REFERENCE);
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMWriter(sAMFileHeader, false, this.OUTPUT);
        sAMFileWriter.close();
        return 0;
    }

    SAMSequenceDictionary makeSequenceDictionary(File file) {
        ReferenceSequence referenceSequence;
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(file, this.TRUNCATE_NAMES_AT_WHITESPACE);
        ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.NUM_SEQUENCES && (referenceSequence = referenceSequenceFile.nextSequence()) != null; ++i) {
            if (hashSet.contains(referenceSequence.getName())) {
                throw new PicardException("Sequence name appears more than once in reference: " + referenceSequence.getName());
            }
            hashSet.add(referenceSequence.getName());
            arrayList.add(this.makeSequenceRecord(referenceSequence));
        }
        return new SAMSequenceDictionary(arrayList);
    }

    private SAMSequenceRecord makeSequenceRecord(ReferenceSequence referenceSequence) {
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(referenceSequence.getName(), referenceSequence.length());
        byte[] byArray = referenceSequence.getBases();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = StringUtil.toUpperCase(byArray[i]);
        }
        sAMSequenceRecord.setAttribute("M5", this.md5Hash(byArray));
        if (this.GENOME_ASSEMBLY != null) {
            sAMSequenceRecord.setAttribute("AS", this.GENOME_ASSEMBLY);
        }
        sAMSequenceRecord.setAttribute("UR", this.URI);
        if (this.SPECIES != null) {
            sAMSequenceRecord.setAttribute("SP", this.SPECIES);
        }
        return sAMSequenceRecord;
    }

    private String md5Hash(byte[] byArray) {
        this.md5.reset();
        this.md5.update(byArray);
        String string2 = new BigInteger(1, this.md5.digest()).toString(16);
        if (string2.length() != 32) {
            string2 = "00000000000000000000000000000000".substring(0, 32 - string2.length()) + string2;
        }
        return string2;
    }
}

