/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.sam.CoordinateSortedPairInfoMap;
import net.sf.picard.sam.ReadEnds;
import net.sf.picard.sam.ReadEndsCodec;
import net.sf.picard.sam.ReadEndsMap;

class DiskReadEndsMap
implements ReadEndsMap {
    private final CoordinateSortedPairInfoMap<String, ReadEnds> pairInfoMap;

    DiskReadEndsMap(int n) {
        this.pairInfoMap = new CoordinateSortedPairInfoMap<String, ReadEnds>(n, new Codec());
    }

    @Override
    public ReadEnds remove(int n, String string2) {
        return this.pairInfoMap.remove(n, string2);
    }

    @Override
    public void put(int n, String string2, ReadEnds readEnds) {
        this.pairInfoMap.put(n, string2, readEnds);
    }

    @Override
    public int size() {
        return this.pairInfoMap.size();
    }

    @Override
    public int sizeInRam() {
        return this.pairInfoMap.sizeInRam();
    }

    private static class Codec
    implements CoordinateSortedPairInfoMap.Codec<String, ReadEnds> {
        private final ReadEndsCodec readEndsCodec = new ReadEndsCodec();

        private Codec() {
        }

        @Override
        public void setInputStream(InputStream inputStream) {
            this.readEndsCodec.setInputStream(inputStream);
        }

        @Override
        public void setOutputStream(OutputStream outputStream) {
            this.readEndsCodec.setOutputStream(outputStream);
        }

        @Override
        public Map.Entry<String, ReadEnds> decode() {
            try {
                String string2 = this.readEndsCodec.getInputStream().readUTF();
                ReadEnds readEnds = this.readEndsCodec.decode();
                return new AbstractMap.SimpleEntry<String, ReadEnds>(string2, readEnds);
            }
            catch (IOException iOException) {
                throw new PicardException("Error loading ReadEndsMap from disk", iOException);
            }
        }

        @Override
        public void encode(String string2, ReadEnds readEnds) {
            try {
                this.readEndsCodec.getOutputStream().writeUTF(string2);
                this.readEndsCodec.encode(readEnds);
            }
            catch (IOException iOException) {
                throw new PicardException("Error spilling ReadEndsMap to disk.", iOException);
            }
        }
    }
}

