/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.HashMap;
import java.util.Random;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class DownsampleSam
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + " Randomly down-sample a SAM or BAM file to retain " + "a random subset of the reads. Mate-pairs are either both kept or both discarded. Reads marked as not primary " + "alignments are all discarded. Each read is given a probability P of being retained - results with the exact " + "same input in the same order and with the same value for RANDOM_SEED will produce the same results.";
    @Option(shortName="I", doc="The input SAM or BAM file to downsample.")
    public File INPUT;
    @Option(shortName="O", doc="The output, downsampled, SAM or BAM file to write.")
    public File OUTPUT;
    @Option(shortName="R", doc="Random seed to use if reproducibilty is desired.  Setting to null will cause multiple invocations to produce different results.")
    public Long RANDOM_SEED = 1L;
    @Option(shortName="P", doc="The probability of keeping any individual read, between 0 and 1.")
    public double PROBABILITY = 1.0;
    private final Log log = Log.getInstance(DownsampleSam.class);

    public static void main(String[] stringArray) {
        new DownsampleSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        Random random = this.RANDOM_SEED == null ? new Random() : new Random(this.RANDOM_SEED);
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileReader.getFileHeader(), true, this.OUTPUT);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        long l = 0L;
        long l2 = 0L;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord sAMRecord : sAMFileReader) {
            boolean bl;
            if (sAMRecord.isSecondaryOrSupplementary()) continue;
            ++l;
            String string2 = sAMRecord.getReadName();
            Boolean bl2 = (Boolean)hashMap.remove(string2);
            if (bl2 == null) {
                boolean bl3 = bl = random.nextDouble() <= this.PROBABILITY;
                if (sAMRecord.getReadPairedFlag()) {
                    hashMap.put(string2, bl);
                }
            } else {
                bl = bl2;
            }
            if (bl) {
                sAMFileWriter.addAlignment(sAMRecord);
                ++l2;
            }
            progressLogger.record(sAMRecord);
        }
        sAMFileWriter.close();
        this.log.info("Finished! Kept " + l2 + " out of " + l + " reads.");
        return 0;
    }
}

