/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.DiskBasedBAMFileIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.StringLineReader;

class BAMFileReader
extends SAMFileReader.ReaderImplementation {
    private boolean mIsSeekable = false;
    private BinaryCodec mStream = null;
    private final BlockCompressedInputStream mCompressedInputStream;
    private SAMFileHeader mFileHeader = null;
    private File mIndexFile = null;
    private SeekableStream mIndexStream = null;
    private BAMIndex mIndex = null;
    private long mFirstRecordPointer = 0L;
    private CloseableIterator<SAMRecord> mCurrentIterator = null;
    private final boolean eagerDecode;
    private SAMFileReader.ValidationStringency mValidationStringency;
    private SAMRecordFactory samRecordFactory;
    private boolean mEnableIndexCaching = false;
    private boolean mEnableIndexMemoryMapping = true;
    private SAMFileReader mFileReader = null;

    BAMFileReader(InputStream inputStream, File file, boolean bl, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexFile = file;
        this.mIsSeekable = false;
        this.mCompressedInputStream = new BlockCompressedInputStream(inputStream);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.readHeader(null);
    }

    BAMFileReader(File file, File file2, boolean bl, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(file), file2 != null ? file2 : BAMFileReader.findIndexFile(file), bl, file.getAbsolutePath(), validationStringency, sAMRecordFactory);
        if (this.mIndexFile != null && this.mIndexFile.lastModified() < file.lastModified()) {
            System.err.println("WARNING: BAM index file " + this.mIndexFile.getAbsolutePath() + " is older than BAM " + file.getAbsolutePath());
        }
        this.mStream.setInputFileName(file.getAbsolutePath());
    }

    BAMFileReader(SeekableStream seekableStream, File file, boolean bl, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(seekableStream), file, bl, seekableStream.getSource(), validationStringency, sAMRecordFactory);
    }

    BAMFileReader(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(seekableStream), seekableStream2, bl, seekableStream.getSource(), validationStringency, sAMRecordFactory);
    }

    private BAMFileReader(BlockCompressedInputStream blockCompressedInputStream, File file, boolean bl, String string2, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexFile = file;
        this.mIsSeekable = true;
        this.mCompressedInputStream = blockCompressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.readHeader(string2);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    private BAMFileReader(BlockCompressedInputStream blockCompressedInputStream, SeekableStream seekableStream, boolean bl, String string2, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexStream = seekableStream;
        this.mIsSeekable = true;
        this.mCompressedInputStream = blockCompressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.readHeader(string2);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    @Override
    void enableFileSource(SAMFileReader sAMFileReader, boolean bl) {
        this.mFileReader = bl ? sAMFileReader : null;
    }

    @Override
    public void enableIndexCaching(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mEnableIndexCaching = bl;
    }

    @Override
    public void enableIndexMemoryMapping(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mEnableIndexMemoryMapping = bl;
    }

    @Override
    void enableCrcChecking(boolean bl) {
        this.mCompressedInputStream.setCheckCrcs(bl);
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        this.samRecordFactory = sAMRecordFactory;
    }

    @Override
    public boolean hasIndex() {
        return this.mIndexFile != null || this.mIndexStream != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            this.mIndex = this.mIndexFile != null ? (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping)) : (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()) : new DiskBasedBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()));
        }
        return this.mIndex;
    }

    @Override
    void close() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        if (this.mIndex != null) {
            this.mIndex.close();
        }
        this.mStream = null;
        this.mFileHeader = null;
        this.mIndex = null;
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    SAMFileReader.ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIsSeekable) {
            try {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
        }
        this.mCurrentIterator = new BAMFileIterator();
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!(sAMFileSpan instanceof BAMFileSpan)) {
            throw new IllegalStateException("BAMFileReader cannot handle this type of file span.");
        }
        this.mCurrentIterator = new BAMFileIndexIterator(((BAMFileSpan)sAMFileSpan).toCoordinateArray());
        return this.mCurrentIterator;
    }

    @Override
    SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.mFirstRecordPointer, Long.MAX_VALUE));
    }

    @Override
    CloseableIterator<SAMRecord> query(String string2, int n, int n2, boolean bl) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(string2, n, n2, bl ? QueryType.CONTAINED : QueryType.OVERLAPPING);
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> queryAlignmentStart(String string2, int n) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(string2, n, -1, QueryType.STARTING_AT);
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        try {
            long l = this.getIndex().getStartOfLastLinearBin();
            if (l != -1L) {
                this.mCompressedInputStream.seek(l);
            } else {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            this.mCurrentIterator = new BAMFileIndexUnmappedIterator();
            return this.mCurrentIterator;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException seeking to unmapped reads", iOException);
        }
    }

    private void readHeader(String string2) throws IOException {
        byte[] byArray = new byte[4];
        this.mStream.readBytes(byArray);
        if (!Arrays.equals(byArray, BAMFileConstants.BAM_MAGIC)) {
            throw new IOException("Invalid BAM file header");
        }
        int n = this.mStream.readInt();
        String string3 = this.mStream.readString(n);
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        sAMTextHeaderCodec.setValidationStringency(this.mValidationStringency);
        this.mFileHeader = sAMTextHeaderCodec.decode(new StringLineReader(string3), string2);
        int n2 = this.mStream.readInt();
        if (this.mFileHeader.getSequenceDictionary().size() > 0) {
            if (n2 != this.mFileHeader.getSequenceDictionary().size()) {
                throw new SAMFormatException("Number of sequences in text header (" + this.mFileHeader.getSequenceDictionary().size() + ") != number of sequences in binary header (" + n2 + ") for file " + string2);
            }
            for (int i = 0; i < n2; ++i) {
                SAMSequenceRecord sAMSequenceRecord = this.readSequenceRecord(string2);
                SAMSequenceRecord sAMSequenceRecord2 = this.mFileHeader.getSequence(i);
                if (!sAMSequenceRecord2.getSequenceName().equals(sAMSequenceRecord.getSequenceName())) {
                    throw new SAMFormatException("For sequence " + i + ", text and binary have different names in file " + string2);
                }
                if (sAMSequenceRecord2.getSequenceLength() == sAMSequenceRecord.getSequenceLength()) continue;
                throw new SAMFormatException("For sequence " + i + ", text and binary have different lengths in file " + string2);
            }
        } else {
            ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(this.readSequenceRecord(string2));
            }
            this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(arrayList));
        }
    }

    private SAMSequenceRecord readSequenceRecord(String string2) {
        int n = this.mStream.readInt();
        if (n <= 1) {
            throw new SAMFormatException("Invalid BAM file header: missing sequence name in file " + string2);
        }
        String string3 = this.mStream.readString(n - 1);
        this.mStream.readByte();
        int n2 = this.mStream.readInt();
        return new SAMSequenceRecord(SAMSequenceRecord.truncateSequenceName(string3), n2);
    }

    private CloseableIterator<SAMRecord> createIndexIterator(String string2, int n, int n2, QueryType queryType) {
        Object object;
        long[] lArray = null;
        SAMFileHeader sAMFileHeader = this.getFileHeader();
        int n3 = sAMFileHeader.getSequenceIndex(string2);
        if (n3 != -1) {
            object = this.getIndex();
            BAMFileSpan bAMFileSpan = object.getSpanOverlapping(n3, n, n2);
            lArray = bAMFileSpan != null ? bAMFileSpan.toCoordinateArray() : null;
        }
        object = new BAMFileIndexIterator(lArray);
        return new BAMQueryFilteringIterator((CloseableIterator<SAMRecord>)object, string2, n, n2, queryType);
    }

    private static File findIndexFile(File file) {
        File file2;
        String string2 = file.getName();
        if (string2.endsWith(".bam")) {
            String string3 = string2.substring(0, string2.length() - ".bam".length()) + ".bai";
            file2 = new File(file.getParent(), string3);
            if (file2.exists()) {
                return file2;
            }
        }
        if ((file2 = new File(file.getParent(), file.getName() + ".bai")).exists()) {
            return file2;
        }
        return null;
    }

    private class BAMFileIndexUnmappedIterator
    extends BAMFileIterator {
        private BAMFileIndexUnmappedIterator() {
            while (this.hasNext() && this.peek().getReferenceIndex() != -1) {
                this.advance();
            }
        }
    }

    private class BAMQueryFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord mNextRecord;
        private final int mReferenceIndex;
        private final int mRegionStart;
        private final int mRegionEnd;
        private final QueryType mQueryType;
        private boolean isClosed = false;

        public BAMQueryFilteringIterator(CloseableIterator<SAMRecord> closeableIterator, String string2, int n, int n2, QueryType queryType) {
            this.wrappedIterator = closeableIterator;
            SAMFileHeader sAMFileHeader = BAMFileReader.this.getFileHeader();
            this.mReferenceIndex = sAMFileHeader.getSequenceIndex(string2);
            this.mRegionStart = n;
            this.mRegionEnd = queryType == QueryType.STARTING_AT ? this.mRegionStart : (n2 <= 0 ? Integer.MAX_VALUE : n2);
            this.mQueryType = queryType;
            this.mNextRecord = this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BAMQueryFilteringIterator: no next element available");
            }
            SAMRecord sAMRecord = this.mNextRecord;
            this.mNextRecord = this.advance();
            return sAMRecord;
        }

        @Override
        public void close() {
            if (!this.isClosed) {
                if (this != BAMFileReader.this.mCurrentIterator) {
                    throw new IllegalStateException("Attempt to close non-current iterator");
                }
                BAMFileReader.this.mCurrentIterator = null;
                this.isClosed = true;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        SAMRecord advance() {
            SAMRecord sAMRecord;
            while (true) {
                int n;
                if (!this.wrappedIterator.hasNext()) {
                    return null;
                }
                sAMRecord = (SAMRecord)this.wrappedIterator.next();
                int n2 = sAMRecord.getReferenceIndex();
                if (n2 != this.mReferenceIndex) {
                    if (n2 >= 0 && n2 <= this.mReferenceIndex) continue;
                    return null;
                }
                if (this.mRegionStart == 0 && this.mRegionEnd == Integer.MAX_VALUE) {
                    return sAMRecord;
                }
                int n3 = sAMRecord.getAlignmentStart();
                if (this.mQueryType == QueryType.STARTING_AT) {
                    n = -1;
                } else {
                    int n4 = n = sAMRecord.getAlignmentEnd() != 0 ? sAMRecord.getAlignmentEnd() : n3;
                }
                if (n3 > this.mRegionEnd) {
                    return null;
                }
                if (this.mQueryType == QueryType.CONTAINED ? n3 >= this.mRegionStart && n <= this.mRegionEnd : (this.mQueryType == QueryType.OVERLAPPING ? n >= this.mRegionStart && n3 <= this.mRegionEnd : n3 == this.mRegionStart)) break;
            }
            return sAMRecord;
        }
    }

    private class BAMFileIndexIterator
    extends BAMFileIterator {
        private long[] mFilePointers;
        private int mFilePointerIndex;
        private long mFilePointerLimit;

        BAMFileIndexIterator(long[] lArray) {
            super(false);
            this.mFilePointers = null;
            this.mFilePointerIndex = 0;
            this.mFilePointerLimit = -1L;
            this.mFilePointers = lArray;
            this.advance();
        }

        @Override
        SAMRecord getNextRecord() throws IOException {
            while (BAMFileReader.this.mCompressedInputStream.getFilePointer() >= this.mFilePointerLimit) {
                if (this.mFilePointers == null || this.mFilePointerIndex >= this.mFilePointers.length) {
                    return null;
                }
                long l = this.mFilePointers[this.mFilePointerIndex++];
                long l2 = this.mFilePointers[this.mFilePointerIndex++];
                BAMFileReader.this.mCompressedInputStream.seek(l);
                this.mFilePointerLimit = l2;
            }
            return super.getNextRecord();
        }
    }

    static enum QueryType {
        CONTAINED,
        OVERLAPPING,
        STARTING_AT;

    }

    private class BAMFileIterator
    implements CloseableIterator<SAMRecord> {
        private SAMRecord mNextRecord = null;
        private final BAMRecordCodec bamRecordCodec;
        private long samRecordIndex = 0L;
        private boolean isClosed = false;

        BAMFileIterator() {
            this(true);
        }

        BAMFileIterator(boolean bl) {
            this.bamRecordCodec = new BAMRecordCodec(BAMFileReader.this.getFileHeader(), BAMFileReader.this.samRecordFactory);
            this.bamRecordCodec.setInputStream(BAMFileReader.this.mStream.getInputStream(), BAMFileReader.this.mStream.getInputFileName());
            if (bl) {
                this.advance();
            }
        }

        @Override
        public void close() {
            if (!this.isClosed) {
                if (BAMFileReader.this.mCurrentIterator != null && this != BAMFileReader.this.mCurrentIterator) {
                    throw new IllegalStateException("Attempt to close non-current iterator");
                }
                BAMFileReader.this.mCurrentIterator = null;
                this.isClosed = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            SAMRecord sAMRecord = this.mNextRecord;
            this.advance();
            return sAMRecord;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        void advance() {
            try {
                this.mNextRecord = this.getNextRecord();
                if (this.mNextRecord != null) {
                    ++this.samRecordIndex;
                    this.mNextRecord.setValidationStringency(BAMFileReader.this.mValidationStringency);
                    if (BAMFileReader.this.mValidationStringency != SAMFileReader.ValidationStringency.SILENT) {
                        List<SAMValidationError> list = this.mNextRecord.isValid();
                        SAMUtils.processValidationErrors(list, this.samRecordIndex, BAMFileReader.this.getValidationStringency());
                    }
                }
                if (BAMFileReader.this.eagerDecode && this.mNextRecord != null) {
                    this.mNextRecord.eagerDecode();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
        }

        SAMRecord getNextRecord() throws IOException {
            long l = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            SAMRecord sAMRecord = this.bamRecordCodec.decode();
            long l2 = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            if (BAMFileReader.this.mFileReader != null && sAMRecord != null) {
                sAMRecord.setFileSource(new SAMFileSource(BAMFileReader.this.mFileReader, new BAMFileSpan(new Chunk(l, l2))));
            }
            return sAMRecord;
        }

        protected SAMRecord peek() {
            return this.mNextRecord;
        }
    }
}

