/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMException;
import net.sf.samtools.seekablestream.UserPasswordInput;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPReply;

public class FTPUtils {
    static Map<String, String> userCredentials = new HashMap<String, String>();
    static int TIMEOUT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL uRL) {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(TIMEOUT);
            uRLConnection.setReadTimeout(TIMEOUT);
            inputStream = uRLConnection.getInputStream();
            boolean bl = inputStream.read() >= 0;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new SAMException("Error closing connection", iOException);
                }
            }
        }
    }

    public static long getContentLength(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(TIMEOUT);
        return uRLConnection.getInputStream().available();
    }

    public static synchronized FTPClient connect(String string2, String string3, UserPasswordInput userPasswordInput) throws IOException {
        FTPClient fTPClient = new FTPClient();
        FTPReply fTPReply = fTPClient.connect(string2);
        if (!fTPReply.isSuccess()) {
            throw new RuntimeException("Could not connect to " + string2);
        }
        String string4 = "anonymous";
        String string5 = "igv@broadinstitute.org";
        if (string3 == null) {
            string3 = userCredentials.get(string2);
        }
        if (string3 != null) {
            String[] stringArray = string3.split(":");
            string4 = stringArray[0];
            if (stringArray.length > 1) {
                string5 = stringArray[1];
            }
        }
        if (!(fTPReply = fTPClient.login(string4, string5)).isSuccess()) {
            if (userPasswordInput == null) {
                throw new RuntimeException("Login failure for host: " + string2);
            }
            userPasswordInput.setHost(string2);
            boolean bl = false;
            while (!bl && userPasswordInput.showDialog()) {
                string4 = userPasswordInput.getUser();
                string5 = userPasswordInput.getPassword();
                fTPReply = fTPClient.login(string4, string5);
                bl = fTPReply.isSuccess();
            }
            if (bl) {
                string3 = string4 + ":" + string5;
                userCredentials.put(string2, string3);
            } else {
                throw new RuntimeException("Login failure for host: " + string2);
            }
        }
        if (!(fTPReply = fTPClient.binary()).isSuccess()) {
            throw new RuntimeException("Could not set binary mode on host: " + string2);
        }
        return fTPClient;
    }
}

