/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim;

import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optim.BaseMultivariateOptimizer;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultiStartMultivariateOptimizer<PAIR>
extends BaseMultivariateOptimizer<PAIR> {
    private final BaseMultivariateOptimizer<PAIR> optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int initialGuessIndex = -1;

    public BaseMultiStartMultivariateOptimizer(BaseMultivariateOptimizer<PAIR> optimizer, int starts2, RandomVectorGenerator generator) {
        super(optimizer.getConvergenceChecker());
        if (starts2 < 1) {
            throw new NotStrictlyPositiveException(starts2);
        }
        this.optimizer = optimizer;
        this.starts = starts2;
        this.generator = generator;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public abstract PAIR[] getOptima();

    @Override
    public PAIR optimize(OptimizationData ... optData) {
        this.optimData = optData;
        return super.optimize(optData);
    }

    @Override
    protected PAIR doOptimize() {
        for (int i = 0; i < this.optimData.length; ++i) {
            if (this.optimData[i] instanceof MaxEval) {
                this.optimData[i] = null;
                this.maxEvalIndex = i;
            }
            if (!(this.optimData[i] instanceof InitialGuess)) continue;
            this.optimData[i] = null;
            this.initialGuessIndex = i;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException();
        }
        if (this.initialGuessIndex == -1) {
            throw new MathIllegalStateException();
        }
        RuntimeException lastException = null;
        this.totalEvaluations = 0;
        this.clear();
        int maxEval = this.getMaxEvaluations();
        double[] min2 = this.getLowerBound();
        double[] max2 = this.getUpperBound();
        double[] startPoint = this.getStartPoint();
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(maxEval - this.totalEvaluations);
                double[] s2 = null;
                if (i == 0) {
                    s2 = startPoint;
                } else {
                    int attempts = 0;
                    while (s2 == null) {
                        if (attempts++ >= this.getMaxEvaluations()) {
                            throw new TooManyEvaluationsException(this.getMaxEvaluations());
                        }
                        s2 = this.generator.nextVector();
                        for (int k = 0; s2 != null && k < s2.length; ++k) {
                            if (!(min2 != null && s2[k] < min2[k]) && (max2 == null || !(s2[k] > max2[k]))) continue;
                            s2 = null;
                        }
                    }
                }
                this.optimData[this.initialGuessIndex] = new InitialGuess(s2);
                PAIR result2 = this.optimizer.optimize(this.optimData);
                this.store(result2);
            }
            catch (RuntimeException mue) {
                lastException = mue;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        PAIR[] optima = this.getOptima();
        if (optima.length == 0) {
            throw lastException;
        }
        return optima[0];
    }

    protected abstract void store(PAIR var1);

    protected abstract void clear();
}

