/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.readers.LocationAware;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broad.tribble.util.ParsingUtils;

public class IndexFactory {
    public static Index loadIndex(String string2) {
        Index index = null;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = string2.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(ParsingUtils.openInputStream(string2)), 512000) : new BufferedInputStream(ParsingUtils.openInputStream(string2), 512000);
            filterInputStream = new LittleEndianInputStream(inputStream);
            int n = ((LittleEndianInputStream)filterInputStream).readInt();
            int n2 = ((LittleEndianInputStream)filterInputStream).readInt();
            Class clazz = IndexType.getIndexType(n2).getIndexType();
            index = (Index)clazz.newInstance();
            index.read((LittleEndianInputStream)filterInputStream);
        }
        catch (IOException iOException) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", string2, iOException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return index;
    }

    public static Index createLinearIndex(File file, FeatureCodec featureCodec) {
        return IndexFactory.createIndex(file, featureCodec, IndexType.LINEAR);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createLinearIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, int n) {
        return IndexFactory.createIndex(file, featureCodec, IndexType.LINEAR, n);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIntervalIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec) {
        return IndexFactory.createIndex(file, featureCodec, IndexType.INTERVAL_TREE);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIntervalIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, int n) {
        return IndexFactory.createIndex(file, featureCodec, IndexType.INTERVAL_TREE, n);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec) {
        return IndexFactory.createDynamicIndex(file, featureCodec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, IndexType indexType) {
        return IndexFactory.createIndex(file, featureCodec, indexType, indexType.getDefaultBinSize());
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, IndexType indexType, int n) {
        if (!indexType.canCreate()) {
            throw new TribbleException("Tribble can only read, not create indices of type " + indexType.name());
        }
        IndexCreator indexCreator = indexType.getIndexCreator();
        indexCreator.initialize(file, n);
        return IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), indexCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndex(Index index, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            index.write((LittleEndianOutputStream)filterOutputStream);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, IndexBalanceApproach indexBalanceApproach) {
        DynamicIndexCreator dynamicIndexCreator = new DynamicIndexCreator(indexBalanceApproach);
        dynamicIndexCreator.initialize(file, dynamicIndexCreator.defaultBinSize());
        return IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), dynamicIndexCreator);
    }

    private static Index createIndex(File file, FeatureIterator featureIterator, IndexCreator indexCreator) {
        Feature feature = null;
        HashMap<String, Feature> hashMap = new HashMap<String, Feature>(40);
        while (featureIterator.hasNext()) {
            String string2;
            long l = featureIterator.getPosition();
            Feature feature2 = featureIterator.next();
            IndexFactory.checkSorted(file, feature, feature2);
            String string3 = feature2.getChr();
            String string4 = string2 = feature != null ? feature.getChr() : null;
            if (!string3.equals(string2)) {
                if (hashMap.containsKey(string3)) {
                    String string5 = "Input file must have contiguous chromosomes.";
                    string5 = string5 + " Saw feature " + IndexFactory.featToString((Feature)hashMap.get(string3));
                    string5 = string5 + " followed later by " + IndexFactory.featToString(feature);
                    string5 = string5 + " and then " + IndexFactory.featToString(feature2);
                    throw new TribbleException.MalformedFeatureFile(string5, file.getAbsolutePath());
                }
                hashMap.put(string3, feature2);
            }
            indexCreator.addFeature(feature2, l);
            feature = feature2;
        }
        featureIterator.close();
        return indexCreator.finalizeIndex(featureIterator.getPosition());
    }

    private static String featToString(Feature feature) {
        return feature.getChr() + ":" + feature.getStart() + "-" + feature.getEnd();
    }

    private static void checkSorted(File file, Feature feature, Feature feature2) {
        if (feature != null && feature2.getStart() < feature.getStart() && feature.getChr().equals(feature2.getChr())) {
            throw new TribbleException.MalformedFeatureFile("Input file is not sorted by start position. \nWe saw a record with a start of " + feature2.getChr() + ":" + feature2.getStart() + " after a record with a start of " + feature.getChr() + ":" + feature.getStart(), file.getAbsolutePath());
        }
    }

    static class FeatureIterator<FEATURE_TYPE extends Feature, SOURCE>
    implements CloseableTribbleIterator<Feature> {
        private SOURCE source;
        private Feature nextFeature;
        private final FeatureCodec<FEATURE_TYPE, SOURCE> codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File file, FeatureCodec<FEATURE_TYPE, SOURCE> featureCodec) {
            this.codec = featureCodec;
            this.inputFile = file;
            FeatureCodecHeader featureCodecHeader = this.readHeader();
            this.source = featureCodec.makeIndexableSourceFromStream(this.initStream(file, featureCodecHeader.getHeaderEnd()));
            this.readNextFeature();
        }

        private FeatureCodecHeader readHeader() {
            try {
                SOURCE SOURCE = this.codec.makeSourceFromStream(this.initStream(this.inputFile, 0L));
                FeatureCodecHeader featureCodecHeader = this.codec.readHeader(SOURCE);
                this.codec.close(SOURCE);
                return featureCodecHeader;
            }
            catch (IOException iOException) {
                throw new TribbleException.InvalidHeader("Error reading header " + iOException.getMessage());
            }
        }

        private PositionalBufferedStream initStream(File file, long l) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                PositionalBufferedStream positionalBufferedStream = new PositionalBufferedStream(fileInputStream);
                if (l > 0L) {
                    positionalBufferedStream.skip(l);
                }
                return positionalBufferedStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", file.getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", file.getAbsolutePath(), iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature feature = this.nextFeature;
            this.readNextFeature();
            return feature;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : ((LocationAware)this.source).getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.codec.close(this.source);
        }

        private void readNextFeature() {
            this.cachedPosition = ((LocationAware)this.source).getPosition();
            try {
                this.nextFeature = null;
                while (this.nextFeature == null && !this.codec.isDone(this.source)) {
                    this.nextFeature = this.codec.decodeLoc(this.source);
                }
            }
            catch (IOException iOException) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), iOException);
            }
        }
    }

    public static enum IndexType {
        LINEAR(1, LinearIndexCreator.class, LinearIndex.class, LinearIndexCreator.DEFAULT_BIN_WIDTH),
        INTERVAL_TREE(2, IntervalIndexCreator.class, IntervalTreeIndex.class, IntervalIndexCreator.DEFAULT_FEATURE_COUNT),
        TABIX(3, null, null, -1);

        private final int indexValue;
        private final Class<IndexCreator> indexCreatorClass;
        private final int defaultBinSize;
        private final Class<Index> indexType;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public IndexCreator getIndexCreator() {
            try {
                return this.indexCreatorClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), illegalAccessException);
            }
        }

        public boolean canCreate() {
            return this.indexCreatorClass != null;
        }

        private IndexType(int n2, Class clazz, Class clazz2, int n3) {
            this.indexValue = n2;
            this.indexCreatorClass = clazz;
            this.indexType = clazz2;
            this.defaultBinSize = n3;
        }

        public int getHeaderValue() {
            return this.indexValue;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public static IndexType getIndexType(int n) {
            for (IndexType indexType : IndexType.values()) {
                if (indexType.indexValue != n) continue;
                return indexType;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type value" + n);
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

