/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.BarcodeScore;
import org.broadinstitute.rnai.poolq.impl.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.data.BarcodeToReadCounts;
import org.broadinstitute.rnai.poolq.impl.data.CoocurrenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.TempDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoocurrenceTempDatabase
extends TempDatabase
implements CoocurrenceDatabase {
    private static final Logger logger = LoggerFactory.getLogger(CoocurrenceTempDatabase.class);
    private final PrimaryIndex<String, BarcodeToReadCounts> constructIdToConditionToReadCountMapIndex;
    private final List<EntityCursor<BarcodeToReadCounts>> openCursors = new ArrayList<EntityCursor<BarcodeToReadCounts>>();

    public CoocurrenceTempDatabase() {
        this.constructIdToConditionToReadCountMapIndex = this.getPrimaryIndex(String.class, BarcodeToReadCounts.class);
    }

    @Override
    public Iterator<BarcodeScore> iterator() {
        try {
            this.setCachePercent(30);
            final EntityCursor entityCursor = this.constructIdToConditionToReadCountMapIndex.entities();
            entityCursor.setCacheMode(CacheMode.EVICT_LN);
            this.openCursors.add(entityCursor);
            return new ReadOnlyIterator<BarcodeScore>(){
                private final Iterator<BarcodeToReadCounts> iterator;
                {
                    this.iterator = entityCursor.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public BarcodeScore next() {
                    return this.iterator.next();
                }
            };
        }
        catch (DatabaseException databaseException) {
            throw new TempDatabaseException(databaseException);
        }
    }

    @Override
    public void close() {
        logger.debug("Closing cursors open on temp database");
        for (EntityCursor<BarcodeToReadCounts> entityCursor : this.openCursors) {
            entityCursor.close();
        }
        logger.debug("Close the temp database.");
        super.close();
        logger.debug("Temp database closed.");
    }

    @Override
    public void increment(String string2, String string3) {
        try {
            BarcodeToReadCounts barcodeToReadCounts = this.findOrCreateBarcodeToReadCounts(string2);
            this.incrementReadCountForBarcode(barcodeToReadCounts, string3);
            this.constructIdToConditionToReadCountMapIndex.put(barcodeToReadCounts);
        }
        catch (DatabaseException databaseException) {
            logger.error("Caught database exception while counting construct barcode {} and sample barcode {}", (Object)string2, (Object)string3);
            logger.error("Exception was", databaseException);
            throw new TempDatabaseException(databaseException);
        }
    }

    @Override
    public Integer getScore(String string2, String string3) {
        BarcodeToReadCounts barcodeToReadCounts = this.findOrCreateBarcodeToReadCounts(string2);
        return barcodeToReadCounts.getReadCountsByBarcode().get(string3);
    }

    @Override
    public Map<String, Integer> getScoresBySampleForConstruct(String string2) {
        BarcodeToReadCounts barcodeToReadCounts = this.findOrCreateBarcodeToReadCounts(string2);
        return Collections.unmodifiableMap(barcodeToReadCounts.getReadCountsByBarcode());
    }

    private BarcodeToReadCounts findOrCreateBarcodeToReadCounts(String string2) throws DatabaseException {
        BarcodeToReadCounts barcodeToReadCounts = this.constructIdToConditionToReadCountMapIndex.get(string2);
        if (barcodeToReadCounts == null) {
            barcodeToReadCounts = new BarcodeToReadCounts();
            barcodeToReadCounts.setBarcode(string2);
        }
        return barcodeToReadCounts;
    }

    private void incrementReadCountForBarcode(BarcodeToReadCounts barcodeToReadCounts, String string2) {
        barcodeToReadCounts.incrementCount(string2);
    }
}

