/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.TextUtils;
import org.broadinstitute.rnai.poolq.impl.data.ScoreAggregator;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizer;
import org.broadinstitute.rnai.poolq.impl.filewriter.MatrixFileWriter;

public class CorrelationFileWriter
extends MatrixFileWriter {
    private static final LogNormalizer logNormalizer = new LogNormalizer();
    private static final DecimalFormat ROUND_HUNDREDTHS = new DecimalFormat("0.00");

    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        for (String string2 : poolQScores.getConditions()) {
            printWriter.append('\t').append(string2);
        }
        printWriter.append('\n');
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        PearsonsCorrelation pearsonsCorrelation = new PearsonsCorrelation();
        RealMatrix realMatrix = pearsonsCorrelation.computeCorrelationMatrix(this.getNormalizedScores(poolQScores));
        List<String> list = poolQScores.getConditions();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            String[] stringArray = this.getRoundedRowData(realMatrix.getRow(i));
            String string3 = string2 + '\t' + TextUtils.join(stringArray, '\t');
            printWriter.append(string3);
            printWriter.append('\n');
        }
    }

    private String[] getRoundedRowData(double[] dArray) {
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = this.decimalOf(dArray[i]);
        }
        return stringArray;
    }

    double[][] getNormalizedScores(PoolQScores poolQScores) {
        ScoreAggregator scoreAggregator = new ScoreAggregator(poolQScores.getConditionToBarcodeMap());
        int n = poolQScores.getConditions().size();
        int n2 = poolQScores.getConstructBarcodes().size();
        double[][] dArray = new double[n2][n];
        int n3 = 0;
        for (String string2 : poolQScores.getConstructBarcodes()) {
            Map<String, Integer> map2 = poolQScores.getScoresBySampleForConstruct(string2);
            List<Integer> list = scoreAggregator.getScoresListByCondition(map2, poolQScores.getConditions());
            int n4 = 0;
            for (String string3 : poolQScores.getConditions()) {
                double d;
                Integer n5 = poolQScores.getMatchingConstructReadCountForCondition(string3);
                int n6 = list.get(n4);
                dArray[n3][n4] = d = logNormalizer.normalize(n6, n5).doubleValue();
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }

    String decimalOf(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        return ROUND_HUNDREDTHS.format(d);
    }
}

