/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.utils.GeneralUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class GenotypeLikelihoods {
    private static final int NUM_LIKELIHOODS_CACHE_N_ALLELES = 5;
    private static final int NUM_LIKELIHOODS_CACHE_PLOIDY = 10;
    private static final int[][] numLikelihoodCache = new int[5][10];
    public static final int MAX_PL = Integer.MAX_VALUE;
    private double[] log10Likelihoods = null;
    private String likelihoodsAsString_PLs = null;
    public static final int MAX_ALT_ALLELES_THAT_CAN_BE_GENOTYPED = 50;
    private static final GenotypeLikelihoodsAllelePair[] PLIndexToAlleleIndex;
    protected static final int[] PLindexConversion;

    public static final GenotypeLikelihoods fromPLField(String string2) {
        return new GenotypeLikelihoods(string2);
    }

    @Deprecated
    public static final GenotypeLikelihoods fromGLField(String string2) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.parseDeprecatedGLString(string2));
    }

    public static final GenotypeLikelihoods fromLog10Likelihoods(double[] dArray) {
        return new GenotypeLikelihoods(dArray);
    }

    public static final GenotypeLikelihoods fromPLs(int[] nArray) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.PLsToGLs(nArray));
    }

    private GenotypeLikelihoods(String string2) {
        this.likelihoodsAsString_PLs = string2;
    }

    private GenotypeLikelihoods(double[] dArray) {
        this.log10Likelihoods = dArray;
    }

    public double[] getAsVector() {
        if (this.log10Likelihoods == null) {
            this.log10Likelihoods = GenotypeLikelihoods.parsePLsIntoLikelihoods(this.likelihoodsAsString_PLs);
        }
        return this.log10Likelihoods;
    }

    public int[] getAsPLs() {
        double[] dArray = this.getAsVector();
        return dArray == null ? null : GenotypeLikelihoods.GLsToPLs(dArray);
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.likelihoodsAsString_PLs == null) {
            if (this.log10Likelihoods == null) {
                throw new TribbleException("BUG: Attempted to get likelihoods as strings and neither the vector nor the string is set!");
            }
            this.likelihoodsAsString_PLs = GenotypeLikelihoods.convertLikelihoodsToPLString(this.log10Likelihoods);
        }
        return this.likelihoodsAsString_PLs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GenotypeLikelihoods)) {
            return false;
        }
        GenotypeLikelihoods genotypeLikelihoods = (GenotypeLikelihoods)object;
        return Arrays.equals(this.getAsPLs(), genotypeLikelihoods.getAsPLs());
    }

    public EnumMap<GenotypeType, Double> getAsMap(boolean bl) {
        double[] dArray;
        double[] dArray2 = dArray = bl ? GeneralUtils.normalizeFromLog10(this.getAsVector()) : this.getAsVector();
        if (dArray == null) {
            return null;
        }
        EnumMap<GenotypeType, Double> enumMap = new EnumMap<GenotypeType, Double>(GenotypeType.class);
        enumMap.put(GenotypeType.HOM_REF, dArray[GenotypeType.HOM_REF.ordinal() - 1]);
        enumMap.put(GenotypeType.HET, dArray[GenotypeType.HET.ordinal() - 1]);
        enumMap.put(GenotypeType.HOM_VAR, dArray[GenotypeType.HOM_VAR.ordinal() - 1]);
        return enumMap;
    }

    @Deprecated
    public double getLog10GQ(GenotypeType genotypeType) {
        return GenotypeLikelihoods.getGQLog10FromLikelihoods(genotypeType.ordinal() - 1, this.getAsVector());
    }

    @Requires(value={"genotypeAlleles != null", "genotypeAlleles.size()==2", "contextAlleles != null", "contextAlleles.size() >= 1"})
    private double getLog10GQ(List<Allele> list, List<Allele> list2) {
        int n = list2.indexOf(list.get(0));
        int n2 = list2.indexOf(list.get(1));
        int n3 = GenotypeLikelihoods.calculatePLindex(n, n2);
        return GenotypeLikelihoods.getGQLog10FromLikelihoods(n3, this.getAsVector());
    }

    public double getLog10GQ(Genotype genotype, List<Allele> list) {
        return this.getLog10GQ(genotype.getAlleles(), list);
    }

    public double getLog10GQ(Genotype genotype, VariantContext variantContext) {
        return this.getLog10GQ(genotype, variantContext.getAlleles());
    }

    public static double getGQLog10FromLikelihoods(int n, double[] dArray) {
        if (dArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (i == n || !(dArray[i] >= d)) continue;
            d = dArray[i];
        }
        if ((d = dArray[n] - d) < 0.0) {
            double[] dArray2 = GeneralUtils.normalizeFromLog10(dArray);
            double d2 = dArray2[n];
            return Math.log10(1.0 - d2);
        }
        return -1.0 * d;
    }

    private static final double[] parsePLsIntoLikelihoods(String string2) {
        if (!string2.equals(".")) {
            String[] stringArray = string2.split(",");
            double[] dArray = new double[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    dArray[i] = (double)Integer.parseInt(stringArray[i]) / -10.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TribbleException("The GL/PL tag contains non-integer values: " + string2);
            }
            return dArray;
        }
        return null;
    }

    private static final double[] parseDeprecatedGLString(String string2) {
        if (!string2.equals(".")) {
            String[] stringArray = string2.split(",");
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = Double.parseDouble(stringArray[i]);
            }
            return dArray;
        }
        return null;
    }

    private static final String convertLikelihoodsToPLString(double[] dArray) {
        if (dArray == null) {
            return ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int n : GenotypeLikelihoods.GLsToPLs(dArray)) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    private static final int[] GLsToPLs(double[] dArray) {
        int[] nArray = new int[dArray.length];
        double d = GenotypeLikelihoods.maxPL(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)Math.round(Math.min(-10.0 * (dArray[i] - d), 2.147483647E9));
        }
        return nArray;
    }

    private static final double maxPL(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : dArray) {
            d = Math.max(d, d2);
        }
        return d;
    }

    private static final double[] PLsToGLs(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = (double)nArray[i] / -10.0;
        }
        return dArray;
    }

    private static GenotypeLikelihoodsAllelePair[] calculatePLcache(int n) {
        int n2;
        int n3 = GenotypeLikelihoods.numLikelihoods(1 + n, 2);
        GenotypeLikelihoodsAllelePair[] genotypeLikelihoodsAllelePairArray = new GenotypeLikelihoodsAllelePair[n3];
        for (n2 = 0; n2 <= n; ++n2) {
            for (int i = n2; i <= n; ++i) {
                genotypeLikelihoodsAllelePairArray[GenotypeLikelihoods.calculatePLindex((int)n2, (int)i)] = new GenotypeLikelihoodsAllelePair(n2, i);
            }
        }
        for (n2 = 0; n2 < genotypeLikelihoodsAllelePairArray.length; ++n2) {
            if (genotypeLikelihoodsAllelePairArray[n2] != null) continue;
            throw new IllegalStateException("BUG: cache entry " + n2 + " is unexpected null");
        }
        return genotypeLikelihoodsAllelePairArray;
    }

    private static final int calcNumLikelihoods(int n, int n2) {
        if (n == 1) {
            return 1;
        }
        if (n2 == 1) {
            return n;
        }
        int n3 = 0;
        for (int i = 0; i <= n2; ++i) {
            n3 += GenotypeLikelihoods.calcNumLikelihoods(n - 1, n2 - i);
        }
        return n3;
    }

    @Requires(value={"ploidy > 0", "numAlleles > 0"})
    @Ensures(value={"result > 0"})
    public static int numLikelihoods(int n, int n2) {
        if (n < 5 && n2 < 10) {
            return numLikelihoodCache[n][n2];
        }
        return GenotypeLikelihoods.calcNumLikelihoods(n, n2);
    }

    public static int calculatePLindex(int n, int n2) {
        return n2 * (n2 + 1) / 2 + n;
    }

    public static GenotypeLikelihoodsAllelePair getAllelePair(int n) {
        if (n >= PLIndexToAlleleIndex.length) {
            throw new IllegalStateException("Internal limitation: cannot genotype more than 50 alleles");
        }
        return PLIndexToAlleleIndex[n];
    }

    @Deprecated
    public static GenotypeLikelihoodsAllelePair getAllelePairUsingDeprecatedOrdering(int n) {
        return GenotypeLikelihoods.getAllelePair(PLindexConversion[n]);
    }

    public static int[] getPLIndecesOfAlleles(int n, int n2) {
        int[] nArray = new int[]{GenotypeLikelihoods.calculatePLindex(n, n), GenotypeLikelihoods.calculatePLindex(n, n2), GenotypeLikelihoods.calculatePLindex(n2, n2)};
        return nArray;
    }

    static {
        for (int i = 1; i < 5; ++i) {
            for (int j = 1; j < 10; ++j) {
                GenotypeLikelihoods.numLikelihoodCache[i][j] = GenotypeLikelihoods.calcNumLikelihoods(i, j);
            }
        }
        PLIndexToAlleleIndex = GenotypeLikelihoods.calculatePLcache(50);
        PLindexConversion = new int[]{0, 1, 3, 6, 2, 4, 7, 5, 8, 9};
    }

    public static class GenotypeLikelihoodsAllelePair {
        public final int alleleIndex1;
        public final int alleleIndex2;

        public GenotypeLikelihoodsAllelePair(int n, int n2) {
            this.alleleIndex1 = n;
            this.alleleIndex2 = n2;
        }
    }
}

