/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.txn.HandleLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements Closeable {
    protected EnvironmentImpl envImpl;
    private TransactionConfig defaultTxnConfig;
    private EnvironmentMutableConfig handleConfig;
    private final EnvironmentConfig appliedFinalConfig;
    private final Set<Database> referringDbs;
    private final Set<Transaction> referringDbTxns;
    public static final String CLEANER_NAME = "Cleaner";
    public static final String INCOMP_NAME = "INCompressor";
    public static final String CHECKPOINTER_NAME = "Checkpointer";

    public Environment(File envHome, EnvironmentConfig configuration) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
        this(envHome, configuration, true, null, null);
    }

    protected Environment(File envHome, EnvironmentConfig configuration, RepConfigProxy repConfigProxy, EnvironmentImpl envImplParam) {
        this(envHome, configuration, true, repConfigProxy, envImplParam);
    }

    Environment(File envHome) {
        this(envHome, null, false, null, null);
    }

    protected Environment(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy, EnvironmentImpl envImplParam) {
        assert (openIfNeeded || envConfig == null || envImplParam != null);
        this.envImpl = null;
        this.referringDbs = Collections.synchronizedSet(new HashSet());
        this.referringDbTxns = Collections.synchronizedSet(new HashSet());
        DatabaseUtil.checkForNullParam(envHome, "envHome");
        this.appliedFinalConfig = this.setupHandleConfig(envHome, envConfig, repConfigProxy);
        this.envImpl = envImplParam != null ? envImplParam : this.makeEnvironmentImpl(envHome, envConfig, openIfNeeded, repConfigProxy);
    }

    protected EnvironmentImpl makeEnvironmentImpl(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy) {
        this.envImpl = DbEnvPool.getInstance().getEnvironment(envHome, this.appliedFinalConfig, envConfig != null, openIfNeeded, this.setupRepConfig(envHome, repConfigProxy, envConfig));
        if (this.envImpl != null) {
            this.envImpl.registerMBean(this);
        }
        return this.envImpl;
    }

    private EnvironmentConfig setupHandleConfig(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfig) throws IllegalArgumentException {
        EnvironmentConfig baseConfig = envConfig == null ? EnvironmentConfig.DEFAULT : envConfig;
        EnvironmentConfig useConfig = baseConfig.clone();
        if (useConfig.getLoadPropertyFile()) {
            DbConfigManager.applyFileConfig(envHome, DbInternal.getProps(useConfig), false);
        }
        this.copyToHandleConfig(useConfig, useConfig, repConfig);
        return useConfig;
    }

    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws DatabaseException {
        if (this.envImpl == null) {
            return;
        }
        if (!this.envImpl.isValid()) {
            try {
                this.envImpl.closeAfterInvalid();
                Object var2_1 = null;
                this.envImpl = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.envImpl = null;
                throw throwable;
            }
            return;
        }
        StringBuilder errors = new StringBuilder();
        try {
            this.checkForCloseErrors(errors);
            try {
                this.envImpl.close();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Environment encountered exception: ");
                errors.append(e).append("\n");
            }
            if (errors.length() > 0) {
                throw new IllegalStateException(errors.toString());
            }
            Object var4_6 = null;
            this.envImpl = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.envImpl = null;
            throw throwable;
        }
    }

    synchronized void closeInternalHandle() {
        StringBuilder errors = new StringBuilder();
        this.checkForCloseErrors(errors);
        if (errors.length() > 0) {
            throw new IllegalStateException(errors.toString());
        }
    }

    private void checkForCloseErrors(StringBuilder errors) {
        this.checkOpenDbs(errors);
        this.checkOpenTxns(errors);
        if (!this.isInternalHandle()) {
            this.checkOpenXATransactions(errors);
        }
    }

    private void checkOpenXATransactions(StringBuilder errors) {
        Xid[] openXids = this.envImpl.getTxnManager().XARecover();
        if (openXids != null && openXids.length > 0) {
            errors.append("There ");
            int nXATxns = openXids.length;
            if (nXATxns == 1) {
                errors.append("is 1 existing XA transaction opened");
                errors.append(" in the Environment.\n");
                errors.append("It");
            } else {
                errors.append("are ");
                errors.append(nXATxns);
                errors.append(" existing transactions opened in");
                errors.append(" the Environment.\n");
                errors.append("They");
            }
            errors.append(" will be left open ...\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenTxns(StringBuilder errors) {
        Iterator<Transaction> iter2;
        int nTxns;
        int n = nTxns = this.referringDbTxns == null ? 0 : this.referringDbTxns.size();
        if (nTxns == 0) {
            return;
        }
        Set<Transaction> set = this.referringDbTxns;
        synchronized (set) {
            iter2 = new HashSet<Transaction>(this.referringDbTxns).iterator();
        }
        errors.append("There ");
        if (nTxns == 1) {
            errors.append("is 1 existing transaction opened");
            errors.append(" against the Environment.\n");
        } else {
            errors.append("are ");
            errors.append(nTxns);
            errors.append(" existing transactions opened against");
            errors.append(" the Environment.\n");
        }
        errors.append("Aborting open transactions ...\n");
        while (iter2.hasNext()) {
            Transaction txn = iter2.next();
            try {
                errors.append("aborting " + txn);
                txn.abort();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile aborting transaction ");
                errors.append(txn.getId());
                errors.append(" encountered exception: ");
                errors.append(e).append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenDbs(StringBuilder errors) {
        Iterator<Database> iter2;
        if (this.referringDbs.isEmpty()) {
            return;
        }
        Set<Database> set = this.referringDbs;
        synchronized (set) {
            iter2 = new HashSet<Database>(this.referringDbs).iterator();
        }
        int nOpenUserDbs = 0;
        while (iter2.hasNext()) {
            String dbName = "";
            try {
                Database db = iter2.next();
                dbName = db.getDebugName();
                if (!db.getDatabaseImpl().isInternalDb()) {
                    ++nOpenUserDbs;
                    errors.append("Unclosed Database: ");
                    errors.append(dbName).append("\n");
                }
                db.close();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Database ");
                errors.append(dbName);
                errors.append(" encountered exception: ");
                errors.append(e).append("\n");
            }
        }
        if (nOpenUserDbs > 0) {
            errors.append("Databases left open: ");
            errors.append(nOpenUserDbs).append("\n");
        }
    }

    public synchronized Database openDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, IllegalArgumentException, IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            if (dbConfig == null) {
                dbConfig = DatabaseConfig.DEFAULT;
            }
            Database db = new Database(this);
            this.setupDatabase(txn, db, databaseName, dbConfig, false);
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    synchronized Database openInternalDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException {
        assert (DbTree.isReservedDbName(databaseName)) : databaseName;
        Database db = new Database(this);
        this.setupDatabase(txn, db, databaseName, dbConfig, true);
        return db;
    }

    public synchronized SecondaryDatabase openSecondaryDatabase(Transaction txn, String databaseName, Database primaryDatabase, SecondaryConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, DatabaseException, IllegalArgumentException, IllegalStateException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            if (dbConfig == null) {
                dbConfig = SecondaryConfig.DEFAULT;
            }
            SecondaryDatabase db = new SecondaryDatabase(this, dbConfig, primaryDatabase);
            this.setupDatabase(txn, db, databaseName, dbConfig, false);
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupDatabase(Transaction txn, Database newDb, String databaseName, DatabaseConfig dbConfig, boolean isInternalDb) throws DatabaseNotFoundException, DatabaseExistsException {
        Locker locker;
        boolean operationOk;
        block10: {
            this.checkEnv();
            DatabaseUtil.checkForNullParam(databaseName, "databaseName");
            LoggerUtils.envLogMsg(Level.FINEST, this.envImpl, "Environment.open:  name=" + databaseName + " dbConfig=" + dbConfig);
            boolean autoTxnIsReplicated = DbInternal.getReplicated(dbConfig) && this.envImpl.isReplicated();
            dbConfig.validateOnDbOpen(databaseName, autoTxnIsReplicated);
            this.validateDbConfigAgainstEnv(dbConfig, databaseName, isInternalDb);
            this.envImpl.criticalEviction(false);
            DatabaseImpl database = null;
            operationOk = false;
            HandleLocker handleLocker = null;
            locker = LockerFactory.getWritableLocker(this, txn, isInternalDb, dbConfig.getTransactional(), autoTxnIsReplicated, null);
            try {
                boolean firstWriteHandle;
                boolean databaseExists;
                handleLocker = newDb.initHandleLocker(this.envImpl, locker);
                database = this.envImpl.getDbTree().getDb(locker, databaseName, handleLocker);
                boolean dbCreated = false;
                boolean bl = databaseExists = database != null && !database.isDeleted();
                if (databaseExists) {
                    if (dbConfig.getAllowCreate() && dbConfig.getExclusiveCreate()) {
                        throw new DatabaseExistsException("Database " + databaseName + " already exists");
                    }
                    newDb.initExisting(this, locker, database, databaseName, dbConfig);
                } else {
                    this.envImpl.getDbTree().releaseDb(database);
                    database = null;
                    if (!isInternalDb && DbTree.isReservedDbName(databaseName)) {
                        throw new IllegalArgumentException(databaseName + " is a reserved database name.");
                    }
                    if (!dbConfig.getAllowCreate()) {
                        throw new DatabaseNotFoundException("Database " + databaseName + " not found.");
                    }
                    database = newDb.initNew(this, locker, databaseName, dbConfig);
                    dbCreated = true;
                }
                operationOk = true;
                this.addReferringHandle(newDb);
                locker.addOpenedDatabase(newDb);
                boolean bl2 = firstWriteHandle = newDb.isWritable() && newDb.getDatabaseImpl().noteWriteHandleOpen() == 1;
                if (dbCreated || firstWriteHandle) {
                    TriggerManager.runOpenTriggers(locker, newDb, dbCreated);
                }
                Object var15_14 = null;
                if (operationOk) break block10;
                this.envImpl.getDbTree().releaseDb(database);
                if (handleLocker == null) break block10;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (!operationOk) {
                    this.envImpl.getDbTree().releaseDb(database);
                    if (handleLocker != null) {
                        handleLocker.operationEnd(false);
                    }
                }
                locker.operationEnd(operationOk);
                throw throwable;
            }
            handleLocker.operationEnd(false);
        }
        locker.operationEnd(operationOk);
    }

    private void validateDbConfigAgainstEnv(DatabaseConfig dbConfig, String databaseName, boolean isInternalDb) throws IllegalArgumentException {
        if (this.envImpl.isReplicated() && dbConfig.getReplicated() && !dbConfig.getReadOnly() && !dbConfig.getTransactional()) {
            throw new IllegalArgumentException("Read/Write Database instances for replicated database " + databaseName + " must be transactional.");
        }
        if (!isInternalDb && dbConfig.getTransactional() && !this.envImpl.isTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " transactionally, but parent Environment is" + " not transactional");
        }
        if (this.envImpl.isReadOnly() && !dbConfig.getReadOnly()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " as writable but parent Environment is read only ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDatabase(Transaction txn, String databaseName) throws DatabaseNotFoundException {
        DatabaseImpl dbImpl;
        Locker locker;
        block6: {
            this.checkHandleIsValid();
            DatabaseUtil.checkForNullParam(databaseName, "databaseName");
            this.checkEnv();
            this.checkWritable();
            boolean autoTxnIsReplicated = this.envImpl.isReplicated();
            locker = null;
            dbImpl = null;
            try {
                try {
                    locker = LockerFactory.getWritableLocker(this, txn, false, this.envImpl.isTransactional(), autoTxnIsReplicated, null);
                    dbImpl = this.envImpl.getDbTree().dbRemove(locker, databaseName, null);
                }
                catch (Error E) {
                    this.envImpl.invalidate(E);
                    throw E;
                }
                Object var8_6 = null;
                if (dbImpl == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (dbImpl != null) {
                    TriggerManager.runRemoveTriggers(locker, dbImpl);
                }
                if (locker == null) throw throwable;
                locker.operationEnd(dbImpl != null);
                throw throwable;
            }
            TriggerManager.runRemoveTriggers(locker, dbImpl);
        }
        if (locker == null) return;
        locker.operationEnd(dbImpl != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renameDatabase(Transaction txn, String databaseName, String newName) throws DatabaseNotFoundException {
        DatabaseImpl dbImpl;
        Locker locker;
        block6: {
            DatabaseUtil.checkForNullParam(databaseName, "databaseName");
            DatabaseUtil.checkForNullParam(newName, "newName");
            this.checkHandleIsValid();
            this.checkEnv();
            this.checkWritable();
            locker = null;
            dbImpl = null;
            try {
                try {
                    locker = LockerFactory.getWritableLocker(this, txn, false, this.envImpl.isTransactional(), this.envImpl.isReplicated(), null);
                    dbImpl = this.envImpl.getDbTree().dbRename(locker, databaseName, newName);
                }
                catch (Error E) {
                    this.envImpl.invalidate(E);
                    throw E;
                }
                Object var8_6 = null;
                if (dbImpl == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (dbImpl != null) {
                    TriggerManager.runRenameTriggers(locker, dbImpl, newName);
                }
                if (locker == null) throw throwable;
                locker.operationEnd(dbImpl != null);
                throw throwable;
            }
            TriggerManager.runRenameTriggers(locker, dbImpl, newName);
        }
        if (locker == null) return;
        locker.operationEnd(dbImpl != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long truncateDatabase(Transaction txn, String databaseName, boolean returnCount) throws DatabaseNotFoundException {
        DbTree.TruncateDbResult result2;
        Locker locker;
        block8: {
            this.checkHandleIsValid();
            DatabaseUtil.checkForNullParam(databaseName, "databaseName");
            this.checkEnv();
            this.checkWritable();
            boolean autoTxnIsReplicated = this.envImpl.isReplicated();
            locker = null;
            result2 = null;
            try {
                try {
                    locker = LockerFactory.getWritableLocker(this, txn, false, this.envImpl.isTransactional(), autoTxnIsReplicated, null);
                    result2 = this.envImpl.getDbTree().truncate(locker, databaseName, returnCount);
                }
                catch (Error E) {
                    this.envImpl.invalidate(E);
                    throw E;
                }
                Object var9_7 = null;
                if (result2 == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (result2 != null) {
                    TriggerManager.runTruncateTriggers(locker, result2.newDb);
                }
                if (locker != null) {
                    locker.operationEnd(result2 != null);
                }
                throw throwable;
            }
            TriggerManager.runTruncateTriggers(locker, result2.newDb);
        }
        if (locker != null) {
            locker.operationEnd(result2 != null);
        }
        if (result2 == null) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Cannot happen");
        }
        return result2.recordCount;
    }

    long getMemoryUsage() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.envImpl.getMemoryBudget().getCacheMemoryUsage();
    }

    public File getHome() throws DatabaseException {
        this.checkHandleIsValid();
        return this.envImpl.getEnvironmentHome();
    }

    TransactionConfig getDefaultTxnConfig() {
        return this.defaultTxnConfig;
    }

    private void copyToHandleConfig(EnvironmentMutableConfig useConfig, EnvironmentConfig initStaticConfig, RepConfigProxy initRepConfig) {
        EnvironmentMutableConfig newHandleConfig = new EnvironmentMutableConfig();
        useConfig.copyHandlePropsTo(newHandleConfig);
        this.handleConfig = newHandleConfig;
        TransactionConfig newTxnConfig = TransactionConfig.DEFAULT.clone();
        newTxnConfig.setNoSync(this.handleConfig.getTxnNoSync());
        newTxnConfig.setWriteNoSync(this.handleConfig.getTxnWriteNoSync());
        newTxnConfig.setDurability(this.handleConfig.getDurability());
        if (initStaticConfig != null) {
            newTxnConfig.setSerializableIsolation(initStaticConfig.getTxnSerializableIsolation());
            newTxnConfig.setReadCommitted(initStaticConfig.getTxnReadCommitted());
        } else {
            newTxnConfig.setSerializableIsolation(this.defaultTxnConfig.getSerializableIsolation());
            newTxnConfig.setReadCommitted(this.defaultTxnConfig.getReadCommitted());
            newTxnConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
        }
        if (initRepConfig != null) {
            newTxnConfig.setConsistencyPolicy(initRepConfig.getConsistencyPolicy());
        }
        this.defaultTxnConfig = newTxnConfig;
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig txnConfig) throws DatabaseException, IllegalArgumentException {
        try {
            return this.beginTransactionInternal(parent, txnConfig, false);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    Transaction beginInternalTransaction(TransactionConfig txnConfig) {
        return this.beginTransactionInternal(null, txnConfig, true);
    }

    private Transaction beginTransactionInternal(Transaction parent, TransactionConfig txnConfig, boolean isInternalTxn) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        if (parent != null) {
            throw new IllegalArgumentException("Parent txn is non-null. Nested transactions are not supported.");
        }
        if (!isInternalTxn && !this.envImpl.isTransactional()) {
            throw new UnsupportedOperationException("Transactions can not be used in a non-transactional environment");
        }
        this.checkTxnConfig(txnConfig);
        TransactionConfig useConfig = null;
        if (txnConfig == null) {
            useConfig = this.defaultTxnConfig;
        } else {
            if (!(!this.defaultTxnConfig.getNoSync() && !this.defaultTxnConfig.getWriteNoSync() || txnConfig.getNoSync() || txnConfig.getSync() || txnConfig.getWriteNoSync())) {
                useConfig = txnConfig.clone();
                if (this.defaultTxnConfig.getWriteNoSync()) {
                    useConfig.setWriteNoSync(true);
                } else {
                    useConfig.setNoSync(true);
                }
            }
            if (this.defaultTxnConfig.getDurability() != null && txnConfig.getDurability() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setDurability(this.defaultTxnConfig.getDurability());
            }
            if (this.defaultTxnConfig.getConsistencyPolicy() != null && txnConfig.getConsistencyPolicy() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
            }
            if (!(txnConfig.getSerializableIsolation() || txnConfig.getReadCommitted() || txnConfig.getReadUncommitted())) {
                if (this.defaultTxnConfig.getSerializableIsolation()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setSerializableIsolation(true);
                } else if (this.defaultTxnConfig.getReadCommitted()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setReadCommitted(true);
                }
            }
            if (useConfig == null) {
                useConfig = txnConfig;
            }
        }
        Txn internalTxn = this.envImpl.txnBegin(parent, useConfig);
        Transaction txn = new Transaction(this, internalTxn);
        this.addReferringHandle(txn);
        return txn;
    }

    private void checkTxnConfig(TransactionConfig txnConfig) throws IllegalArgumentException {
        if (txnConfig == null) {
            return;
        }
        if (txnConfig.getSerializableIsolation() && txnConfig.getReadUncommitted() || txnConfig.getSerializableIsolation() && txnConfig.getReadCommitted() || txnConfig.getReadUncommitted() && txnConfig.getReadCommitted()) {
            throw new IllegalArgumentException("Only one may be specified: SerializableIsolation, ReadCommitted or ReadUncommitted");
        }
        if (txnConfig.getDurability() != null && (this.defaultTxnConfig.getSync() || this.defaultTxnConfig.getNoSync() || this.defaultTxnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of deprecated durability API for the Environment with the new durability API for TransactionConfig.setDurability()");
        }
        if (this.defaultTxnConfig.getDurability() != null && (txnConfig.getSync() || txnConfig.getNoSync() || txnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of new durability API for the Environment with the deprecated durability API for TransactionConfig.");
        }
    }

    public void checkpoint(CheckpointConfig ckptConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig useConfig = ckptConfig == null ? CheckpointConfig.DEFAULT : ckptConfig;
            this.envImpl.invokeCheckpoint(useConfig, "api");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void sync() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig config = new CheckpointConfig();
            config.setForce(true);
            config.setMinimizeRecoveryTime(true);
            this.envImpl.invokeCheckpoint(config, "sync");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void flushLog(boolean fsync) {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.flushLog(fsync);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public int cleanLog() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.invokeCleaner();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void evictMemory() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeEvictor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void compress() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeCompressor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public PreloadStats preload(Database[] databases, PreloadConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            DatabaseUtil.checkForZeroLengthArrayParam(databases, "databases");
            PreloadConfig useConfig = config == null ? new PreloadConfig() : config;
            int nDbs = databases.length;
            DatabaseImpl[] dbImpls = new DatabaseImpl[nDbs];
            for (int i = 0; i < nDbs; ++i) {
                dbImpls[i] = DbInternal.getDatabaseImpl(databases[i]);
            }
            return this.envImpl.preload(dbImpls, useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentConfig config = this.envImpl.cloneConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
            this.envImpl.setMutableConfig(mutableConfig);
            this.copyToHandleConfig(mutableConfig, null, null);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentMutableConfig getMutableConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentMutableConfig config = this.envImpl.cloneMutableConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentStats getStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            StatsConfig useConfig;
            StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
            if (this.envImpl != null) {
                return this.envImpl.loadStats(useConfig);
            }
            return new EnvironmentStats();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.lockStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.txnStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.getDbTree().getDbNames();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            return this.envImpl.verify(useConfig, out);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public Transaction getThreadTransaction() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            return this.envImpl.getTxnManager().getTxnForThread();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void setThreadTransaction(Transaction txn) {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            this.envImpl.getTxnManager().setTxnForThread(txn);
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean isValid() {
        return this.envImpl != null && this.envImpl.isValid();
    }

    public void printStartupInfo(PrintStream out) {
        this.envImpl.getStartupTracker().displayStats(out, StartupTracker.Phase.TOTAL_ENV_OPEN);
    }

    private void addReferringHandle(Database db) {
        this.referringDbs.add(db);
    }

    private void addReferringHandle(Transaction txn) {
        this.referringDbTxns.add(txn);
    }

    void removeReferringHandle(Database db) {
        this.referringDbs.remove(db);
    }

    void removeReferringHandle(Transaction txn) {
        this.referringDbTxns.remove(txn);
    }

    public void checkHandleIsValid() throws DatabaseException {
        if (this.envImpl == null) {
            throw new IllegalStateException("Attempt to use non-open Environment object().");
        }
    }

    EnvironmentImpl getEnvironmentImpl() {
        return this.envImpl;
    }

    protected boolean isInternalHandle() {
        return false;
    }

    protected void checkEnv() throws DatabaseException, EnvironmentFailureException {
        if (this.envImpl == null) {
            return;
        }
        this.envImpl.checkIfInvalid();
        this.envImpl.checkNotClosed();
    }

    private void checkWritable() {
        if (this.envImpl.isReadOnly()) {
            throw new UnsupportedOperationException("Environment is Read-Only.");
        }
    }
}

