/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CacheModeStrategy;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseComparator;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.dbi.TriggerUtils;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.trigger.PersistentTrigger;
import com.sleepycat.je.trigger.Trigger;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.util.ClassResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseImpl
implements Loggable,
Cloneable {
    private static final short NOT_DELETED = 1;
    private static final short DELETED_CLEANUP_INLIST_HARVEST = 2;
    private static final short DELETED_CLEANUP_LOG_HARVEST = 3;
    private static final short DELETED = 4;
    private byte flags;
    private static final byte DUPS_ENABLED = 1;
    private static final byte TEMPORARY_BIT = 2;
    private static final byte IS_REPLICATED_BIT = 4;
    private static final byte NOT_REPLICATED_BIT = 8;
    private static final byte PREFIXING_ENABLED = 16;
    private static final byte UTILIZATION_REPAIR_DONE = 32;
    private static final byte DUPS_CONVERTED = 64;
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean transactional;
    private boolean durableDeferredWrite;
    private boolean dirtyUtilization;
    private Set<Database> referringHandles;
    private BtreeStats stats;
    private long eofLsn;
    private volatile short deleteState;
    private AtomicInteger useCount = new AtomicInteger();
    private final AtomicInteger writeCount = new AtomicInteger();
    private DbFileSummaryMap dbFileSummaries;
    private byte createdAtLogVersion;
    public static boolean forceTreeWalkForTruncateAndRemove;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private Comparator<byte[]> keyComparator = null;
    private AtomicReference<List<Trigger>> triggers = new AtomicReference<Object>(null);
    private List<Trigger> transientTriggers = null;
    private byte[][] triggerBytes = null;
    private int binDeltaPercent;
    private int binMaxDeltas;
    private int maxTreeEntriesPerNode;
    private String debugDatabaseName;
    private TestHook<?> pendingDeletedHook;
    private DbType dbType;
    private CacheMode cacheMode;
    private CacheModeStrategy cacheModeStrategy;
    private static final boolean forceKeyPrefixing;

    public DatabaseImpl(Locker locker, String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.setConfigProperties(locker, dbName, dbConfig, envImpl);
        this.cacheMode = dbConfig.getCacheMode();
        this.cacheModeStrategy = dbConfig.getCacheModeStrategy();
        this.createdAtLogVersion = (byte)8;
        if (this.getSortedDuplicates()) {
            this.setDupsConverted();
        }
        this.setUtilizationRepairDone();
        this.commonInit();
        this.initWithEnvironment();
        this.tree = new Tree(this);
        this.debugDatabaseName = dbName;
    }

    public DatabaseImpl() {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.tree = new Tree();
        this.commonInit();
    }

    public void setConfigProperties(Locker locker, String dbName, DatabaseConfig dbConfig, EnvironmentImpl envImpl) {
        this.setBtreeComparator(dbConfig.getBtreeComparator(), dbConfig.getBtreeComparatorByClassName());
        this.setDuplicateComparator(dbConfig.getDuplicateComparator(), dbConfig.getDuplicateComparatorByClassName());
        this.setTriggers(locker, dbName, dbConfig.getTriggers(), true);
        if (dbConfig.getSortedDuplicates()) {
            this.setSortedDuplicates();
        }
        if (dbConfig.getKeyPrefixing() || forceKeyPrefixing) {
            this.setKeyPrefixing();
        } else {
            this.clearKeyPrefixing();
        }
        if (dbConfig.getTemporary()) {
            this.setTemporary();
        }
        if (envImpl.isReplicated()) {
            if (DbInternal.getReplicated(dbConfig)) {
                this.setIsReplicatedBit();
            } else {
                this.setNotReplicatedBit();
            }
        }
        this.transactional = dbConfig.getTransactional();
        this.durableDeferredWrite = dbConfig.getDeferredWrite();
        this.maxTreeEntriesPerNode = dbConfig.getNodeMaxEntries();
    }

    private void commonInit() {
        this.deleteState = 1;
        this.referringHandles = Collections.synchronizedSet(new HashSet());
        this.dbFileSummaries = new DbFileSummaryMap(false);
    }

    public void setDebugDatabaseName(String debugName) {
        this.debugDatabaseName = debugName;
    }

    public String getDebugName() {
        return this.debugDatabaseName != null ? this.debugDatabaseName : "dBId=" + this.id;
    }

    boolean isDebugNameAvailable() {
        return this.debugDatabaseName != null;
    }

    public void setPendingDeletedHook(TestHook<?> hook) {
        this.pendingDeletedHook = hook;
    }

    private void initWithEnvironment() {
        this.eofLsn = this.envImpl.getNodeSequence().getNextTransientLsn();
        assert (!this.replicatedBitSet() || !this.notReplicatedBitSet()) : "The replicated AND notReplicated bits should never be set  together";
        DbConfigManager configMgr = this.envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        this.binMaxDeltas = configMgr.getInt(EnvironmentParams.BIN_MAX_DELTAS);
        if (this.maxTreeEntriesPerNode == 0) {
            this.maxTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX);
        }
        this.dbFileSummaries.init(this.envImpl);
        if (!this.getUtilizationRepairDone()) {
            this.dbFileSummaries.repair(this.envImpl);
            this.setDirtyUtilization();
            this.setUtilizationRepairDone();
        }
        if (!this.envImpl.getNoComparators()) {
            ComparatorReader reader = new ComparatorReader(this.btreeComparatorBytes, "Btree", this.envImpl.getClassLoader());
            this.btreeComparator = reader.getComparator();
            this.btreeComparatorByClassName = reader.isClass();
            reader = new ComparatorReader(this.duplicateComparatorBytes, "Duplicate", this.envImpl.getClassLoader());
            this.duplicateComparator = reader.getComparator();
            this.duplicateComparatorByClassName = reader.isClass();
            this.resetKeyComparator();
        }
    }

    public DatabaseImpl cloneDatabase() {
        DatabaseImpl newDb;
        try {
            newDb = (DatabaseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : e;
            return null;
        }
        newDb.id = null;
        newDb.tree = null;
        newDb.createdAtLogVersion = (byte)8;
        newDb.dbFileSummaries = new DbFileSummaryMap(false);
        newDb.dbFileSummaries.init(this.envImpl);
        newDb.useCount = new AtomicInteger();
        return newDb;
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    public long getEofLsn() {
        return this.eofLsn;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTemporary() {
        return (this.flags & 2) != 0;
    }

    public static boolean isTemporary(byte flagVal) {
        return (flagVal & 2) != 0;
    }

    public boolean isInternalDb() {
        return this.getDbType().isInternal();
    }

    public DbType getDbType() {
        if (this.dbType != null) {
            return this.dbType;
        }
        this.dbType = DbTree.typeForDbName(this.debugDatabaseName);
        return this.dbType;
    }

    private void setTemporary() {
        this.flags = (byte)(this.flags | 2);
    }

    public boolean isDurableDeferredWrite() {
        return this.durableDeferredWrite;
    }

    public boolean isDeferredWriteMode() {
        return this.isDurableDeferredWrite() || this.isTemporary();
    }

    public void setDeferredWrite(boolean durableDeferredWrite) {
        this.durableDeferredWrite = durableDeferredWrite;
    }

    public boolean getSortedDuplicates() {
        return (this.flags & 1) != 0;
    }

    public static boolean getSortedDuplicates(byte flagVal) {
        return (flagVal & 1) != 0;
    }

    public void setSortedDuplicates() {
        this.flags = (byte)(this.flags | 1);
    }

    public boolean getDupsConverted() {
        return (this.flags & 0x40) != 0;
    }

    public void setDupsConverted() {
        this.flags = (byte)(this.flags | 0x40);
    }

    public List<Trigger> getTriggers() {
        if (this.envImpl == null || this.envImpl.getNoComparators()) {
            return null;
        }
        if (this.triggerBytes == null && this.transientTriggers == null) {
            return null;
        }
        List<Trigger> myTriggers = this.triggers.get();
        if (myTriggers != null) {
            return myTriggers;
        }
        myTriggers = TriggerUtils.unmarshallTriggers(this.getName(), this.triggerBytes, this.envImpl.getClassLoader());
        if (myTriggers == null) {
            myTriggers = new LinkedList<Trigger>();
        }
        if (this.transientTriggers != null) {
            myTriggers.addAll(this.transientTriggers);
        }
        if (this.triggers.compareAndSet(null, myTriggers)) {
            return myTriggers;
        }
        myTriggers = this.triggers.get();
        assert (myTriggers != null);
        return myTriggers;
    }

    public boolean hasUserTriggers() {
        return this.triggerBytes != null || this.transientTriggers != null;
    }

    public boolean getKeyPrefixing() {
        return (this.flags & 0x10) != 0;
    }

    public static boolean getKeyPrefixing(byte flagVal) {
        return (flagVal & 0x10) != 0;
    }

    public void setKeyPrefixing() {
        this.flags = (byte)(this.flags | 0x10);
    }

    public void clearKeyPrefixing() {
        if (forceKeyPrefixing) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isReplicated() {
        return this.replicatedBitSet();
    }

    public boolean unknownReplicated() {
        return (this.flags & 4) == 0 && (this.flags & 8) == 0;
    }

    private boolean replicatedBitSet() {
        return (this.flags & 4) != 0;
    }

    public void setIsReplicatedBit() {
        this.flags = (byte)(this.flags | 4);
    }

    private boolean notReplicatedBitSet() {
        return (this.flags & 8) != 0;
    }

    private void setNotReplicatedBit() {
        this.flags = (byte)(this.flags | 8);
    }

    public boolean getUtilizationRepairDone() {
        return (this.flags & 0x20) != 0;
    }

    private void setUtilizationRepairDone() {
        this.flags = (byte)(this.flags | 0x20);
    }

    public void clearUtilizationRepairDone() {
        this.flags = (byte)(this.flags & 0xFFFFFFDF);
    }

    public int getNodeMaxTreeEntries() {
        return this.maxTreeEntriesPerNode;
    }

    public void setNodeMaxTreeEntries(int newNodeMaxTreeEntries) {
        this.maxTreeEntriesPerNode = newNodeMaxTreeEntries;
    }

    public boolean allowReplicaWrite() {
        return !this.isReplicated() || this.getDbType() == DbType.NAME;
    }

    public int estimateDataSize(byte[] key) {
        if (this.getSortedDuplicates()) {
            return 0;
        }
        return -1;
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = mode;
    }

    public void setCacheModeStrategy(CacheModeStrategy strategy) {
        this.cacheModeStrategy = strategy;
    }

    public CacheMode getDefaultCacheMode() {
        if (this.cacheMode != null) {
            return this.cacheMode;
        }
        if (this.isInternalDb()) {
            return CacheMode.DEFAULT;
        }
        return this.envImpl.getDefaultCacheMode();
    }

    public CacheMode getEffectiveCacheMode(CacheMode cacheModeParam) {
        CacheModeStrategy strategy;
        assert (cacheModeParam != null);
        if (cacheModeParam != CacheMode.DYNAMIC) {
            return cacheModeParam;
        }
        CacheModeStrategy cacheModeStrategy = strategy = this.cacheModeStrategy != null ? this.cacheModeStrategy : this.envImpl.getDefaultCacheModeStrategy();
        if (strategy == null) {
            throw new IllegalStateException("CacheMode.DYNAMIC may not be used without also configuring a CacheModeStrategy for the Database or Environment.");
        }
        CacheMode dynamicMode = strategy.getCacheMode();
        if (dynamicMode == null || dynamicMode == CacheMode.DYNAMIC) {
            throw new IllegalArgumentException("" + (Object)((Object)dynamicMode) + " was illegally returned by " + strategy.getClass().getName());
        }
        return dynamicMode;
    }

    public int getAdditionalTreeMemorySize() {
        int val = 0;
        if (this.btreeComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.btreeComparatorBytes.length);
        }
        if (this.duplicateComparator != null) {
            val += 2 * MemoryBudget.byteArraySize(this.duplicateComparatorBytes.length);
        }
        return val;
    }

    public boolean setDuplicateComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        this.duplicateComparator = comparator;
        byte[] newDuplicateComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Duplicate");
        boolean ret = Arrays.equals(newDuplicateComparatorBytes, this.duplicateComparatorBytes);
        this.duplicateComparatorBytes = newDuplicateComparatorBytes;
        this.duplicateComparatorByClassName = byClassName;
        if (!ret) {
            this.resetKeyComparator();
        }
        return !ret;
    }

    public boolean setTriggers(Locker locker, String dbName, List<Trigger> newTriggers, boolean overridePersistentTriggers) {
        boolean transientChange;
        LinkedList<Trigger> newTransientTriggers;
        boolean persistentChange;
        Object newTriggerBytes;
        if (newTriggers != null && newTriggers.size() == 0) {
            newTriggers = null;
        }
        if (overridePersistentTriggers) {
            if (newTriggers == null) {
                newTriggerBytes = null;
                persistentChange = this.triggerBytes != null;
            } else {
                int nTriggers = 0;
                for (Trigger trigger : newTriggers) {
                    if (!(trigger instanceof PersistentTrigger)) continue;
                    ++nTriggers;
                }
                if (nTriggers == 0) {
                    newTriggerBytes = null;
                    persistentChange = this.triggerBytes != null;
                } else {
                    newTriggerBytes = new byte[nTriggers][];
                    int i = 0;
                    for (Trigger trigger : newTriggers) {
                        if (!(trigger instanceof PersistentTrigger)) continue;
                        newTriggerBytes[i++] = DatabaseImpl.objectToBytes(trigger, "trigger " + trigger.getName());
                        trigger.setDatabaseName(dbName);
                    }
                    persistentChange = !Arrays.equals((Object[])this.triggerBytes, (Object[])newTriggerBytes);
                }
            }
        } else {
            newTriggerBytes = this.triggerBytes;
            persistentChange = false;
        }
        if (newTriggers == null) {
            newTransientTriggers = null;
            transientChange = this.transientTriggers != null;
        } else {
            newTransientTriggers = new LinkedList<Trigger>();
            IdentityHashMap diffs = new IdentityHashMap();
            for (Trigger trigger : newTriggers) {
                if (trigger instanceof PersistentTrigger) continue;
                diffs.put(trigger, null);
                newTransientTriggers.add(trigger);
                trigger.setDatabaseName(dbName);
            }
            if (this.transientTriggers == null) {
                transientChange = newTransientTriggers.size() > 0;
            } else if (this.transientTriggers.size() != newTransientTriggers.size()) {
                transientChange = true;
            } else {
                for (Trigger trigger : this.transientTriggers) {
                    diffs.remove(trigger);
                }
                boolean bl = transientChange = diffs.size() > 0;
            }
        }
        if (persistentChange || transientChange) {
            TriggerManager.invokeAddRemoveTriggers(locker, this.getTriggers(), newTriggers);
            this.triggerBytes = newTriggerBytes;
            this.transientTriggers = newTransientTriggers != null && newTransientTriggers.size() > 0 ? newTransientTriggers : null;
            this.triggers.set(newTriggers);
        }
        return persistentChange;
    }

    private void clearTransientTriggers() {
        List<Trigger> oldTriggers = this.getTriggers();
        if (oldTriggers == null) {
            return;
        }
        LinkedList<Trigger> newTriggers = new LinkedList<Trigger>(oldTriggers);
        Iterator iter2 = newTriggers.iterator();
        while (iter2.hasNext()) {
            Trigger trigger = (Trigger)iter2.next();
            if (trigger instanceof PersistentTrigger) continue;
            iter2.remove();
        }
        this.setTriggers(null, null, newTriggers, false);
    }

    public boolean setBtreeComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        this.btreeComparator = comparator;
        byte[] newBtreeComparatorBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "Btree");
        boolean ret = Arrays.equals(newBtreeComparatorBytes, this.btreeComparatorBytes);
        this.btreeComparatorBytes = newBtreeComparatorBytes;
        this.btreeComparatorByClassName = byClassName;
        if (!ret) {
            this.resetKeyComparator();
        }
        return !ret;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    private void resetKeyComparator() {
        if (this.btreeComparator instanceof DatabaseComparator) {
            ((DatabaseComparator)this.btreeComparator).initialize(this.envImpl.getClassLoader());
        }
        if (this.duplicateComparator instanceof DatabaseComparator) {
            ((DatabaseComparator)this.duplicateComparator).initialize(this.envImpl.getClassLoader());
        }
        this.keyComparator = this.getSortedDuplicates() ? new DupKeyData.TwoPartKeyComparator(this.btreeComparator, this.duplicateComparator) : this.btreeComparator;
    }

    public Comparator<byte[]> getKeyComparator() {
        return this.keyComparator;
    }

    public boolean getBtreeComparatorByClass() {
        return this.btreeComparatorByClassName;
    }

    public boolean getDuplicateComparatorByClass() {
        return this.duplicateComparatorByClassName;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.initWithEnvironment();
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getEnvironmentImpl() {
        return this.envImpl;
    }

    public EnvironmentImpl getDbEnvironment() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Database> getReferringHandles() {
        HashSet<Database> copy = new HashSet<Database>();
        Set<Database> set = this.referringHandles;
        synchronized (set) {
            copy.addAll(this.referringHandles);
        }
        return copy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleClosed(boolean doSyncDw, boolean deleteTempDb) throws DatabaseException {
        if (this.referringHandles.isEmpty()) {
            block9: {
                this.clearTransientTriggers();
                if (deleteTempDb && this.isTemporary()) {
                    BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, true);
                    boolean operationOk = false;
                    try {
                        try {
                            this.envImpl.getDbTree().dbRemove(locker, this.getName(), this.getId());
                            operationOk = true;
                        }
                        catch (DatabaseNotFoundException e) {
                            Object var7_6 = null;
                            ((Locker)locker).operationEnd(operationOk);
                            break block9;
                        }
                        catch (LockConflictException e) {
                            Object var7_7 = null;
                            ((Locker)locker).operationEnd(operationOk);
                            break block9;
                        }
                        catch (Error E) {
                            this.envImpl.invalidate(E);
                            throw E;
                        }
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        ((Locker)locker).operationEnd(operationOk);
                        throw throwable;
                    }
                    ((Locker)locker).operationEnd(operationOk);
                }
            }
            if (doSyncDw && this.isDurableDeferredWrite()) {
                this.sync(true);
            }
        }
    }

    public long getTreeAdminMemory() {
        return this.dbFileSummaries.getMemorySize();
    }

    public void releaseTreeAdminMemory() {
        this.dbFileSummaries.subtractFromMemoryBudget();
    }

    int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    void incrementUseCount() {
        this.useCount.incrementAndGet();
    }

    public int noteWriteHandleOpen() {
        return this.writeCount.incrementAndGet();
    }

    public int noteWriteHandleClose() {
        int count2 = this.writeCount.decrementAndGet();
        assert (count2 >= 0);
        return count2;
    }

    void decrementUseCount() {
        assert (this.useCount.get() > 0);
        this.useCount.decrementAndGet();
    }

    public boolean isInUse() {
        return this.useCount.get() > 0;
    }

    boolean isInUseDuringDbRemove() {
        return this.useCount.get() > 1 + this.referringHandles.size();
    }

    public synchronized void sync(boolean flushLog) throws DatabaseException {
        if (!this.isDurableDeferredWrite()) {
            throw new UnsupportedOperationException("Database.sync() is only supported for deferred-write databases");
        }
        if (this.tree.rootExists()) {
            this.envImpl.getCheckpointer().syncDatabase(this.envImpl, this, flushLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database findPrimaryDatabase() {
        Set<Database> set = this.referringHandles;
        synchronized (set) {
            for (Database obj : this.referringHandles) {
                if (!(obj instanceof SecondaryDatabase)) continue;
                return ((SecondaryDatabase)obj).getPrimaryDatabase();
            }
        }
        return null;
    }

    public String getName() throws DatabaseException {
        return this.envImpl.getDbTree().getDbName(this.id);
    }

    public DbFileSummary getDbFileSummary(Long fileNum, boolean willModify) {
        if (willModify) {
            this.dirtyUtilization = true;
        }
        assert (this.dbFileSummaries != null);
        return this.dbFileSummaries.get(fileNum, true, true, this.envImpl.getFileManager());
    }

    public boolean removeDbFileSummaries(Collection<Long> fileNums) {
        assert (this.dbFileSummaries != null);
        boolean removed = false;
        for (Long fileNum : fileNums) {
            if (!this.dbFileSummaries.remove(fileNum)) continue;
            removed = true;
        }
        return removed;
    }

    public Map<Long, DbFileSummary> cloneDbFileSummaries() {
        return this.envImpl.getLogManager().cloneDbFileSummaries(this);
    }

    public Map<Long, DbFileSummary> cloneDbFileSummariesInternal() {
        return this.dbFileSummaries.cloneMap();
    }

    public DbFileSummaryMap getDbFileSummaries() {
        return this.dbFileSummaries;
    }

    public boolean isDirtyUtilization() {
        return this.dirtyUtilization;
    }

    public void setDirtyUtilization() {
        this.dirtyUtilization = true;
    }

    public boolean isCheckpointNeeded() {
        return !this.isDeleted() && (this.isDirtyUtilization() || this.isTemporary());
    }

    public boolean isDeleted() {
        return this.deleteState != 1;
    }

    public boolean isDeleteFinished() {
        return this.deleteState == 4;
    }

    public void startDeleteProcessing() {
        assert (this.deleteState == 1);
        this.deleteState = (short)2;
    }

    void finishedINListHarvest() {
        assert (this.deleteState == 2);
        this.deleteState = (short)3;
    }

    public void startAndFinishDelete() throws DatabaseException {
        this.startDeleteProcessing();
        this.finishDeleteProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDeleteProcessing() throws DatabaseException {
        assert (TestHookExecute.doHookIfSet(this.pendingDeletedHook));
        try {
            if (this.dbFileSummaries == null) assert (false);
            long rootLsn = this.tree.getRootLsn();
            IN rootIN = this.tree.getResidentRootIN(false);
            this.envImpl.getDbTree().deleteMapLN(this.id);
            this.envImpl.getLogManager().flush();
            if (this.createdAtLogVersion >= 6 && !forceTreeWalkForTruncateAndRemove) {
                this.envImpl.getLogManager().countObsoleteDb(this);
            } else {
                LocalUtilizationTracker localTracker = new LocalUtilizationTracker(this.envImpl);
                if (rootLsn != -1L) {
                    localTracker.countObsoleteNodeInexact(rootLsn, LogEntryType.LOG_IN, 0, this);
                }
                boolean fetchLNSize = this.envImpl.getCleaner().getFetchObsoleteSize();
                ObsoleteProcessor obsoleteProcessor = new ObsoleteProcessor(this, localTracker);
                ObsoleteTreeWalker walker = new ObsoleteTreeWalker(this, rootLsn, fetchLNSize, (SortedLSNTreeWalker.TreeNodeProcessor)obsoleteProcessor, rootIN);
                walker.walk();
                this.envImpl.getUtilizationProfile().flushLocalTracker(localTracker);
            }
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            INList inList = this.envImpl.getInMemoryINs();
            long memoryChange = 0L;
            try {
                Iterator<IN> iter2 = inList.iterator();
                while (iter2.hasNext()) {
                    IN thisIN = iter2.next();
                    if (thisIN.getDatabase() != this) continue;
                    iter2.remove();
                    memoryChange += 0L - thisIN.getBudgetedMemorySize();
                    thisIN.setInListResident(false);
                }
                Object var11_11 = null;
                mb.updateTreeMemoryUsage(memoryChange);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                mb.updateTreeMemoryUsage(memoryChange);
                throw throwable;
            }
            Object var13_14 = null;
            this.dbFileSummaries.subtractFromMemoryBudget();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.dbFileSummaries.subtractFromMemoryBudget();
            this.deleteState = (short)4;
            this.envImpl.getDbTree().releaseDb(this);
            throw throwable;
        }
        this.deleteState = (short)4;
        this.envImpl.getDbTree().releaseDb(this);
    }

    public void countObsoleteDb(BaseUtilizationTracker tracker, long mapLnLsn) {
        if (this.createdAtLogVersion >= 6 && !forceTreeWalkForTruncateAndRemove) {
            tracker.countObsoleteDb(this.dbFileSummaries, mapLnLsn);
        }
    }

    public DatabaseStats stat(StatsConfig config) throws DatabaseException {
        if (this.stats == null) {
            this.stats = new BtreeStats();
        }
        if (!config.getFast()) {
            if (this.tree == null) {
                return new BtreeStats();
            }
            PrintStream out = config.getShowProgressStream();
            if (out == null) {
                out = System.err;
            }
            StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval());
            this.walkDatabaseTree(statsAcc, out, true);
            this.stats.setDbImplStats(statsAcc.getStats());
        }
        this.tree.loadStats(config, this.stats);
        return this.stats;
    }

    public boolean verify(VerifyConfig config, DatabaseStats emptyStats) throws DatabaseException {
        if (this.tree == null) {
            return true;
        }
        PrintStream out = config.getShowProgressStream();
        if (out == null) {
            out = System.err;
        }
        StatsAccumulator statsAcc = new StatsAccumulator(out, config.getShowProgressInterval()){

            void verifyNode(Node node) {
                try {
                    node.verify(null);
                }
                catch (DatabaseException INE) {
                    this.progressStream.println(INE);
                }
            }
        };
        boolean ok = this.walkDatabaseTree(statsAcc, out, config.getPrintInfo());
        ((BtreeStats)emptyStats).setDbImplStats(statsAcc.getStats());
        return ok;
    }

    public DatabaseStats getEmptyStats() {
        return new BtreeStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean walkDatabaseTree(TreeWalkerStatsAccumulator statsAcc, PrintStream out, boolean verbose) throws DatabaseException {
        boolean ok = true;
        Locker locker = LockerFactory.getInternalReadOperationLocker(this.envImpl);
        CursorImpl cursor = null;
        try {
            EnvironmentImpl.incThreadLocalReferenceCount();
            cursor = new CursorImpl(this, locker);
            this.tree.setTreeStatsAccumulator(statsAcc);
            cursor.setTreeStatsAccumulator(statsAcc);
            DatabaseEntry foundData = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry();
            if (cursor.positionFirstOrLast(true)) {
                OperationStatus status = cursor.getCurrentAlreadyLatched(key, foundData, LockType.NONE);
                boolean done = false;
                while (!done) {
                    this.envImpl.criticalEviction(false);
                    try {
                        status = cursor.getNext(key, foundData, LockType.NONE, true, false, null);
                    }
                    catch (DatabaseException e) {
                        ok = false;
                        if (cursor.advanceCursor(key, foundData)) {
                            if (verbose) {
                                out.println("Error encountered (continuing):");
                                out.println(e);
                                this.printErrorRecord(out, key, foundData);
                            }
                        }
                        throw e;
                    }
                    if (status == OperationStatus.SUCCESS) continue;
                    done = true;
                }
            }
            Object var13_12 = null;
            if (cursor != null) {
                cursor.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (cursor != null) {
                cursor.setTreeStatsAccumulator(null);
            }
            this.tree.setTreeStatsAccumulator(null);
            EnvironmentImpl.decThreadLocalReferenceCount();
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd(ok);
            }
            throw throwable;
        }
        EnvironmentImpl.decThreadLocalReferenceCount();
        if (cursor != null) {
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(ok);
        }
        return ok;
    }

    private void printErrorRecord(PrintStream out, DatabaseEntry key, DatabaseEntry data) {
        byte[] bytes = key.getData();
        StringBuilder sb = new StringBuilder("Error Key ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
        bytes = data.getData();
        sb = new StringBuilder("Error Data ");
        if (bytes == null) {
            sb.append("UNKNOWN");
        } else {
            CmdUtil.formatEntry(sb, bytes, false);
            sb.append(' ');
            CmdUtil.formatEntry(sb, bytes, true);
        }
        out.println(sb);
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        return this.envImpl.preload(new DatabaseImpl[]{this}, config);
    }

    public long count() throws DatabaseException {
        try {
            PreloadStats pstats = new PreloadStats();
            CountProcessor callback = new CountProcessor(this.envImpl, pstats);
            CountExceptionPredicate excPredicate = new CountExceptionPredicate();
            SortedLSNTreeWalker walker = new SortedLSNTreeWalker(new DatabaseImpl[]{this}, false, new long[]{this.tree.getRootLsn()}, callback, null, excPredicate);
            walker.walk();
            assert (LatchSupport.countLatchesHeld() == 0);
            return pstats.getNLNsLoaded();
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long count(DatabaseEntry beginKey, boolean beginInclusive, DatabaseEntry endKey, boolean endInclusive) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry noData = new DatabaseEntry();
        noData.setPartial(0, 0, true);
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
        try {
            Cursor c;
            block9: {
                block7: {
                    block8: {
                        long l;
                        c = DbInternal.makeCursor(this, locker, null);
                        try {
                            if (beginKey == null) break block7;
                            key.setData(beginKey.getData(), beginKey.getOffset(), beginKey.getSize());
                            if (c.getSearchKeyRange(key, noData, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) break block8;
                            l = 0L;
                            Object var13_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            c.close();
                            throw throwable;
                        }
                        c.close();
                        Object var15_18 = null;
                        ((Locker)locker).operationEnd(true);
                        return l;
                    }
                    if (beginInclusive || !key.equals(beginKey) || c.getNext(key, noData, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) break block9;
                    long l = 0L;
                    Object var13_14 = null;
                    c.close();
                    Object var15_19 = null;
                    ((Locker)locker).operationEnd(true);
                    return l;
                }
                if (c.getFirst(key, noData, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) break block9;
                long l = 0L;
                Object var13_15 = null;
                c.close();
                Object var15_20 = null;
                ((Locker)locker).operationEnd(true);
                return l;
            }
            RangeConstraint rangeConstraint = null;
            long l = DbInternal.getCursorImpl(c).skip(true, 0L, rangeConstraint);
            Object var13_16 = null;
            c.close();
            Object var15_21 = null;
            ((Locker)locker).operationEnd(true);
            return l;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            ((Locker)locker).operationEnd(true);
            throw throwable;
        }
    }

    public String dumpString(int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        sb.append(" deleteState=\"");
        sb.append(this.deleteState);
        sb.append("\"");
        sb.append(" useCount=\"");
        sb.append(this.useCount.get());
        sb.append("\"");
        sb.append(" dupsort=\"");
        sb.append(this.getSortedDuplicates());
        sb.append("\"");
        sb.append(" temporary=\"");
        sb.append(this.isTemporary());
        sb.append("\"");
        sb.append(" deferredWrite=\"");
        sb.append(this.isDurableDeferredWrite());
        sb.append("\"");
        sb.append(" keyPrefixing=\"");
        sb.append(this.getKeyPrefixing());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator, this.btreeComparatorBytes));
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator, this.duplicateComparatorBytes));
            sb.append("\"");
        }
        sb.append(">");
        if (this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("/file>");
            }
        }
        sb.append("</database>");
        return sb.toString();
    }

    @Override
    public int getLogSize() {
        int size2 = this.id.getLogSize() + this.tree.getLogSize() + 1 + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes) + LogUtils.getPackedIntLogSize(this.maxTreeEntriesPerNode) + 1;
        size2 += LogUtils.getPackedIntLogSize(this.dbFileSummaries.size());
        for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            DbFileSummary summary = entry.getValue();
            size2 += LogUtils.getPackedLongLogSize(fileNum) + summary.getLogSize();
        }
        return size2 += TriggerUtils.logSize(this.triggerBytes);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        this.tree.writeToLog(logBuffer);
        logBuffer.put(this.flags);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
        LogUtils.writePackedInt(logBuffer, this.maxTreeEntriesPerNode);
        logBuffer.put(this.createdAtLogVersion);
        LogUtils.writePackedInt(logBuffer, this.dbFileSummaries.size());
        for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
            Long fileNum = entry.getKey();
            DbFileSummary summary = entry.getValue();
            LogUtils.writePackedLong(logBuffer, fileNum);
            summary.writeToLog(logBuffer);
        }
        TriggerUtils.writeTriggers(logBuffer, this.triggerBytes);
        this.dirtyUtilization = false;
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean version6OrLater = entryVersion >= 6;
        this.id.readFromLog(itemBuffer, entryVersion);
        this.tree.readFromLog(itemBuffer, entryVersion);
        this.flags = itemBuffer.get();
        if (forceKeyPrefixing) {
            this.setKeyPrefixing();
        }
        if (entryVersion >= 2) {
            this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
            this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
        } else {
            String btreeClassName = LogUtils.readString(itemBuffer, !version6OrLater, entryVersion);
            String dupClassName = LogUtils.readString(itemBuffer, !version6OrLater, entryVersion);
            this.btreeComparatorBytes = btreeClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(btreeClassName, "Btree");
            this.duplicateComparatorBytes = dupClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(dupClassName, "Duplicate");
        }
        if (entryVersion >= 1) {
            this.maxTreeEntriesPerNode = LogUtils.readInt(itemBuffer, !version6OrLater);
            if (entryVersion < 8) {
                LogUtils.readInt(itemBuffer, !version6OrLater);
            }
        }
        if (version6OrLater) {
            this.createdAtLogVersion = itemBuffer.get();
            int nFiles = LogUtils.readPackedInt(itemBuffer);
            for (int i = 0; i < nFiles; ++i) {
                long fileNum = LogUtils.readPackedLong(itemBuffer);
                DbFileSummary summary = this.dbFileSummaries.get(fileNum, false, false, null);
                summary.readFromLog(itemBuffer, entryVersion);
            }
        }
        this.triggerBytes = entryVersion < 8 ? (byte[][])null : TriggerUtils.readTriggers(itemBuffer, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<database");
        DatabaseImpl.dumpFlags(sb, verbose, this.flags);
        sb.append(" btcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator, this.btreeComparatorBytes));
        sb.append("\"");
        sb.append(" dupcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator, this.duplicateComparatorBytes));
        sb.append("\" > ");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        if (verbose && this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("</file>");
            }
        }
        TriggerUtils.dumpTriggers(sb, this.triggerBytes, this.getTriggers());
        sb.append("</database>");
    }

    static void dumpFlags(StringBuilder sb, boolean verbose, byte flags) {
        sb.append(" dupsort=\"").append((flags & 1) != 0);
        sb.append("\" replicated=\"").append((flags & 4) != 0);
        sb.append("\" temp=\"").append((flags & 2) != 0).append("\" ");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    private static String getComparatorClassName(Comparator<byte[]> comparator, byte[] comparatorBytes) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        if (comparatorBytes != null && comparatorBytes.length > 0) {
            return "byteLen: " + comparatorBytes.length;
        }
        return "";
    }

    public static Comparator<byte[]> instantiateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String comparatorType) {
        if (comparatorClass == null) {
            return null;
        }
        try {
            return comparatorClass.newInstance();
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to load " + comparatorType + " Comparator class.", e);
        }
    }

    public Comparator<byte[]> instantiateComparator(Comparator<byte[]> comparator, String comparatorType) throws DatabaseException {
        if (comparator == null) {
            return null;
        }
        return (Comparator)DatabaseImpl.bytesToObject(DatabaseImpl.objectToBytes(comparator, comparatorType), comparatorType, this.envImpl.getClassLoader());
    }

    public static byte[] comparatorToBytes(Comparator<byte[]> comparator, boolean byClassName, String comparatorType) {
        if (comparator == null) {
            return LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        }
        Comparator<byte[]> obj = byClassName ? comparator.getClass().getName() : comparator;
        return DatabaseImpl.objectToBytes(obj, comparatorType);
    }

    public static byte[] objectToBytes(Object obj, String comparatorType) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to store " + comparatorType, (Exception)e);
        }
    }

    static Object bytesToObject(byte[] bytes, String comparatorType, ClassLoader loader) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ClassResolver.Stream ois = new ClassResolver.Stream(bais, loader);
            return ois.readObject();
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to load " + comparatorType, e);
        }
    }

    public int compareEntries(DatabaseEntry entry1, DatabaseEntry entry2, boolean duplicates) {
        return Key.compareKeys(entry1.getData(), entry1.getOffset(), entry1.getSize(), entry2.getData(), entry2.getOffset(), entry2.getSize(), duplicates ? this.duplicateComparator : this.btreeComparator);
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public int getBinMaxDeltas() {
        return this.binMaxDeltas;
    }

    public ReplicationContext getRepContext() {
        return this.isReplicated() ? ReplicationContext.MASTER : ReplicationContext.NO_REPLICATE;
    }

    DbOpReplicationContext getOperationRepContext(DbOperationType operationType, DatabaseId oldDbId) {
        DbOpReplicationContext context = new DbOpReplicationContext(this.isReplicated(), operationType);
        if (DbOperationType.isWriteConfigType(operationType)) {
            assert (oldDbId == null);
            context.setCreateConfig(new ReplicatedDatabaseConfig(this.flags, this.maxTreeEntriesPerNode, this.btreeComparatorBytes, this.duplicateComparatorBytes, this.triggerBytes));
        } else if (operationType == DbOperationType.TRUNCATE) {
            assert (oldDbId != null);
            context.setTruncateOldDbId(oldDbId);
        }
        return context;
    }

    DbOpReplicationContext getOperationRepContext(DbOperationType operationType) {
        assert (operationType != DbOperationType.TRUNCATE);
        return this.getOperationRepContext(operationType, null);
    }

    static {
        String forceKeyPrefixingProp = System.getProperty("je.forceKeyPrefixing");
        forceKeyPrefixing = "true".equals(forceKeyPrefixingProp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComparatorReader {
        private final boolean isClass;
        private final Class<? extends Comparator<byte[]>> comparatorClass;
        private final Comparator<byte[]> comparator;

        public ComparatorReader(byte[] comparatorBytes, String type, ClassLoader loader) {
            if (comparatorBytes.length == 0) {
                this.comparatorClass = null;
                this.comparator = null;
                this.isClass = false;
                return;
            }
            Object obj = DatabaseImpl.bytesToObject(comparatorBytes, type, loader);
            if (obj instanceof String) {
                String className = (String)obj;
                try {
                    this.comparatorClass = ClassResolver.resolveClass(className, loader);
                }
                catch (ClassNotFoundException ee) {
                    throw EnvironmentFailureException.unexpectedException(ee);
                }
                this.comparator = DatabaseImpl.instantiateComparator(this.comparatorClass, type);
                this.isClass = true;
                return;
            }
            if (obj instanceof Comparator) {
                this.comparatorClass = null;
                this.comparator = (Comparator)obj;
                this.isClass = false;
                return;
            }
            throw EnvironmentFailureException.unexpectedState("Expected class name or Comparator instance, got: " + obj.getClass().getName());
        }

        public boolean isClass() {
            return this.isClass;
        }

        public Class<? extends Comparator<byte[]>> getComparatorClass() {
            return this.comparatorClass;
        }

        public Comparator<byte[]> getComparator() {
            return this.comparator;
        }
    }

    private static class CountExceptionPredicate
    implements SortedLSNTreeWalker.ExceptionPredicate {
        private CountExceptionPredicate() {
        }

        public boolean ignoreException(Exception e) {
            return e instanceof FileNotFoundException;
        }
    }

    private static class CountProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final EnvironmentImpl envImpl;
        private final PreloadStats stats;

        CountProcessor(EnvironmentImpl envImpl, PreloadStats stats) {
            this.envImpl = envImpl;
            this.stats = stats;
        }

        public void processLSN(long childLsn, LogEntryType childType, Node ignore, byte[] ignore2) throws FileNotFoundException, DatabaseException {
            if (childType.isLNType()) {
                this.stats.incLNsLoaded();
            }
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
        }

        public void noteMemoryExceeded() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StatsAccumulator
    implements TreeWalkerStatsAccumulator {
        private final Set<Long> inNodeIdsSeen = new HashSet<Long>();
        private final Set<Long> binNodeIdsSeen = new HashSet<Long>();
        private long[] insSeenByLevel = null;
        private long[] binsSeenByLevel = null;
        private long[] binEntriesHistogram = null;
        private long lnCount = 0L;
        private long deletedLNCount = 0L;
        private int mainTreeMaxDepth = 0;
        PrintStream progressStream;
        int progressInterval;
        private static final int MAX_LEVELS = 100;

        StatsAccumulator(PrintStream progressStream, int progressInterval) {
            this.progressStream = progressStream;
            this.progressInterval = progressInterval;
            this.insSeenByLevel = new long[100];
            this.binsSeenByLevel = new long[100];
            this.binEntriesHistogram = new long[10];
        }

        void verifyNode(Node node) {
        }

        @Override
        public void processIN(IN node, Long nid, int level) {
            if (this.inNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.insSeenByLevel);
                this.verifyNode(node);
            }
        }

        @Override
        public void processBIN(BIN node, Long nid, int level) {
            if (this.binNodeIdsSeen.add(nid)) {
                this.tallyLevel(level, this.binsSeenByLevel);
                this.verifyNode(node);
                this.tallyEntries(node, this.binEntriesHistogram);
            }
        }

        private void tallyLevel(int levelArg, long[] nodesSeenByLevel) {
            int level = levelArg;
            if (level >= 65536 && (level &= 0xFFFF) > this.mainTreeMaxDepth) {
                this.mainTreeMaxDepth = level;
            }
            int n = level;
            nodesSeenByLevel[n] = nodesSeenByLevel[n] + 1L;
        }

        @Override
        public void incrementLNCount() {
            ++this.lnCount;
            if (this.progressInterval != 0 && this.lnCount % (long)this.progressInterval == 0L) {
                this.progressStream.println(this.getStats());
            }
        }

        @Override
        public void incrementDeletedLNCount() {
            ++this.deletedLNCount;
        }

        private void tallyEntries(BIN bin, long[] binEntriesHistogram) {
            int nEntries = bin.getNEntries();
            int nonDeletedEntries = 0;
            for (int i = 0; i < nEntries; ++i) {
                if (bin.isEntryPendingDeleted(i) || bin.isEntryKnownDeleted(i)) continue;
                ++nonDeletedEntries;
            }
            int bucket = nonDeletedEntries * 100 / (bin.getMaxEntries() + 1);
            int n = bucket /= 10;
            binEntriesHistogram[n] = binEntriesHistogram[n] + 1L;
        }

        Set<Long> getINNodeIdsSeen() {
            return this.inNodeIdsSeen;
        }

        Set<Long> getBINNodeIdsSeen() {
            return this.binNodeIdsSeen;
        }

        long[] getINsByLevel() {
            return this.insSeenByLevel;
        }

        long[] getBINsByLevel() {
            return this.binsSeenByLevel;
        }

        long[] getBINEntriesHistogram() {
            return this.binEntriesHistogram;
        }

        long getLNCount() {
            return this.lnCount;
        }

        long getDeletedLNCount() {
            return this.deletedLNCount;
        }

        int getMainTreeMaxDepth() {
            return this.mainTreeMaxDepth;
        }

        private StatGroup getStats() {
            StatGroup group = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
            new LongStat(group, BTreeStatDefinition.BTREE_IN_COUNT, this.getINNodeIdsSeen().size());
            new LongStat(group, BTreeStatDefinition.BTREE_BIN_COUNT, this.getBINNodeIdsSeen().size());
            new LongStat(group, BTreeStatDefinition.BTREE_LN_COUNT, this.getLNCount());
            new LongStat(group, BTreeStatDefinition.BTREE_DELETED_LN_COUNT, this.getDeletedLNCount());
            new IntStat(group, BTreeStatDefinition.BTREE_MAINTREE_MAXDEPTH, this.getMainTreeMaxDepth());
            new LongArrayStat(group, BTreeStatDefinition.BTREE_INS_BYLEVEL, this.getINsByLevel());
            new LongArrayStat(group, BTreeStatDefinition.BTREE_BINS_BYLEVEL, this.getBINsByLevel());
            new LongArrayStat(group, BTreeStatDefinition.BTREE_BIN_ENTRIES_HISTOGRAM, this.getBINEntriesHistogram()){

                protected String getFormattedValue() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    if (this.array != null && this.array.length > 0) {
                        boolean first = true;
                        for (int i = 0; i < this.array.length; ++i) {
                            if (this.array[i] <= 0L) continue;
                            if (!first) {
                                sb.append("; ");
                            }
                            first = false;
                            int startPct = i * 10;
                            int endPct = (i + 1) * 10 - 1;
                            sb.append(startPct).append("-");
                            sb.append(endPct).append("%: ");
                            sb.append(Stat.FORMAT.format(this.array[i]));
                        }
                    }
                    sb.append("]");
                    return sb.toString();
                }
            };
            return group;
        }
    }

    private static class ObsoleteProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final LocalUtilizationTracker localTracker;
        private final DatabaseImpl db;

        ObsoleteProcessor(DatabaseImpl db, LocalUtilizationTracker localTracker) {
            this.db = db;
            this.localTracker = localTracker;
        }

        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] lnKey) {
            assert (childLsn != -1L);
            int size2 = 0;
            if (lnKey != null && node instanceof LN) {
                LN ln = (LN)node;
                size2 = ln.getLastLoggedSize();
            }
            this.localTracker.countObsoleteNodeInexact(childLsn, childType, size2, this.db);
        }

        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
            assert (ln != null);
            this.localTracker.countObsoleteNodeInexact(childLsn, ln.getGenericLogType(), 0, this.db);
        }

        public void noteMemoryExceeded() {
        }
    }

    private static class ObsoleteTreeWalker
    extends SortedLSNTreeWalker {
        private final IN rootIN;

        private ObsoleteTreeWalker(DatabaseImpl dbImpl, long rootLsn, boolean fetchLNSize, SortedLSNTreeWalker.TreeNodeProcessor callback, IN rootIN) throws DatabaseException {
            super(new DatabaseImpl[]{dbImpl}, true, new long[]{rootLsn}, callback, null, null);
            this.accumulateLNs = fetchLNSize;
            this.rootIN = rootIN;
        }

        protected IN getResidentRootIN(DatabaseImpl ignore) {
            if (this.rootIN != null) {
                this.rootIN.latchShared();
            }
            return this.rootIN;
        }
    }
}

