/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx;

import com.sleepycat.je.Environment;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class JEMBean
implements EnvironmentImpl.MBeanRegistrar {
    public static final MBeanParameterInfo[] statParams = new MBeanParameterInfo[]{new MBeanParameterInfo("clear", "java.lang.Boolean", "If true, reset statistics after reading."), new MBeanParameterInfo("fast", "java.lang.Boolean", "If true, only return statistics which do not require expensive computation.")};
    private MBeanInfo mbeanInfo;
    protected MBeanServer server;
    protected ObjectName jeName;
    protected String className;
    protected String DESCRIPTION;
    protected Class<?> currentClass;
    protected Environment env;
    protected ArrayList<MBeanOperationInfo> operationList = new ArrayList();

    protected JEMBean(Environment env) {
        this.env = env;
        this.initClassFields();
        this.resetMBeanInfo();
    }

    public JEMBean() {
        this.initClassFields();
    }

    protected abstract void initClassFields();

    protected void resetMBeanInfo() {
        this.mbeanInfo = new MBeanInfo(this.currentClass.getName(), this.DESCRIPTION, this.getAttributeList(), this.getConstructors(), this.getOperationList(), this.getNotificationInfo());
    }

    protected abstract MBeanAttributeInfo[] getAttributeList();

    protected abstract void addOperations();

    protected MBeanConstructorInfo[] getConstructors() {
        Constructor<?>[] constructors = this.currentClass.getConstructors();
        MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructorInfo[i] = new MBeanConstructorInfo(this.currentClass.getName(), constructors[i]);
        }
        return constructorInfo;
    }

    private MBeanOperationInfo[] getOperationList() {
        this.addOperations();
        return this.operationList.toArray(new MBeanOperationInfo[this.operationList.size()]);
    }

    protected MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public void doRegister(Environment env) throws Exception {
        this.server = ManagementFactory.getPlatformMBeanServer();
        StringBuilder sb = new StringBuilder("com.sleepycat.je.jmx:name=");
        sb.append(this.className).append("(");
        String noColonPathname = env.getHome().getPath().replaceAll(":", "<colon>");
        sb.append(noColonPathname).append(")");
        this.jeName = new ObjectName(sb.toString());
        this.doRegisterMBean(env);
    }

    protected abstract void doRegisterMBean(Environment var1) throws Exception;

    public void doUnregister() throws Exception {
        if (this.server != null) {
            this.server.unregisterMBean(this.jeName);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    protected StatsConfig getStatsConfig(Object[] params) {
        StatsConfig statsConfig = new StatsConfig();
        if (params != null && params.length > 0 && params[0] != null) {
            Boolean clear2 = (Boolean)params[0];
            statsConfig.setClear(clear2);
        }
        if (params != null && params.length > 1 && params[1] != null) {
            Boolean fast = (Boolean)params[1];
            statsConfig.setFast(fast);
        }
        return statsConfig;
    }
}

