/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INFileReader
extends FileReader {
    private boolean lastEntryWasDelete;
    private boolean lastEntryWasDupDelete;
    private LogEntryType fromLogType;
    private boolean isProvisional;
    private Map<LogEntryType, LogEntry> targetEntryMap;
    private LogEntry targetLogEntry;
    private Set<LogEntryType> idTrackingSet;
    private Map<LogEntryType, LogEntry> idTrackingMap;
    private boolean trackIds;
    private long minReplicatedNodeId;
    private long maxNodeId;
    private long minReplicatedDbId;
    private long maxDbId;
    private long minReplicatedTxnId;
    private long maxTxnId;
    private boolean mapDbOnly;
    private long ckptEnd;
    private long partialCkptStart;
    private RecoveryUtilizationTracker tracker;
    private VLSNRecoveryProxy vlsnProxy;
    private Set<DatabaseId> logVersion8UpgradeDbs;
    private AtomicBoolean logVersion8UpgradeDeltas;

    public INFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, boolean trackIds, boolean mapDbOnly, long partialCkptStart, long ckptEnd, RecoveryUtilizationTracker tracker) {
        this(env, readBufferSize, startLsn, finishLsn, trackIds, mapDbOnly, partialCkptStart, ckptEnd, tracker, null, null);
    }

    public INFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, boolean trackIds, boolean mapDbOnly, long partialCkptStart, long ckptEnd, RecoveryUtilizationTracker tracker, Set<DatabaseId> logVersion8UpgradeDbs, AtomicBoolean logVersion8UpgradeDeltas) throws DatabaseException {
        super(env, readBufferSize, true, startLsn, null, -1L, finishLsn);
        this.trackIds = trackIds;
        this.mapDbOnly = mapDbOnly;
        this.ckptEnd = ckptEnd;
        this.targetEntryMap = new HashMap<LogEntryType, LogEntry>();
        if (trackIds) {
            this.maxNodeId = 0L;
            this.maxDbId = 0L;
            this.maxTxnId = 0L;
            this.minReplicatedNodeId = 0L;
            this.minReplicatedDbId = -256L;
            this.minReplicatedTxnId = 0L;
            this.tracker = tracker;
            this.partialCkptStart = partialCkptStart;
            this.idTrackingSet = new HashSet<LogEntryType>();
            this.idTrackingMap = new HashMap<LogEntryType, LogEntry>();
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isNodeType()) continue;
                this.idTrackingSet.add(entryType);
            }
            this.idTrackingSet.add(LogEntryType.LOG_BIN_DELTA);
            this.vlsnProxy = this.envImpl.getVLSNProxy();
            this.idTrackingSet.add(LogEntryType.LOG_ROLLBACK_START);
            this.logVersion8UpgradeDbs = logVersion8UpgradeDbs;
            this.logVersion8UpgradeDeltas = logVersion8UpgradeDeltas;
        }
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    @Override
    protected boolean isTargetEntry() throws DatabaseException {
        this.lastEntryWasDelete = false;
        this.lastEntryWasDupDelete = false;
        this.targetLogEntry = null;
        this.isProvisional = this.currentEntryHeader.getProvisional().isProvisional(this.getLastLsn(), this.ckptEnd);
        this.fromLogType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry possibleTarget = this.targetEntryMap.get(this.fromLogType);
        if (!this.isProvisional) {
            this.targetLogEntry = possibleTarget;
        }
        if (LogEntryType.LOG_IN_DELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDelete = true;
        }
        if (LogEntryType.LOG_IN_DUPDELETE_INFO.equals(this.fromLogType)) {
            this.lastEntryWasDupDelete = true;
        }
        if (!this.trackIds) {
            return this.targetLogEntry != null;
        }
        if (!(this.fromLogType.isNodeType() || this.fromLogType.equals(LogEntryType.LOG_BIN_DELTA) || LogEntryType.LOG_FILE_HEADER.equals(this.fromLogType))) {
            this.tracker.countNewLogEntry(this.getLastLsn(), this.fromLogType, this.currentEntryHeader.getSize() + this.currentEntryHeader.getItemSize(), null);
        }
        if (LogEntryType.LOG_DBTREE.equals(this.fromLogType)) {
            this.tracker.saveLastLoggedMapLN(DbTree.ID_DB_ID, this.getLastLsn());
            this.tracker.saveLastLoggedMapLN(DbTree.NAME_DB_ID, this.getLastLsn());
            this.tracker.resetDbInfo(DbTree.ID_DB_ID);
            this.tracker.resetDbInfo(DbTree.NAME_DB_ID);
        }
        return this.targetLogEntry != null || this.idTrackingSet.contains(this.fromLogType) || this.currentEntryHeader.getReplicated();
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        INContainingEntry inEntry;
        boolean useEntry = false;
        if (this.targetLogEntry != null) {
            this.targetLogEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
            DatabaseId dbId = this.getDatabaseId();
            boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
            boolean bl = useEntry = !this.mapDbOnly || isMapDb;
        }
        if (!this.trackIds) {
            return useEntry;
        }
        if (this.currentEntryHeader.getReplicated()) {
            this.vlsnProxy.trackMapping(this.getLastLsn(), this.currentEntryHeader, null);
        }
        if (this.targetLogEntry == null && !this.idTrackingSet.contains(this.fromLogType)) {
            int endPosition = INFileReader.threadSafeBufferPosition(entryBuffer) + this.currentEntryHeader.getItemSize();
            INFileReader.threadSafeBufferPosition(entryBuffer, endPosition);
            return useEntry;
        }
        if (this.targetLogEntry == null) {
            assert (this.idTrackingSet.contains(this.fromLogType));
            this.targetLogEntry = this.idTrackingMap.get(this.fromLogType);
            if (this.targetLogEntry == null) {
                this.targetLogEntry = this.fromLogType.getNewLogEntry();
                this.idTrackingMap.put(this.fromLogType, this.targetLogEntry);
            }
            this.targetLogEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        }
        if (this.fromLogType.isNodeType() || this.fromLogType.equals(LogEntryType.LOG_BIN_DELTA)) {
            this.tracker.countNewLogEntry(this.getLastLsn(), this.fromLogType, this.currentEntryHeader.getSize() + this.currentEntryHeader.getItemSize(), this.targetLogEntry.getDbId());
        }
        if (this.fromLogType.equals(LogEntryType.LOG_ROLLBACK_START)) {
            this.vlsnProxy.trackMapping(this.getLastLsn(), this.currentEntryHeader, this.targetLogEntry);
        }
        DatabaseId dbIdToReset = null;
        long fileNumToReset = -1L;
        if (this.fromLogType.isLNType()) {
            LNLogEntry lnEntry = (LNLogEntry)this.targetLogEntry;
            if (this.fromLogType.equals(LogEntryType.LOG_MAPLN) || this.fromLogType.equals(LogEntryType.LOG_MAPLN_TRANSACTIONAL)) {
                MapLN mapLN = (MapLN)lnEntry.getMainItem();
                DatabaseId dbId = mapLN.getDatabase().getId();
                long dbIdVal = dbId.getId();
                this.maxDbId = dbIdVal > this.maxDbId ? dbIdVal : this.maxDbId;
                this.minReplicatedDbId = dbIdVal < this.minReplicatedDbId ? dbIdVal : this.minReplicatedDbId;
                dbIdToReset = dbId;
                this.tracker.saveLastLoggedMapLN(dbId, this.getLastLsn());
            }
            if (this.fromLogType.isTransactional()) {
                long txnId = lnEntry.getTxnId();
                this.maxTxnId = txnId > this.maxTxnId ? txnId : this.maxTxnId;
                long l = this.minReplicatedTxnId = txnId < this.minReplicatedTxnId ? txnId : this.minReplicatedTxnId;
            }
            if (LogEntryType.LOG_FILESUMMARYLN.equals(this.fromLogType)) {
                long fileNum;
                lnEntry.postFetchInit(false);
                byte[] keyBytes = lnEntry.getKey();
                FileSummaryLN fsln = (FileSummaryLN)lnEntry.getMainItem();
                fileNumToReset = fileNum = FileSummaryLN.getFileNumber(keyBytes);
                this.tracker.saveLastLoggedFileSummaryLN(fileNum, this.getLastLsn());
            }
        }
        if (this.fromLogType.isINType()) {
            inEntry = (INLogEntry)this.targetLogEntry;
            long nodeId = ((INLogEntry)inEntry).getNodeId();
            assert (nodeId != -1L);
            this.maxNodeId = nodeId > this.maxNodeId ? nodeId : this.maxNodeId;
            long l = this.minReplicatedNodeId = nodeId < this.minReplicatedNodeId ? nodeId : this.minReplicatedNodeId;
        }
        if (this.fromLogType.isINType() || this.fromLogType.equals(LogEntryType.LOG_BIN_DELTA)) {
            long newLsn;
            inEntry = (INContainingEntry)((Object)this.targetLogEntry);
            long oldLsn = inEntry.getPrevFullLsn();
            if (oldLsn != -1L) {
                newLsn = this.getLastLsn();
                this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, this.fromLogType, 0, inEntry.getDbId(), false);
            }
            if ((oldLsn = inEntry.getPrevDeltaLsn()) != -1L) {
                newLsn = this.getLastLsn();
                this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, this.fromLogType, 0, inEntry.getDbId(), false);
            }
            if (this.isProvisional && this.partialCkptStart != -1L && DbLsn.compareTo(this.partialCkptStart, oldLsn = this.getLastLsn()) < 0) {
                this.tracker.countObsoleteUnconditional(oldLsn, this.fromLogType, 0, inEntry.getDbId(), false);
            }
        }
        if (fileNumToReset != -1L) {
            this.tracker.resetFileInfo(fileNumToReset);
        }
        if (dbIdToReset != null) {
            this.tracker.resetDbInfo(dbIdToReset);
        }
        if (this.currentEntryHeader.getVersion() < 8) {
            if (this.logVersion8UpgradeDbs != null && this.fromLogType.isNodeType()) {
                this.logVersion8UpgradeDbs.add(this.targetLogEntry.getDbId());
            }
            if (this.logVersion8UpgradeDeltas != null && (this.fromLogType.equals(LogEntryType.LOG_BIN_DELTA) || this.fromLogType.equals(LogEntryType.LOG_DUP_BIN_DELTA))) {
                this.logVersion8UpgradeDeltas.set(true);
            }
        }
        return useEntry;
    }

    public IN getIN(DatabaseImpl dbImpl) throws DatabaseException {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getIN(dbImpl);
    }

    public DatabaseId getDatabaseId() {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getDbId();
    }

    public long getMaxNodeId() {
        return this.maxNodeId;
    }

    public long getMinReplicatedNodeId() {
        return this.minReplicatedNodeId;
    }

    public long getMaxDbId() {
        return this.maxDbId;
    }

    public long getMinReplicatedDbId() {
        return this.minReplicatedDbId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public long getMinReplicatedTxnId() {
        return this.minReplicatedTxnId;
    }

    public boolean isDeleteInfo() {
        return this.lastEntryWasDelete;
    }

    public boolean isDupDeleteInfo() {
        return this.lastEntryWasDupDelete;
    }

    public boolean isBINDelta() {
        return this.targetLogEntry.getLogType().equals(LogEntryType.LOG_BIN_DELTA);
    }

    public VLSNRecoveryProxy getVLSNProxy() {
        return this.vlsnProxy;
    }
}

