/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.ReplayStatDefinition;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.ReplicaStatDefinition;
import com.sleepycat.je.rep.stream.FeederTxnStatDefinition;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.utilint.IntegralRateStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedEnvironmentStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int VALUE_UNAVAILABLE = -1;
    private final StatGroup feederManagerStats;
    private final StatGroup feederTxnStats;
    private final StatGroup replayStats;
    private final StatGroup trackerStats;
    private final StatGroup protocolStats;
    private final StatGroup vlsnIndexStats;
    private final Map<String, String> tipsMap = new HashMap<String, String>();

    ReplicatedEnvironmentStats(RepImpl repImpl, StatsConfig config) {
        RepNode repNode = repImpl.getRepNode();
        FeederManager feederManager = repNode.feederManager();
        this.feederManagerStats = feederManager.getFeederManagerStats(config);
        this.feederTxnStats = repNode.getFeederTxns().getStats(config);
        Replica replica = repNode.getReplica();
        this.replayStats = replica.getReplayStats(config);
        this.trackerStats = replica.getTrackerStats(config);
        this.protocolStats = feederManager.getProtocolStats(config);
        this.vlsnIndexStats = repImpl.getVLSNIndex().getStats(config);
        this.protocolStats.addAll(replica.getProtocolStats(config));
        this.addMessageRateStats();
        this.addBytesRateStats();
    }

    public Collection<StatGroup> getStatGroups() {
        return this.feederTxnStats != null ? Arrays.asList(this.feederManagerStats, this.feederTxnStats, this.replayStats, this.trackerStats, this.protocolStats, this.vlsnIndexStats) : Arrays.asList(this.feederManagerStats, this.replayStats, this.trackerStats, this.protocolStats, this.vlsnIndexStats);
    }

    public static String[] getStatGroupTitles() {
        return new String[]{"FeederManager", "FeederTxns", "BinaryProtocol", "Replay", "ConsistencyTracker", "VLSNIndex"};
    }

    private void addMessageRateStats() {
        IntegralRateStat msgReadRate = new IntegralRateStat(this.protocolStats, BinaryProtocolStatDefinition.MESSAGE_READ_RATE, this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_READ), this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS), 1000000000L);
        IntegralRateStat msgWriteRate = new IntegralRateStat(this.protocolStats, BinaryProtocolStatDefinition.MESSAGE_WRITE_RATE, this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN), this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS), 1000000000L);
    }

    private void addBytesRateStats() {
        IntegralRateStat bytesReadRate = new IntegralRateStat(this.protocolStats, BinaryProtocolStatDefinition.BYTES_READ_RATE, this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_READ), this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS), 1000000000L);
        IntegralRateStat bytesWriteRate = new IntegralRateStat(this.protocolStats, BinaryProtocolStatDefinition.BYTES_WRITE_RATE, this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_WRITTEN), this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS), 1000000000L);
    }

    public int getNFeedersCreated() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_CREATED);
    }

    public int getNFeedersShutdown() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN);
    }

    public long getNMaxReplicaLag() {
        return this.feederManagerStats.getLong(FeederManagerStatDefinition.N_MAX_REPLICA_LAG);
    }

    public String getNMaxReplicaLagName() {
        return this.feederManagerStats.getString(FeederManagerStatDefinition.N_MAX_REPLICA_LAG_NAME);
    }

    public long getNTxnsAcked() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TXNS_ACKED);
    }

    public long getNTxnsNotAcked() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TXNS_NOT_ACKED);
    }

    public long getTotalTxnMs() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TOTAL_TXN_MS);
    }

    public long getAckWaitMs() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.ACK_WAIT_MS);
    }

    public long getNReplayCommits() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMITS);
    }

    public long getNReplayCommitAcks() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_ACKS);
    }

    public long getNReplayCommitSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_SYNCS);
    }

    public long getNReplayCommitNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_NO_SYNCS);
    }

    public long getNReplayCommitWriteNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS);
    }

    public long getNReplayAborts() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ABORTS);
    }

    public long getNReplayNameLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_NAME_LNS);
    }

    public long getNReplayLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_LNS);
    }

    public long getReplayElapsedTxnTime() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ELAPSED_TXN_TIME);
    }

    public long getReplayMinCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayMaxCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayTotalCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS);
    }

    public long getNProtocolBytesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_READ);
    }

    public long getNProtocolMessagesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_READ);
    }

    public long getNProtocolBytesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_WRITTEN);
    }

    public long getNProtocolMessagesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
    }

    public long getProtocolReadNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_READ_NANOS);
    }

    public long getProtocolWriteNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_WRITE_NANOS);
    }

    public long getProtocolMessageReadRate() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.MESSAGE_READ_RATE);
    }

    public long getProtocolMessageWriteRate() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.MESSAGE_WRITE_RATE);
    }

    public long getProtocolBytesReadRate() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.BYTES_READ_RATE);
    }

    public long getProtocolBytesWriteRate() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.BYTES_WRITE_RATE);
    }

    public long getTrackerLagConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS);
    }

    public long getTrackerLagConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS);
    }

    public long getTrackerVLSNConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS);
    }

    public long getTrackerVLSNConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StatGroup group : this.getStatGroups()) {
            sb.append(group.toString());
        }
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        for (StatGroup group : this.getStatGroups()) {
            sb.append(group.toStringVerbose());
        }
        return sb.toString();
    }

    public Map<String, String> getTips() {
        for (StatGroup group : this.getStatGroups()) {
            this.tipsMap.put(group.getName(), group.getDescription());
            for (StatDefinition def : group.getStats().keySet()) {
                this.tipsMap.put(def.getName(), def.getDescription());
            }
        }
        return this.tipsMap;
    }
}

