/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNTracker;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.logging.Logger;

public class LocalCBVLSNUpdater {
    private static final String VLSN_SOURCE = "vlsn";
    private static final String MASTER_SOURCE = "master";
    private static final String HEARTBEAT_SOURCE = "heartbeat";
    private final NameIdPair nameIdPair;
    private final RepNode repNode;
    private VLSN nodeCBVLSN;
    private boolean updatePending;
    private static boolean suppressGroupDBUpdates = false;
    private final Logger logger;

    LocalCBVLSNUpdater(NameIdPair nameIdPair, RepNode repNode) {
        this.nameIdPair = nameIdPair;
        this.repNode = repNode;
        this.nodeCBVLSN = VLSN.NULL_VLSN;
        this.updatePending = false;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    private void set(VLSN syncableVLSN, String source) {
        assert (this.repNode.isMaster()) : "LocalCBVLSNUpdater.set() can only be called by the master";
        if (!this.nodeCBVLSN.equals(syncableVLSN)) {
            LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "update local CBVLSN for " + this.nameIdPair + " from nodeCBVLSN " + this.nodeCBVLSN + " to " + syncableVLSN + " from " + source);
            if (this.nodeCBVLSN.compareTo(syncableVLSN) >= 0) {
                throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "nodeCBVLSN" + this.nodeCBVLSN + " >= " + syncableVLSN + " attempted update local CBVLSN for " + this.nameIdPair + " from " + source);
            }
            this.nodeCBVLSN = syncableVLSN;
            this.updatePending = true;
        }
    }

    public void updateForReplica(VLSN syncableVLSN) {
        this.doUpdate(syncableVLSN, VLSN_SOURCE);
    }

    public void updateForReplica(Protocol.HeartbeatResponse heartbeat) {
        this.doUpdate(heartbeat.getSyncupVLSN(), HEARTBEAT_SOURCE);
    }

    void updateForMaster(LocalCBVLSNTracker tracker) {
        this.doUpdate(tracker.getBroadcastCBVLSN(), MASTER_SOURCE);
    }

    void doUpdate(VLSN vlsn, String source) {
        this.set(vlsn, source);
        this.repNode.getRepImpl().updateCBVLSN(this);
    }

    public void update() {
        if (!this.updatePending) {
            return;
        }
        if (suppressGroupDBUpdates) {
            this.updatePending = false;
            return;
        }
        if (this.repNode.isShutdown()) {
            return;
        }
        try {
            VLSN candidate = this.nodeCBVLSN;
            if (candidate.isNull()) {
                return;
            }
            if (candidate.compareTo(this.repNode.getGroupCBVLSN()) < 0) {
                return;
            }
            boolean updated2 = this.repNode.repGroupDB.updateLocalCBVLSN(this.nameIdPair, candidate);
            if (updated2) {
                this.updatePending = false;
            }
        }
        catch (EnvironmentFailureException e) {
            throw e;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            LoggerUtils.warning(this.repNode.logger, this.repNode.getRepImpl(), "local cbvlsn update failed for node: " + this.nameIdPair + " Error: " + e.getMessage());
        }
    }

    public static void setSuppressGroupDBUpdates(boolean suppressGroupDBUpdates) {
        LocalCBVLSNUpdater.suppressGroupDBUpdates = suppressGroupDBUpdates;
    }

    static boolean getSuppressGroupDBUpdates() {
        return suppressGroupDBUpdates;
    }
}

