/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.utilint.EventTrace;

public class TimingLatch
extends Latch {
    private static final int WAIT_THRESHOLD_NANOS = 50000;
    private static final int PREV_HOLD_THRESHOLD_NANOS = 50000;
    private long acquireTime;
    private long releaseTime;
    private Thread lastThread;
    private final boolean debug;
    private final int waitThreshold;
    private final int holdThreshold;

    public TimingLatch(String name, boolean debug) {
        super(name);
        this.debug = debug;
        this.waitThreshold = 50000;
        this.holdThreshold = 50000;
    }

    public TimingLatch(String name, boolean debug, int waitThreshold, int holdThreshold) {
        super(name);
        this.debug = debug;
        this.waitThreshold = waitThreshold;
        this.holdThreshold = holdThreshold;
    }

    public void release() {
        this.releaseTime = System.nanoTime();
        EventTrace.addEvent(new ReleaseEvent(this.releaseTime));
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquire() {
        block6: {
            block5: {
                if (!this.debug) {
                    super.acquire();
                    return;
                }
                try {
                    EventTrace.addEvent(new AcquireRequestEvent());
                    if (this.acquireNoWait()) {
                        EventTrace.addEvent(new AcquireCompleteEvent(System.nanoTime(), 0L));
                        Object var10_1 = null;
                        break block5;
                    }
                    long startWait = System.nanoTime();
                    super.acquire();
                    long endWait = System.nanoTime();
                    long ourWaitTime = endWait - startWait;
                    EventTrace.addEvent(new AcquireCompleteEvent(System.nanoTime(), ourWaitTime));
                    long previousHoldTime = this.releaseTime - this.acquireTime;
                    if (previousHoldTime > (long)this.holdThreshold || ourWaitTime > (long)this.waitThreshold) {
                        System.out.println(String.format("%1tT %s waited %,d nanosec for %s\n Previous held by %s for %,d nanosec.", System.currentTimeMillis(), Thread.currentThread(), ourWaitTime, this.getName(), this.lastThread, previousHoldTime));
                        EventTrace.dumpEvents(System.out);
                        EventTrace.disableEvents = false;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var10_3 = null;
                    this.acquireTime = System.nanoTime();
                    this.lastThread = Thread.currentThread();
                    throw throwable;
                }
            }
            this.acquireTime = System.nanoTime();
            this.lastThread = Thread.currentThread();
            return;
        }
        Object var10_2 = null;
        this.acquireTime = System.nanoTime();
        this.lastThread = Thread.currentThread();
    }

    public class ReleaseEvent
    extends EventTrace {
        private long startTime;
        private String name;
        Thread us;

        public ReleaseEvent(long time) {
            this.startTime = time;
            this.name = TimingLatch.this.getName();
            this.us = Thread.currentThread();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ReleaseEvent for " + this.name + " ");
            sb.append(this.us).append(" at ").append(String.format("%,d", this.startTime));
            return sb.toString();
        }
    }

    public class AcquireCompleteEvent
    extends EventTrace {
        private long startTime;
        private long waitTime;
        private String name;
        Thread us;

        public AcquireCompleteEvent(long startTime, long waitTime) {
            this.startTime = startTime;
            this.waitTime = waitTime;
            this.name = TimingLatch.this.getName();
            this.us = Thread.currentThread();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AcquireCompleteEvent for " + this.name + " ");
            sb.append(this.us).append(" at ").append(String.format("%,d", this.startTime)).append(" Took: ").append(String.format("%,d", this.waitTime));
            return sb.toString();
        }
    }

    public class AcquireRequestEvent
    extends EventTrace {
        private long startTime = System.nanoTime();
        private String name;
        Thread us;

        public AcquireRequestEvent() {
            this.name = TimingLatch.this.getName();
            this.us = Thread.currentThread();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AcquireRequestEvent for " + this.name + " ");
            sb.append(this.us).append(" at ").append(String.format("%,d", this.startTime));
            return sb.toString();
        }
    }
}

