/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;

public class ConverterReader
implements Reader {
    private static final long serialVersionUID = -305788321064984348L;
    private Converter converter;
    private transient Format oldFormat;

    ConverterReader(Converter converter) {
        this.converter = converter;
    }

    public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormat) {
        this.oldFormat = oldFormat;
    }

    public Object newInstance(EntityInput input2, boolean rawAccess) throws RefreshException {
        return this.oldFormat.newInstance(input2, true);
    }

    public void readPriKey(Object o, EntityInput input2, boolean rawAccess) throws RefreshException {
        this.oldFormat.readPriKey(o, input2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(Object o, EntityInput input2, boolean rawAccess) throws RefreshException {
        Catalog catalog = input2.getCatalog();
        boolean currentRawMode = input2.setRawAccess(true);
        try {
            o = this.oldFormat.readObject(o, input2, true);
            Object var7_6 = null;
            input2.setRawAccess(currentRawMode);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            input2.setRawAccess(currentRawMode);
            throw throwable;
        }
        o = this.converter.getConversion().convert(o);
        if (!rawAccess && o instanceof RawObject) {
            o = catalog.convertRawObject((RawObject)o, null);
        }
        return o;
    }

    public Accessor getAccessor(boolean rawAccess) {
        return this.oldFormat.getAccessor(rawAccess);
    }
}

