/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import net.sf.picard.fastq.AsyncFastqWriter;
import net.sf.picard.fastq.BasicFastqWriter;
import net.sf.picard.fastq.FastqWriter;
import net.sf.samtools.Defaults;

public class FastqWriterFactory {
    boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    boolean createMd5 = Defaults.CREATE_MD5;

    public void setUseAsyncIo(boolean bl) {
        this.useAsyncIo = bl;
    }

    public void setCreateMd5(boolean bl) {
        this.createMd5 = bl;
    }

    public FastqWriter newWriter(File file) {
        BasicFastqWriter basicFastqWriter = new BasicFastqWriter(file, this.createMd5);
        if (this.useAsyncIo) {
            return new AsyncFastqWriter(basicFastqWriter, 2000);
        }
        return basicFastqWriter;
    }
}

