/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CloseableIterator;

public abstract class AbstractIlluminaPositionFileReader
implements CloseableIterator<PositionInfo> {
    public static final float MAX_POS = 1.0E7f;
    private static Pattern FileNamePattern = Pattern.compile("^s_(\\d+)_(\\d+)(_pos\\.txt|\\.locs|\\.clocs|_pos\\.txt.gz|_pos\\.txt.bz2)$");
    private final File file;
    private final int lane;
    private final int tile;

    public AbstractIlluminaPositionFileReader(File file) {
        this.file = file;
        int[] nArray = this.fileNameToLaneAndTile(file.getName());
        this.lane = nArray[0];
        this.tile = nArray[1];
    }

    public int getTile() {
        return this.tile;
    }

    public int getLane() {
        return this.lane;
    }

    public File getFile() {
        return this.file;
    }

    private int[] fileNameToLaneAndTile(String string2) {
        String[] stringArray = string2.split(File.pathSeparator);
        Matcher matcher = FileNamePattern.matcher(stringArray[stringArray.length - 1]);
        if (!matcher.matches()) {
            throw new PicardException("File name not of the right structure: <filePath>/s_<lane>_<tile>(_pos.txt|_pos.txt.gz|_pos.txt.bz2.locs|.clocs).  File name (" + string2 + ")");
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
    }

    @Override
    public final PositionInfo next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such cluster, cluster count(" + this.makeExceptionMsg() + ")");
        }
        return this.unsafeNextInfo();
    }

    protected abstract PositionInfo unsafeNextInfo();

    protected abstract String makeExceptionMsg();

    @Override
    public abstract boolean hasNext();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class PositionInfo {
        public final float xPos;
        public final float yPos;
        public final int lane;
        public final int tile;
        public final int xQseqCoord;
        public final int yQseqCoord;

        public PositionInfo(float f, float f2, int n, int n2) {
            if (f < 0.0f || f2 < 0.0f) {
                throw new IllegalArgumentException("X and Y position values must be positive (x,y)=(" + f + ", y) lane(" + n + ") tile(" + n2 + ")");
            }
            if (f > 1.0E7f || f2 > 1.0E7f) {
                throw new IllegalArgumentException("X and Y position values must be less than 1.0E7 (x,y)=(" + f + ", y) lane(" + n + ") tile(" + n2 + ")");
            }
            this.xPos = f;
            this.yPos = f2;
            this.xQseqCoord = this.posToQSeqCoord(f);
            this.yQseqCoord = this.posToQSeqCoord(f2);
            this.lane = n;
            this.tile = n2;
        }

        private int posToQSeqCoord(float f) {
            return Math.round(f * 10.0f + 1000.0f);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != PositionInfo.class) {
                return false;
            }
            if (object == this) {
                return true;
            }
            PositionInfo positionInfo = (PositionInfo)object;
            return this.xPos == positionInfo.xPos && this.yPos == positionInfo.yPos && this.lane == positionInfo.lane && this.tile == positionInfo.tile && this.xQseqCoord == positionInfo.xQseqCoord && this.yQseqCoord == positionInfo.yQseqCoord;
        }
    }
}

