/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.filter.AlignedFilter;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.ReadNameFilter;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class FilterSamReads
extends CommandLineProgram {
    private static final Log log = Log.getInstance(FilterSamReads.class);
    @Usage
    public String USAGE = "Produces a new SAM or BAM file by including or excluding aligned reads or a list of reads names supplied in the READ_LIST_FILE from the INPUT SAM or BAM file.\n";
    @Option(doc="The SAM or BAM file that will be filtered.", optional=false, shortName="I")
    public File INPUT;
    @Option(doc="Filter.", optional=false)
    public Filter FILTER = null;
    @Option(doc="Read List File containing reads that will be included or excluded from the OUTPUT SAM or BAM file.", optional=true, shortName="RLF")
    public File READ_LIST_FILE;
    @Option(doc="SortOrder of the OUTPUT SAM or BAM file, otherwise use the SortOrder of the INPUT file.", optional=true, shortName="SO")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(doc="Create .reads files (for debugging purposes)", optional=true)
    public boolean WRITE_READS_FILES = true;
    @Option(doc="SAM or BAM file to write read excluded results to", optional=false, shortName="O")
    public File OUTPUT;

    private void filterReads(FilteringIterator filteringIterator) {
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        SAMFileHeader.SortOrder sortOrder = sAMFileReader.getFileHeader().getSortOrder();
        SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader();
        if (this.SORT_ORDER != null) {
            sAMFileHeader.setSortOrder(this.SORT_ORDER);
        }
        boolean bl = sortOrder.equals((Object)sAMFileHeader.getSortOrder());
        log.info("Filtering [presorted=" + bl + "] " + this.INPUT.getName() + " -> OUTPUT=" + this.OUTPUT.getName() + " [sortorder=" + sAMFileHeader.getSortOrder().name() + "]");
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, bl, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Written");
        while (filteringIterator.hasNext()) {
            SAMRecord sAMRecord = filteringIterator.next();
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        filteringIterator.close();
        sAMFileWriter.close();
        sAMFileReader.close();
        log.info(new DecimalFormat("#,###").format(progressLogger.getCount()) + " SAMRecords written to " + this.OUTPUT.getName());
    }

    private void writeReadsFile(File file) throws IOException {
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        File file2 = new File(this.OUTPUT.getParentFile(), IoUtil.basename(file) + ".reads");
        IoUtil.assertFileIsWritable(file2);
        BufferedWriter bufferedWriter = IoUtil.openFileForBufferedWriting(file2, false);
        for (SAMRecord sAMRecord : sAMFileReader) {
            bufferedWriter.write(sAMRecord.toString() + "\n");
        }
        bufferedWriter.close();
        sAMFileReader.close();
        IoUtil.assertFileIsReadable(file2);
    }

    @Override
    protected int doWork() {
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            IoUtil.assertFileIsWritable(this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.INPUT);
            }
            switch (this.FILTER) {
                case includeAligned: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new AlignedFilter(true), true));
                    break;
                }
                case excludeAligned: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new AlignedFilter(false), true));
                    break;
                }
                case includeReadList: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new ReadNameFilter(this.READ_LIST_FILE, true)));
                    break;
                }
                case excludeReadList: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new ReadNameFilter(this.READ_LIST_FILE, false)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.FILTER.name() + " has not been implemented!");
                }
            }
            IoUtil.assertFileIsReadable(this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.OUTPUT);
            }
            return 0;
        }
        catch (Exception exception) {
            if (this.OUTPUT.exists() && !this.OUTPUT.delete()) {
                log.warn("Failed to delete " + this.OUTPUT.getAbsolutePath());
            }
            log.error(exception, "Failed to filter " + this.INPUT.getName());
            return 1;
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.INPUT.equals(this.OUTPUT)) {
            return new String[]{"INPUT file and OUTPUT file must differ!"};
        }
        if ((this.FILTER.equals((Object)Filter.includeReadList) || this.FILTER.equals((Object)Filter.excludeReadList)) && this.READ_LIST_FILE == null) {
            return new String[]{"A READ_LIST_FILE must be specified when using the " + this.FILTER.name() + " option"};
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] stringArray) {
        System.exit(new FilterSamReads().instanceMain(stringArray));
    }

    private static enum Filter {
        includeAligned("OUTPUT SAM/BAM will contain aligned reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of paired reads must be aligned to be included in the OUTPUT SAM or BAM)"),
        excludeAligned("OUTPUT SAM/BAM will contain un-mapped reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of pair must be aligned to be excluded from the OUTPUT SAM or BAM)"),
        includeReadList("OUTPUT SAM/BAM will contain reads that are supplied in the READ_LIST_FILE file"),
        excludeReadList("OUTPUT bam will contain reads that are *not* supplied in the READ_LIST_FILE file");

        private final String description;

        private Filter(String string3) {
            this.description = string3;
        }

        public String toString() {
            return this.name() + " [" + this.description + "]";
        }
    }
}

