/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.seekablestream.SeekableStream;

class DiskBasedBAMFileIndex
extends AbstractBAMFileIndex {
    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        super(file, sAMSequenceDictionary);
    }

    DiskBasedBAMFileIndex(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) {
        super(seekableStream, sAMSequenceDictionary);
    }

    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        super(file, sAMSequenceDictionary, bl);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int n, int n2, int n3) {
        BAMIndexContent bAMIndexContent = this.query(n, n2, n3);
        if (bAMIndexContent == null) {
            return null;
        }
        List<Chunk> list = new ArrayList<Chunk>();
        for (Chunk chunk : bAMIndexContent.getAllChunks()) {
            list.add(chunk.clone());
        }
        list = this.optimizeChunkList(list, bAMIndexContent.getLinearIndex().getMinimumOffset(n2));
        return new BAMFileSpan(list);
    }

    @Override
    protected BAMIndexContent getQueryResults(int n) {
        throw new UnsupportedOperationException();
    }
}

