/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.samtools.util.RuntimeEOFException;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class BinaryCodec {
    private OutputStream outputStream;
    private String outputFileName;
    private InputStream inputStream;
    private String inputFileName;
    private boolean isWriting;
    private ByteBuffer byteBuffer;
    private final byte[] scratchBuffer = new byte[16];
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    private static final byte[] NULL_BYTE = new byte[]{0};
    private static final long MAX_UBYTE = 255L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final int MAX_BYTE_BUFFER = 8;

    public BinaryCodec(File file, boolean bl) {
        this();
        try {
            this.isWriting = bl;
            if (this.isWriting) {
                this.outputStream = new FileOutputStream(file);
                this.outputFileName = file.getName();
            } else {
                this.inputStream = new FileInputStream(file);
                this.inputFileName = file.getName();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeIOException("File not found: " + file, fileNotFoundException);
        }
    }

    public BinaryCodec(String string2, boolean bl) {
        this(new File(string2), bl);
    }

    public BinaryCodec(OutputStream outputStream) {
        this();
        this.setOutputStream(outputStream);
    }

    public BinaryCodec(InputStream inputStream) {
        this();
        this.setInputStream(inputStream);
    }

    public BinaryCodec() {
        this.initByteBuffer();
    }

    private void initByteBuffer() {
        this.byteBuffer = ByteBuffer.allocate(8);
        this.byteBuffer.order(LITTLE_ENDIAN);
    }

    private void writeByteBuffer(int n) {
        assert (n <= this.byteBuffer.limit());
        this.writeBytes(this.byteBuffer.array(), 0, n);
    }

    public void writeByte(byte by2) {
        this.byteBuffer.clear();
        this.byteBuffer.put(by2);
        this.writeByteBuffer(1);
    }

    public void writeByte(int n) {
        this.writeByte((byte)n);
    }

    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        if (!this.isWriting) {
            throw new IllegalStateException("Calling write method on BinaryCodec open for read.");
        }
        try {
            this.outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(this.constructErrorMessage("Write error"), iOException);
        }
    }

    public void writeInt(int n) {
        this.byteBuffer.clear();
        this.byteBuffer.putInt(n);
        this.writeByteBuffer(4);
    }

    public void writeDouble(double d) {
        this.byteBuffer.clear();
        this.byteBuffer.putDouble(d);
        this.writeByteBuffer(8);
    }

    public void writeLong(long l) {
        this.byteBuffer.clear();
        this.byteBuffer.putLong(l);
        this.writeByteBuffer(8);
    }

    public void writeShort(short s2) {
        this.byteBuffer.clear();
        this.byteBuffer.putShort(s2);
        this.writeByteBuffer(2);
    }

    public void writeFloat(float f) {
        this.byteBuffer.clear();
        this.byteBuffer.putFloat(f);
        this.writeByteBuffer(4);
    }

    public void writeBoolean(boolean bl) {
        this.byteBuffer.clear();
        this.byteBuffer.put(bl ? (byte)1 : 0);
        this.writeByteBuffer(1);
    }

    public void writeString(String string2, boolean bl, boolean bl2) {
        if (bl) {
            int n = string2.length();
            if (bl2) {
                ++n;
            }
            this.writeInt(n);
        }
        this.writeString(string2);
        if (bl2) {
            this.writeBytes(NULL_BYTE);
        }
    }

    private void writeString(String string2) {
        this.writeBytes(StringUtil.stringToBytes(string2));
    }

    public void writeUByte(short s2) {
        if (s2 < 0) {
            throw new IllegalArgumentException("Negative value (" + s2 + ") passed to unsigned writing method.");
        }
        if ((long)s2 > 255L) {
            throw new IllegalArgumentException("Value (" + s2 + ") to large to be written as ubyte.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putShort(s2);
        this.writeByteBuffer(1);
    }

    public void writeUShort(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value (" + n + ") passed to unsigned writing method.");
        }
        if ((long)n > 65535L) {
            throw new IllegalArgumentException("Value (" + n + ") to large to be written as ushort.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putInt(n);
        this.writeByteBuffer(2);
    }

    public void writeUInt(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value (" + l + ") passed to unsigned writing method.");
        }
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value (" + l + ") to large to be written as uint.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putLong(l);
        this.writeByteBuffer(4);
    }

    public void readBytes(byte[] byArray) {
        this.readBytes(byArray, 0, byArray.length);
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.readBytesOrFewer(byArray, n + n4, n2 - n4)) >= 0) continue;
            String string2 = String.format("Premature EOF. Expected %d but only received %d", n2, n4);
            throw new RuntimeEOFException(this.constructErrorMessage(string2));
        } while ((n4 += n3) < n2);
    }

    public int readBytesOrFewer(byte[] byArray, int n, int n2) {
        if (this.isWriting) {
            throw new IllegalStateException("Calling read method on BinaryCodec open for write.");
        }
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(this.constructErrorMessage("Read error"), iOException);
        }
    }

    public byte readByte() {
        if (this.isWriting) {
            throw new IllegalStateException("Calling read method on BinaryCodec open for write.");
        }
        try {
            int n = this.inputStream.read();
            if (n == -1) {
                throw new RuntimeEOFException(this.constructErrorMessage("Premature EOF"));
            }
            return (byte)n;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(this.constructErrorMessage("Read error"), iOException);
        }
    }

    public boolean knownAtEof() {
        if (this.isWriting) {
            throw new IllegalStateException("Calling knownAtEof method on BinaryCodec open for write.");
        }
        try {
            return this.inputStream instanceof ByteArrayInputStream && this.inputStream.available() == 0;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(this.constructErrorMessage("available() error"), iOException);
        }
    }

    public String readString(int n) {
        byte[] byArray = n <= this.scratchBuffer.length ? this.scratchBuffer : new byte[n];
        this.readBytes(byArray, 0, n);
        return StringUtil.bytesToString(byArray, 0, n);
    }

    public String readNullTerminatedString() {
        return StringUtil.readNullTerminatedString(this);
    }

    public String readLengthAndString(boolean bl) {
        int n = this.readInt();
        if (bl) {
            --n;
        }
        String string2 = this.readString(n);
        if (bl) {
            this.readByte();
        }
        return string2;
    }

    private void readByteBuffer(int n) {
        assert (n <= this.byteBuffer.capacity());
        this.readBytes(this.byteBuffer.array(), 0, n);
        this.byteBuffer.limit(this.byteBuffer.capacity());
        this.byteBuffer.position(n);
    }

    public int readInt() {
        this.readByteBuffer(4);
        this.byteBuffer.flip();
        return this.byteBuffer.getInt();
    }

    public double readDouble() {
        this.readByteBuffer(8);
        this.byteBuffer.flip();
        return this.byteBuffer.getDouble();
    }

    public long readLong() {
        this.readByteBuffer(8);
        this.byteBuffer.flip();
        return this.byteBuffer.getLong();
    }

    public short readShort() {
        this.readByteBuffer(2);
        this.byteBuffer.flip();
        return this.byteBuffer.getShort();
    }

    public float readFloat() {
        this.readByteBuffer(4);
        this.byteBuffer.flip();
        return this.byteBuffer.getFloat();
    }

    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    public short readUByte() {
        this.readByteBuffer(1);
        this.byteBuffer.put((byte)0);
        this.byteBuffer.flip();
        return this.byteBuffer.getShort();
    }

    public int readUShort() {
        this.readByteBuffer(2);
        this.byteBuffer.putShort((short)0);
        this.byteBuffer.flip();
        return this.byteBuffer.getInt();
    }

    public long readUInt() {
        this.readByteBuffer(4);
        this.byteBuffer.putInt(0);
        this.byteBuffer.flip();
        return this.byteBuffer.getLong();
    }

    public void close() {
        block6: {
            try {
                if (this.isWriting) {
                    if (this.outputStream instanceof FileOutputStream) {
                        this.outputStream.flush();
                        FileOutputStream fileOutputStream = (FileOutputStream)this.outputStream;
                        try {
                            fileOutputStream.getFD().sync();
                        }
                        catch (SyncFailedException syncFailedException) {
                            // empty catch block
                        }
                    }
                    this.outputStream.close();
                    break block6;
                }
                this.inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException.getMessage(), iOException);
            }
        }
    }

    private String constructErrorMessage(String string2) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append("; BinaryCodec in ");
        stringBuilder.append(this.isWriting ? "write" : "read");
        stringBuilder.append("mode; ");
        String string4 = string3 = this.isWriting ? this.outputFileName : this.inputFileName;
        if (string3 != null) {
            stringBuilder.append("file: ");
            stringBuilder.append(string3);
        } else {
            stringBuilder.append("streamed file (filename not available)");
        }
        return stringBuilder.toString();
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String string2) {
        this.outputFileName = string2;
    }

    public void setInputFileName(String string2) {
        this.inputFileName = string2;
    }

    public boolean isWriting() {
        return this.isWriting;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.isWriting = false;
        this.inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.isWriting = true;
        this.outputStream = outputStream;
    }
}

