/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util.ftp;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sf.samtools.SAMException;
import net.sf.samtools.util.ftp.FTPReply;

public class FTPClient {
    private Socket commandSocket = null;
    public static int READ_TIMEOUT = 300000;
    private PrintStream commandStream = null;
    private BufferedReader responseReader = null;
    private InputStream dataStream;
    private String passiveHost;
    private int passivePort;
    long restPosition = -1L;
    String host;

    public FTPReply connect(String string2) throws IOException {
        this.host = string2;
        this.commandSocket = new Socket(string2, 21);
        this.commandSocket.setSoTimeout(READ_TIMEOUT);
        this.commandStream = new PrintStream(this.commandSocket.getOutputStream());
        this.responseReader = new BufferedReader(new InputStreamReader(this.commandSocket.getInputStream()));
        FTPReply fTPReply = new FTPReply(this.responseReader);
        if (!fTPReply.isPositiveCompletion()) {
            this.disconnect();
        }
        return fTPReply;
    }

    public FTPReply executeCommand(String string2) throws IOException {
        this.commandStream.println(string2);
        return new FTPReply(this.responseReader);
    }

    public FTPReply login(String string2, String string3) throws IOException {
        FTPReply fTPReply = this.executeCommand("user " + string2);
        if (!fTPReply.isPositiveIntermediate()) {
            return fTPReply;
        }
        fTPReply = this.executeCommand("pass " + string3);
        return fTPReply;
    }

    public FTPReply quit() throws IOException {
        return this.executeCommand("QUIT");
    }

    public FTPReply binary() throws IOException {
        return this.executeCommand("TYPE I");
    }

    public FTPReply pasv() throws IOException {
        Object object;
        FTPReply fTPReply = this.executeCommand("PASV");
        if (fTPReply.getCode() == 226 || fTPReply.getCode() == 426) {
            fTPReply = this.getReply();
        }
        String string2 = fTPReply.getReplyString();
        int n = fTPReply.getCode();
        int n2 = string2.indexOf(40);
        int n3 = string2.indexOf(41, n2 + 1);
        if (n3 > 0) {
            object = string2.substring(n2 + 1, n3);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            try {
                this.passiveHost = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
                this.passivePort = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("SimpleFTP received bad data link information: " + string2);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SimpleFTP received bad data link information: " + string2);
            }
        }
        if (fTPReply.isPositiveCompletion() && this.dataStream == null) {
            object = new Socket(this.passiveHost, this.passivePort);
            ((Socket)object).setSoTimeout(READ_TIMEOUT);
            this.dataStream = new SocketInputStream((Socket)object, ((Socket)object).getInputStream());
        }
        return fTPReply;
    }

    public void setRestPosition(long l) {
        this.restPosition = l;
    }

    public FTPReply retr(String string2) throws IOException {
        FTPReply fTPReply;
        if (this.restPosition >= 0L && !(fTPReply = this.executeCommand("REST " + this.restPosition)).isSuccess()) {
            return fTPReply;
        }
        return this.executeCommand("RETR " + string2);
    }

    public FTPReply getReply() throws IOException {
        return new FTPReply(this.responseReader);
    }

    public FTPReply size(String string2) throws IOException {
        return this.executeCommand("SIZE " + string2);
    }

    public InputStream getDataStream() throws IOException {
        return this.dataStream;
    }

    public void closeDataStream() throws IOException {
        this.dataStream.close();
        this.dataStream = null;
    }

    public void disconnect() {
        try {
            if (this.commandStream != null) {
                this.commandStream.close();
                this.responseReader.close();
                this.commandSocket.close();
                if (this.dataStream != null) {
                    this.dataStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new SAMException("Error disconnecting", iOException);
        }
        this.commandStream = null;
        this.responseReader = null;
        this.commandSocket = null;
    }

    class SocketInputStream
    extends FilterInputStream {
        Socket socket;

        SocketInputStream(Socket socket, InputStream inputStream) {
            super(inputStream);
            this.socket = socket;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.socket.close();
            FTPClient.this.dataStream = null;
        }
    }
}

