/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.util.StringUtils;

public class ProfileLogger
extends DefaultLogger {
    private Map profileData = new HashMap();

    public void targetStarted(BuildEvent event) {
        Date now2 = new Date();
        String name = "Target " + event.getTarget().getName();
        this.logStart(event, now2, name);
        this.profileData.put(event.getTarget(), now2);
    }

    public void targetFinished(BuildEvent event) {
        Date start = (Date)this.profileData.remove(event.getTarget());
        String name = "Target " + event.getTarget().getName();
        this.logFinish(event, start, name);
    }

    public void taskStarted(BuildEvent event) {
        String name = event.getTask().getTaskName();
        Date now2 = new Date();
        this.logStart(event, now2, name);
        this.profileData.put(event.getTask(), now2);
    }

    public void taskFinished(BuildEvent event) {
        Date start = (Date)this.profileData.remove(event.getTask());
        String name = event.getTask().getTaskName();
        this.logFinish(event, start, name);
    }

    private void logFinish(BuildEvent event, Date start, String name) {
        Date now2 = new Date();
        String msg = null;
        if (start != null) {
            long diff2 = now2.getTime() - start.getTime();
            msg = StringUtils.LINE_SEP + name + ": finished " + now2 + " (" + diff2 + "ms)";
        } else {
            msg = StringUtils.LINE_SEP + name + ": finished " + now2 + " (unknown duration, start not detected)";
        }
        this.printMessage(msg, this.out, event.getPriority());
        this.log(msg);
    }

    private void logStart(BuildEvent event, Date start, String name) {
        String msg = StringUtils.LINE_SEP + name + ": started " + start;
        this.printMessage(msg, this.out, event.getPriority());
        this.log(msg);
    }
}

