/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionWrapper;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.comparators.DelegatedResourceComparator;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import org.apache.tools.ant.util.CollectionUtils;

public class Sort
extends BaseResourceCollectionWrapper {
    private DelegatedResourceComparator comp = new DelegatedResourceComparator();

    protected synchronized Collection getCollection() {
        ResourceCollection rc = this.getResourceCollection();
        Iterator iter2 = rc.iterator();
        if (!iter2.hasNext()) {
            return Collections.EMPTY_SET;
        }
        List result2 = (List)CollectionUtils.asCollection(iter2);
        Collections.sort(result2, this.comp);
        return result2;
    }

    public synchronized void add(ResourceComparator c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.comp.add(c);
        FailFast.invalidate(this);
        this.setChecked(false);
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        super.dieOnCircularReference(stk, p);
        if (!this.isReference()) {
            DataType.pushAndInvokeCircularReferenceCheck(this.comp, stk, p);
            this.setChecked(true);
        }
    }
}

