/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.ReadableSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.WritableSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public abstract class BaseSelectorContainer
extends BaseSelector
implements SelectorContainer {
    private Vector selectorsList = new Vector();

    public boolean hasSelectors() {
        this.dieOnCircularReference();
        return !this.selectorsList.isEmpty();
    }

    public int selectorCount() {
        this.dieOnCircularReference();
        return this.selectorsList.size();
    }

    public FileSelector[] getSelectors(Project p) {
        this.dieOnCircularReference();
        Object[] result2 = new FileSelector[this.selectorsList.size()];
        this.selectorsList.copyInto(result2);
        return result2;
    }

    public Enumeration selectorElements() {
        this.dieOnCircularReference();
        return this.selectorsList.elements();
    }

    public String toString() {
        this.dieOnCircularReference();
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.selectorElements();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                buf.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public void appendSelector(FileSelector selector) {
        this.selectorsList.addElement(selector);
        this.setChecked(false);
    }

    public void validate() {
        this.verifySettings();
        this.dieOnCircularReference();
        String errmsg = this.getError();
        if (errmsg != null) {
            throw new BuildException(errmsg);
        }
        Enumeration e = this.selectorElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof BaseSelector)) continue;
            ((BaseSelector)o).validate();
        }
    }

    public abstract boolean isSelected(File var1, String var2, File var3);

    public void addSelector(SelectSelector selector) {
        this.appendSelector(selector);
    }

    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    public void addDate(DateSelector selector) {
        this.appendSelector(selector);
    }

    public void addSize(SizeSelector selector) {
        this.appendSelector(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepend(DependSelector selector) {
        this.appendSelector(selector);
    }

    public void addDifferent(DifferentSelector selector) {
        this.appendSelector(selector);
    }

    public void addType(TypeSelector selector) {
        this.appendSelector(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.appendSelector(selector);
    }

    public void addModified(ModifiedSelector selector) {
        this.appendSelector(selector);
    }

    public void addReadable(ReadableSelector r) {
        this.appendSelector(r);
    }

    public void addWritable(WritableSelector w) {
        this.appendSelector(w);
    }

    public void add(FileSelector selector) {
        this.appendSelector(selector);
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            Iterator i = this.selectorsList.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof DataType)) continue;
                BaseSelectorContainer.pushAndInvokeCircularReferenceCheck((DataType)o, stk, p);
            }
            this.setChecked(true);
        }
    }
}

