/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.util.MathUtils;

public class DynamicIndexCreator
implements IndexCreator {
    IndexFactory.IndexBalanceApproach iba;
    Map<IndexFactory.IndexType, IndexCreator> creators;
    int longestFeatureLength = 0;
    long featureCount = 0L;
    MathUtils.RunningStat stats = new MathUtils.RunningStat();
    long basesSeen = 0L;
    Feature lastFeature = null;
    File inputFile;

    public DynamicIndexCreator(IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        this.iba = indexBalanceApproach;
    }

    @Override
    public void initialize(File file, int n) {
        this.inputFile = file;
        this.creators = this.getIndexCreators(file, this.iba);
    }

    @Override
    public int defaultBinSize() {
        return -1;
    }

    @Override
    public int getBinSize() {
        return -1;
    }

    @Override
    public Index finalizeIndex(long l) {
        LinkedHashMap<Double, IndexCreator> linkedHashMap = DynamicIndexCreator.scoreIndexes((double)this.featureCount / (double)this.basesSeen, this.creators, this.longestFeatureLength, this.iba);
        IndexCreator indexCreator = this.getMinIndex(linkedHashMap, this.iba);
        Index index = indexCreator.finalizeIndex(l);
        index.finalizeIndex();
        index.addProperty("FEATURE_LENGTH_MEAN", String.valueOf(this.stats.mean()));
        index.addProperty("FEATURE_LENGTH_STD_DEV", String.valueOf(this.stats.standardDeviation()));
        index.addProperty("MEAN_FEATURE_VARIANCE", String.valueOf(this.stats.variance()));
        index.addProperty("FEATURE_COUNT", String.valueOf(this.featureCount));
        return index;
    }

    private Map<IndexFactory.IndexType, IndexCreator> getIndexCreators(File file, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        IntervalIndexCreator intervalIndexCreator;
        LinearIndexCreator linearIndexCreator;
        HashMap<IndexFactory.IndexType, IndexCreator> hashMap = new HashMap<IndexFactory.IndexType, IndexCreator>();
        if (indexBalanceApproach == IndexFactory.IndexBalanceApproach.FOR_SIZE) {
            linearIndexCreator = new LinearIndexCreator();
            linearIndexCreator.initialize(file, linearIndexCreator.defaultBinSize());
            hashMap.put(IndexFactory.IndexType.LINEAR, linearIndexCreator);
            intervalIndexCreator = new IntervalIndexCreator();
            intervalIndexCreator.initialize(file, intervalIndexCreator.defaultBinSize());
            hashMap.put(IndexFactory.IndexType.INTERVAL_TREE, intervalIndexCreator);
        }
        if (indexBalanceApproach == IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME) {
            linearIndexCreator = new LinearIndexCreator();
            linearIndexCreator.initialize(file, Math.max(200, linearIndexCreator.defaultBinSize() / 4));
            hashMap.put(IndexFactory.IndexType.LINEAR, linearIndexCreator);
            intervalIndexCreator = new IntervalIndexCreator();
            intervalIndexCreator.initialize(file, Math.max(20, intervalIndexCreator.defaultBinSize() / 8));
            hashMap.put(IndexFactory.IndexType.INTERVAL_TREE, intervalIndexCreator);
        }
        return hashMap;
    }

    @Override
    public void addFeature(Feature feature, long l) {
        ++this.featureCount;
        this.basesSeen = this.lastFeature == null ? this.basesSeen + (long)feature.getStart() : (feature.getStart() - this.lastFeature.getStart() >= 0 ? this.basesSeen + (long)(feature.getStart() - this.lastFeature.getStart()) : this.basesSeen + (long)feature.getStart());
        this.longestFeatureLength = Math.max(this.longestFeatureLength, feature.getEnd() - feature.getStart() + 1);
        this.stats.push(this.longestFeatureLength);
        for (IndexCreator indexCreator : this.creators.values()) {
            indexCreator.addFeature(feature, l);
        }
        this.lastFeature = feature;
    }

    protected static LinkedHashMap<Double, IndexCreator> scoreIndexes(double d, Map<IndexFactory.IndexType, IndexCreator> map2, int n, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        if (map2.size() < 1) {
            throw new IllegalArgumentException("Please specify at least one index to evaluate");
        }
        LinkedHashMap<Double, IndexCreator> linkedHashMap = new LinkedHashMap<Double, IndexCreator>();
        for (Map.Entry<IndexFactory.IndexType, IndexCreator> entry : map2.entrySet()) {
            if (entry.getValue() instanceof LinearIndexCreator) {
                double d2 = entry.getValue().getBinSize();
                linkedHashMap.put(d2 * d * Math.ceil((double)n / d2), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof IntervalIndexCreator) {
                linkedHashMap.put(Double.valueOf(entry.getValue().getBinSize()), entry.getValue());
                continue;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type, we don't have a scoring method for " + entry.getValue().getClass());
        }
        return linkedHashMap;
    }

    private IndexCreator getMinIndex(Map<Double, IndexCreator> map2, IndexFactory.IndexBalanceApproach indexBalanceApproach) {
        TreeMap<Double, IndexCreator> treeMap = new TreeMap<Double, IndexCreator>();
        treeMap.putAll(map2);
        IndexCreator indexCreator = indexBalanceApproach != IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME ? (IndexCreator)treeMap.get(treeMap.lastKey()) : (IndexCreator)treeMap.get(treeMap.firstKey());
        return indexCreator;
    }
}

