/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import gnu.trove.map.TObjectIntMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.QualityReportData;

public class QualityReportDataImpl
implements QualityReportData {
    private final int barcodeLength;
    private final Map<String, String> barcodeToConditionMap;
    private final TObjectIntMap<String> barcodeToReadCountMap;
    private final TObjectIntMap<String> sampleBarcodeToMatchingConstructReadCount;
    private final Map<String, Set<String>> truncatedConstructBarcodeToCollidingConstructIds;
    private final long numberOfReads;
    private final long numberOfMatchingReads;
    private final long numberOfSingleBaseMismatchReads;
    private final long numberOfSkippedShortReads;
    private final boolean findConstructBarcodesByPrefix;
    private final long numberOfReadsWithNoConstructBarcode;
    private final int maxConstructBarcodeIndex;
    private final int minConstructBarcodeIndex;
    private final Integer meanConstructBarcodeIndex;

    public QualityReportDataImpl(int n, Map<String, String> map2, TObjectIntMap<String> tObjectIntMap, TObjectIntMap<String> tObjectIntMap2, Map<String, Set<String>> map3, long l, long l2, long l3, long l4, boolean bl, long l5, int n2, int n3, Integer n4) {
        this.barcodeLength = n;
        this.barcodeToConditionMap = map2;
        this.barcodeToReadCountMap = tObjectIntMap;
        this.sampleBarcodeToMatchingConstructReadCount = tObjectIntMap2;
        this.truncatedConstructBarcodeToCollidingConstructIds = map3;
        this.numberOfReads = l;
        this.numberOfMatchingReads = l2;
        this.numberOfSingleBaseMismatchReads = l3;
        this.numberOfSkippedShortReads = l4;
        this.findConstructBarcodesByPrefix = bl;
        this.numberOfReadsWithNoConstructBarcode = l5;
        this.maxConstructBarcodeIndex = n2;
        this.minConstructBarcodeIndex = n3;
        this.meanConstructBarcodeIndex = n4;
    }

    @Override
    public int getBarcodeLength() {
        return this.barcodeLength;
    }

    @Override
    public Map<String, String> getBarcodeToConditionMap() {
        return this.barcodeToConditionMap;
    }

    @Override
    public Integer getReadCountForBarcode(String string2) {
        return this.barcodeToReadCountMap.get(string2);
    }

    @Override
    public Set<String> getBarcodesWithNonZeroReadCounts() {
        return new TreeSet<String>(this.barcodeToReadCountMap.keySet());
    }

    @Override
    public Integer getMatchingConstructReadCountForBarcode(String string2) {
        return this.sampleBarcodeToMatchingConstructReadCount.get(string2);
    }

    @Override
    public Map<String, Set<String>> getTruncatedConstructBarcodeToCollidingConstructIdsMap() {
        return this.truncatedConstructBarcodeToCollidingConstructIds;
    }

    @Override
    public long getNumberOfReads() {
        return this.numberOfReads;
    }

    @Override
    public long getNumberOfMatchingReads() {
        return this.numberOfMatchingReads;
    }

    @Override
    public long getNumberOfSingleBaseMismatchReads() {
        return this.numberOfSingleBaseMismatchReads;
    }

    @Override
    public long getNumberOfSkippedShortReads() {
        return this.numberOfSkippedShortReads;
    }

    @Override
    public boolean findConstructBarcodesByPrefix() {
        return this.findConstructBarcodesByPrefix;
    }

    @Override
    public long getNumberOfReadsWithNoConstructBarcode() {
        return this.numberOfReadsWithNoConstructBarcode;
    }

    @Override
    public int maxConstructBarcodeIndex() {
        return this.maxConstructBarcodeIndex;
    }

    @Override
    public int minConstructBarcodeIndex() {
        return this.minConstructBarcodeIndex;
    }

    @Override
    public Integer meanConstructBarcodeIndex() {
        return this.meanConstructBarcodeIndex;
    }
}

