/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import org.broadinstitute.rnai.poolq.impl.EventTracker;

public class InMemoryEventTracker
implements EventTracker {
    private long readsProcessed = 0L;
    private long skippedShortReads = 0L;
    private long sampleBarcodesWithN = 0L;
    private long readsWithMatchingConstructBarcode = 0L;
    private long readsWithMatchingConstructBarcodeWithMismatch = 0L;
    private long sumOfConstructBarcodeIndexes = 0L;
    private int minConstructBarcodeIndex = Integer.MAX_VALUE;
    private int maxConstructBarcodeIndex = Integer.MIN_VALUE;
    private long readsWithNoBarcodeSearchPrefix = 0L;
    private long readsWithBarcodeSearchPrefixPastSearchRegion = 0L;

    @Override
    public EventTracker processedRead() {
        ++this.readsProcessed;
        return this;
    }

    @Override
    public long readsProcessed() {
        return this.readsProcessed;
    }

    @Override
    public EventTracker skippedShortRead() {
        ++this.skippedShortReads;
        return this;
    }

    @Override
    public long skippedShortReads() {
        return this.skippedShortReads;
    }

    @Override
    public EventTracker sampleBarcodeHasN() {
        ++this.sampleBarcodesWithN;
        return this;
    }

    @Override
    public long sampleBarcodesWithN() {
        return this.sampleBarcodesWithN;
    }

    @Override
    public EventTracker readMatchedConstructBarcode() {
        ++this.readsWithMatchingConstructBarcode;
        return this;
    }

    @Override
    public long readsWithMatchingConstructBarcode() {
        return this.readsWithMatchingConstructBarcode;
    }

    @Override
    public EventTracker readMatchedConstructBarcodeWithMismatch() {
        ++this.readsWithMatchingConstructBarcodeWithMismatch;
        return this;
    }

    @Override
    public long readsWithMatchingConstructBarcodeWithMismatch() {
        return this.readsWithMatchingConstructBarcodeWithMismatch;
    }

    @Override
    public EventTracker constructBarcodeIndex(int n) {
        this.sumOfConstructBarcodeIndexes += (long)n;
        this.minConstructBarcodeIndex = Math.min(this.minConstructBarcodeIndex, n);
        this.maxConstructBarcodeIndex = Math.max(this.maxConstructBarcodeIndex, n);
        return this;
    }

    @Override
    public int minConstructBarcodeIndex() {
        return this.minConstructBarcodeIndex;
    }

    @Override
    public int maxConstructBarcodeIndex() {
        return this.maxConstructBarcodeIndex;
    }

    @Override
    public Integer meanConstructBarcodeIndex() {
        if (this.readsProcessed == 0L) {
            return null;
        }
        return (int)Math.round((double)this.sumOfConstructBarcodeIndexes / (double)this.readsProcessed);
    }

    @Override
    public EventTracker barcodeSearchPrefixNotFound() {
        ++this.readsWithNoBarcodeSearchPrefix;
        return this;
    }

    @Override
    public long readsWithNoBarcodeSearchPrefix() {
        return this.readsWithNoBarcodeSearchPrefix;
    }

    @Override
    public EventTracker barcodeSearchPrefixPastSearchRegion() {
        ++this.readsWithBarcodeSearchPrefixPastSearchRegion;
        return this;
    }

    @Override
    public long readsWithBarcodeSearchPrefixPastSearchRegion() {
        return this.readsWithBarcodeSearchPrefixPastSearchRegion;
    }
}

