/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CommonInfo {
    public static final double NO_LOG10_PERROR = 1.0;
    private static Set<String> NO_FILTERS = Collections.emptySet();
    private static Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    private double log10PError = 1.0;
    private String name = null;
    private Set<String> filters = null;
    private Map<String, Object> attributes = NO_ATTRIBUTES;

    public CommonInfo(String string2, double d, Set<String> set, Map<String, Object> map2) {
        this.name = string2;
        this.setLog10PError(d);
        this.filters = set;
        if (map2 != null && !map2.isEmpty()) {
            this.attributes = map2;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Name cannot be null " + this);
        }
        this.name = string2;
    }

    public Set<String> getFiltersMaybeNull() {
        return this.filters;
    }

    public Set<String> getFilters() {
        return this.filters == null ? NO_FILTERS : Collections.unmodifiableSet(this.filters);
    }

    public boolean filtersWereApplied() {
        return this.filters != null;
    }

    public boolean isFiltered() {
        return this.filters == null ? false : this.filters.size() > 0;
    }

    public boolean isNotFiltered() {
        return !this.isFiltered();
    }

    public void addFilter(String string2) {
        if (this.filters == null) {
            this.filters = new HashSet<String>();
        }
        if (string2 == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filter " + this);
        }
        if (this.getFilters().contains(string2)) {
            throw new IllegalArgumentException("BUG: Attempting to add duplicate filter " + string2 + " at " + this);
        }
        this.filters.add(string2);
    }

    public void addFilters(Collection<String> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filters at" + this);
        }
        for (String string2 : collection) {
            this.addFilter(string2);
        }
    }

    public boolean hasLog10PError() {
        return this.getLog10PError() != 1.0;
    }

    public double getLog10PError() {
        return this.log10PError;
    }

    public double getPhredScaledQual() {
        return this.getLog10PError() * -10.0;
    }

    public void setLog10PError(double d) {
        if (d > 0.0 && d != 1.0) {
            throw new IllegalArgumentException("BUG: log10PError cannot be > 0 : " + this.log10PError);
        }
        if (Double.isInfinite(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be Infinity");
        }
        if (Double.isNaN(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be NaN");
        }
        this.log10PError = d;
    }

    public void clearAttributes() {
        this.attributes = new HashMap<String, Object>();
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, ?> map2) {
        this.clearAttributes();
        this.putAttributes(map2);
    }

    public void putAttribute(String string2, Object object) {
        this.putAttribute(string2, object, false);
    }

    public void putAttribute(String string2, Object object, boolean bl) {
        if (!bl && this.hasAttribute(string2)) {
            throw new IllegalStateException("Attempting to overwrite key->value binding: key = " + string2 + " this = " + this);
        }
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string2, object);
    }

    public void removeAttribute(String string2) {
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.remove(string2);
    }

    public void putAttributes(Map<String, ?> map2) {
        if (map2 != null) {
            if (this.attributes.size() == 0) {
                if (this.attributes == NO_ATTRIBUTES) {
                    this.attributes = new HashMap<String, Object>();
                }
                this.attributes.putAll(map2);
            } else {
                for (Map.Entry<String, ?> entry : map2.entrySet()) {
                    this.putAttribute(entry.getKey(), entry.getValue(), false);
                }
            }
        }
    }

    public boolean hasAttribute(String string2) {
        return this.attributes.containsKey(string2);
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public Object getAttribute(String string2) {
        return this.attributes.get(string2);
    }

    public Object getAttribute(String string2, Object object) {
        if (this.hasAttribute(string2)) {
            return this.attributes.get(string2);
        }
        return object;
    }

    public String getAttributeAsString(String string2, String string3) {
        Object object = this.getAttribute(string2);
        if (object == null) {
            return string3;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public int getAttributeAsInt(String string2, int n) {
        Object object = this.getAttribute(string2);
        if (object == null || object == ".") {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.valueOf((String)object);
    }

    public double getAttributeAsDouble(String string2, double d) {
        Object object = this.getAttribute(string2);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return Double.valueOf((String)object);
    }

    public boolean getAttributeAsBoolean(String string2, boolean bl) {
        Object object = this.getAttribute(string2);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf((String)object);
    }
}

