/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.writer.BCF2Writer;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.SortingVariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VCFWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;

public class VariantContextWriterFactory {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);

    private VariantContextWriterFactory() {
    }

    public static VariantContextWriter create(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return VariantContextWriterFactory.create(file, VariantContextWriterFactory.openOutputStream(file), sAMSequenceDictionary, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(File file, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.create(file, VariantContextWriterFactory.openOutputStream(file), sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter create(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary) {
        return VariantContextWriterFactory.create(file, outputStream, sAMSequenceDictionary, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        return VariantContextWriterFactory.create(null, outputStream, sAMSequenceDictionary, enumSet);
    }

    public static VariantContextWriter create(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, EnumSet<Options> enumSet) {
        boolean bl = VariantContextWriterFactory.isBCFOutput(file, enumSet);
        if (bl) {
            return new BCF2Writer(file, outputStream, sAMSequenceDictionary, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
        }
        return new VCFWriter(file, outputStream, sAMSequenceDictionary, enumSet.contains((Object)Options.INDEX_ON_THE_FLY), enumSet.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), enumSet.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER));
    }

    public static boolean isBCFOutput(File file) {
        return VariantContextWriterFactory.isBCFOutput(file, EnumSet.noneOf(Options.class));
    }

    public static boolean isBCFOutput(File file, EnumSet<Options> enumSet) {
        return enumSet.contains((Object)Options.FORCE_BCF) || file != null && file.getName().contains(".bcf");
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter variantContextWriter, int n) {
        return VariantContextWriterFactory.sortOnTheFly(variantContextWriter, n, false);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter variantContextWriter, int n, boolean bl) {
        return new SortingVariantContextWriter(variantContextWriter, n, bl);
    }

    protected static OutputStream openOutputStream(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(file + ": Unable to create VCF writer", fileNotFoundException);
        }
    }
}

