/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.TargetMetrics;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.MultilevelMetrics;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.metrics.SAMRecordMultiLevelCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public abstract class TargetMetricsCollector<METRIC_TYPE extends MultilevelMetrics>
extends SAMRecordMultiLevelCollector<METRIC_TYPE, Integer> {
    private static final int NEAR_PROBE_DISTANCE = 250;
    private final File perTargetCoverage;
    private final File probeIntervals;
    private final String probeSetName;
    private static final Log log = Log.getInstance(TargetMetricsCollector.class);
    private final IntervalList allProbes;
    private final IntervalList allTargets;
    private final OverlapDetector<Interval> targetDetector;
    private final OverlapDetector<Interval> probeDetector;
    private Map<Interval, Double> intervalToGc = null;
    private final long probeTerritory;
    private final long targetTerritory;
    private final long genomeSize;
    private Map<Interval, Coverage> coverageByTargetForRead;
    private Coverage[] cov;

    public abstract METRIC_TYPE convertMetric(TargetMetrics var1);

    protected static <MT extends MetricBase> void reflectiveCopy(TargetMetrics targetMetrics, MT MT, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            if (stringArray2 != null) {
                throw new PicardException("Target keys is null but output keys == " + StringUtil.join(",", stringArray2));
            }
            if (stringArray != null) {
                throw new PicardException("Output keys is null but target keys == " + StringUtil.join(",", stringArray));
            }
        } else if (stringArray.length != stringArray2.length) {
            throw new PicardException("Target keys and output keys do not have the same length: targetKeys == (" + StringUtil.join(",", stringArray) + ") " + "outputKeys == (" + StringUtil.join(",", stringArray2) + ")");
        }
        Class<?> clazz = MT.getClass();
        Set<Field> set = CollectionUtil.makeSet(TargetMetrics.class.getFields());
        for (String string2 : stringArray) {
            if (!set.contains(string2)) continue;
            set.remove(string2);
        }
        HashSet hashSet = new HashSet();
        for (Field field2 : MT.getClass().getFields()) {
            hashSet.add(field2.getName());
        }
        for (Field field3 : set) {
            if (!hashSet.contains(field3.getName())) continue;
            try {
                Field field4 = clazz.getField(field3.getName());
                field4.set(MT, field3.get(targetMetrics));
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying targetMetrics to " + MT.getClass().getName(), exception);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Field field5 = TargetMetrics.class.getField(stringArray[i]);
                Field field6 = clazz.getField(stringArray2[i]);
                field6.set(MT, field5.get(targetMetrics));
                continue;
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying TargetMetrics." + stringArray[i] + " to " + clazz.getName() + "." + stringArray2[i], exception);
            }
        }
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, File file2, File file3, String string2) {
        Object object;
        int n;
        this.perTargetCoverage = file;
        this.probeIntervals = file3;
        this.probeSetName = string2 == null ? ((n = ((String)(object = file3.getName())).indexOf(".")) > 0 ? ((String)object).substring(0, n) : null) : string2;
        this.allProbes = IntervalList.fromFile(file3);
        this.allTargets = IntervalList.fromFile(file2);
        object = this.allProbes.getUniqueIntervals();
        this.probeDetector = new OverlapDetector(-250, 0);
        this.probeDetector.addAll((List<Interval>)object, (List<Interval>)object);
        this.probeTerritory = Interval.countBases((Collection<Interval>)object);
        List<Interval> list2 = this.allTargets.getUniqueIntervals();
        this.targetDetector = new OverlapDetector(0, 0);
        this.targetDetector.addAll(list2, list2);
        this.targetTerritory = Interval.countBases(list2);
        int n2 = 0;
        this.cov = new Coverage[list2.size()];
        this.coverageByTargetForRead = new LinkedHashMap<Interval, Coverage>(list2.size() * 2, 0.5f);
        for (Interval interval : list2) {
            Iterator<Interval> iterator2 = new Coverage(interval, 0);
            this.coverageByTargetForRead.put(interval, (Coverage)((Object)iterator2));
            this.cov[n2++] = iterator2;
        }
        long l = 0L;
        for (SAMSequenceRecord cloneable : this.allProbes.getHeader().getSequenceDictionary().getSequences()) {
            l += (long)cloneable.getSequenceLength();
        }
        this.genomeSize = l;
        if (referenceSequenceFile != null) {
            this.intervalToGc = new HashMap<Interval, Double>();
            for (Interval interval : list2) {
                ReferenceSequence referenceSequence = referenceSequenceFile.getSubsequenceAt(interval.getSequence(), interval.getStart(), interval.getEnd());
                this.intervalToGc.put(interval, SequenceUtil.calculateGc(referenceSequence.getBases()));
            }
        }
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeChildCollector(String string2, String string3, String string4) {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = new PerUnitTargetMetricCollector(this.probeIntervals.getName(), this.coverageByTargetForRead.keySet(), string2, string3, string4, this.probeTerritory, this.targetTerritory, this.genomeSize, this.intervalToGc);
        if (this.probeSetName != null) {
            perUnitTargetMetricCollector.setBaitSetName(this.probeSetName);
        }
        return perUnitTargetMetricCollector;
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeAllReadCollector() {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = (PerUnitTargetMetricCollector)this.makeChildCollector(null, null, null);
        if (this.perTargetCoverage != null) {
            perUnitTargetMetricCollector.setPerTargetOutput(this.perTargetCoverage);
        }
        return perUnitTargetMetricCollector;
    }

    public static class Coverage {
        private final Interval interval;
        private final short[] depths;

        public Coverage(Interval interval, int n) {
            this.interval = interval;
            this.depths = new short[this.interval.length() + 2 * n];
        }

        public void addBase(int n) {
            if (n >= 0 && n < this.depths.length && this.depths[n] < Short.MAX_VALUE) {
                int n2 = n;
                this.depths[n2] = (short)(this.depths[n2] + 1);
            }
        }

        public boolean hasCoverage() {
            for (short s2 : this.depths) {
                if (s2 <= 1) continue;
                return true;
            }
            return false;
        }

        public short[] getDepths() {
            return this.depths;
        }

        public int getTotal() {
            int n = 0;
            for (int i = 0; i < this.depths.length; ++i) {
                n += this.depths[i];
            }
            return n;
        }

        public String toString() {
            return "TargetedMetricCollector(interval=" + this.interval + ", depths = [" + StringUtil.intValuesToString(this.depths) + "])";
        }
    }

    public class PerUnitTargetMetricCollector
    implements PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> {
        private final Map<Interval, Double> intervalToGc;
        private File perTargetOutput;
        private final Map<Interval, Coverage> coverageByTarget;
        private final TargetMetrics metrics = new TargetMetrics();

        public PerUnitTargetMetricCollector(String string2, Set<Interval> set, String string3, String string4, String string5, long l, long l2, long l3, Map<Interval, Double> map2) {
            this.metrics.SAMPLE = string3;
            this.metrics.LIBRARY = string4;
            this.metrics.READ_GROUP = string5;
            this.metrics.PROBE_SET = string2;
            this.metrics.PROBE_TERRITORY = l;
            this.metrics.TARGET_TERRITORY = l2;
            this.metrics.GENOME_SIZE = l3;
            this.coverageByTarget = new LinkedHashMap<Interval, Coverage>(set.size() * 2, 0.5f);
            for (Interval interval : set) {
                this.coverageByTarget.put(interval, new Coverage(interval, 0));
            }
            this.intervalToGc = map2;
        }

        public void setPerTargetOutput(File file) {
            this.perTargetOutput = file;
        }

        public void setBaitSetName(String string2) {
            this.metrics.PROBE_SET = string2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void acceptRecord(SAMRecord sAMRecord) {
            void var5_10;
            int n;
            boolean bl;
            Collection collection;
            Collection collection2;
            if (sAMRecord.isSecondaryOrSupplementary()) {
                return;
            }
            ++this.metrics.TOTAL_READS;
            if (sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!sAMRecord.getReadUnmappedFlag()) {
                Interval interval = new Interval(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart(), sAMRecord.getAlignmentEnd());
                collection2 = TargetMetricsCollector.this.targetDetector.getOverlaps(interval);
                collection = TargetMetricsCollector.this.probeDetector.getOverlaps(interval);
            } else {
                collection2 = null;
                collection = null;
            }
            ++this.metrics.PF_READS;
            this.metrics.PF_BASES += (long)sAMRecord.getReadLength();
            if (sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag() && collection != null && !collection.isEmpty()) {
                ++this.metrics.PF_SELECTED_PAIRS;
                if (!sAMRecord.getDuplicateReadFlag()) {
                    ++this.metrics.PF_SELECTED_UNIQUE_PAIRS;
                }
            }
            if (sAMRecord.getDuplicateReadFlag()) {
                return;
            }
            ++this.metrics.PF_UNIQUE_READS;
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getMappingQuality() == 0) {
                return;
            }
            ++this.metrics.PF_UQ_READS_ALIGNED;
            for (AlignmentBlock object : sAMRecord.getAlignmentBlocks()) {
                this.metrics.PF_UQ_BASES_ALIGNED += (long)object.getLength();
            }
            boolean bl2 = bl = sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag();
            if (collection2 != null && !collection2.isEmpty()) {
                for (Object object : collection2) {
                    Coverage coverage = this.coverageByTarget.get(object);
                    for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                        int n2 = CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength());
                        for (n = alignmentBlock.getReferenceStart(); n <= n2; ++n) {
                            if (n < ((Interval)object).getStart() || n > ((Interval)object).getEnd()) continue;
                            ++this.metrics.ON_TARGET_BASES;
                            if (bl) {
                                ++this.metrics.ON_TARGET_FROM_PAIR_BASES;
                            }
                            coverage.addBase(n - ((Interval)object).getStart());
                        }
                    }
                }
            }
            boolean bl3 = false;
            for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                var5_10 += alignmentBlock.getLength();
            }
            int n3 = 0;
            if (collection != null && !collection.isEmpty()) {
                for (Object object : collection) {
                    for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                        n = CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength());
                        for (int i = alignmentBlock.getReferenceStart(); i <= n; ++i) {
                            if (i < ((Interval)object).getStart() || i > ((Interval)object).getEnd()) continue;
                            ++n3;
                        }
                    }
                }
                this.metrics.ON_PROBE_BASES += (long)n3;
                this.metrics.NEAR_PROBE_BASES += (long)(var5_10 - n3);
            } else {
                this.metrics.OFF_PROBE_BASES += (long)var5_10;
            }
        }

        @Override
        public void finish() {
            this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS = (double)this.metrics.PF_UNIQUE_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS_ALIGNED = (double)this.metrics.PF_UQ_READS_ALIGNED / (double)this.metrics.PF_UNIQUE_READS;
            double d = this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES + this.metrics.OFF_PROBE_BASES;
            this.metrics.PCT_SELECTED_BASES = (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES) / d;
            this.metrics.PCT_OFF_PROBE = (double)this.metrics.OFF_PROBE_BASES / d;
            this.metrics.ON_PROBE_VS_SELECTED = (double)this.metrics.ON_PROBE_BASES / (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES);
            this.metrics.MEAN_PROBE_COVERAGE = (double)this.metrics.ON_PROBE_BASES / (double)this.metrics.PROBE_TERRITORY;
            this.metrics.FOLD_ENRICHMENT = (double)this.metrics.ON_PROBE_BASES / d / ((double)this.metrics.PROBE_TERRITORY / (double)this.metrics.GENOME_SIZE);
            this.calculateTargetCoverageMetrics();
            this.calculateGcMetrics();
        }

        /*
         * WARNING - void declaration
         */
        private void calculateTargetCoverageMetrics() {
            void var13_18;
            short[] sArray = new short[(int)this.metrics.TARGET_TERRITORY];
            int n2 = 0;
            int n3 = 0;
            double d = 0.0;
            int n4 = 0;
            for (Coverage coverage : this.coverageByTarget.values()) {
                if (!coverage.hasCoverage()) {
                    ++n2;
                    continue;
                }
                short[] sArray2 = coverage.getDepths();
                n4 += sArray2.length;
                for (short n5 : sArray2) {
                    sArray[n3++] = n5;
                    d += (double)n5;
                }
            }
            this.metrics.MEAN_TARGET_COVERAGE = d / (double)n4;
            Arrays.sort(sArray);
            int n6 = sArray.length - 1 - n4 + (int)((double)n4 * 0.2);
            short s2 = sArray[n6];
            this.metrics.FOLD_80_BASE_PENALTY = this.metrics.MEAN_TARGET_COVERAGE / (double)s2;
            this.metrics.ZERO_CVG_TARGETS_PCT = (double)n2 / (double)TargetMetricsCollector.this.allTargets.getIntervals().size();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            boolean bl = false;
            int n = 0;
            int n5 = 0;
            int n11 = 0;
            for (Coverage coverage : this.coverageByTarget.values()) {
                for (short s3 : coverage.getDepths()) {
                    ++n7;
                    if (s3 < 2) continue;
                    ++n8;
                    if (s3 < 10) continue;
                    ++n9;
                    if (s3 < 20) continue;
                    ++n10;
                    if (s3 < 30) continue;
                    ++var13_18;
                    if (s3 < 40) continue;
                    ++n;
                    if (s3 < 50) continue;
                    ++n5;
                    if (s3 < 100) continue;
                    ++n11;
                }
            }
            this.metrics.PCT_TARGET_BASES_2X = (double)n8 / (double)n7;
            this.metrics.PCT_TARGET_BASES_10X = (double)n9 / (double)n7;
            this.metrics.PCT_TARGET_BASES_20X = (double)n10 / (double)n7;
            this.metrics.PCT_TARGET_BASES_30X = (double)var13_18 / (double)n7;
            this.metrics.PCT_TARGET_BASES_40X = (double)n / (double)n7;
            this.metrics.PCT_TARGET_BASES_50X = (double)n5 / (double)n7;
            this.metrics.PCT_TARGET_BASES_100X = (double)n11 / (double)n7;
        }

        private void calculateGcMetrics() {
            if (this.intervalToGc != null) {
                int n;
                double d;
                PrintWriter printWriter;
                log.info("Calculating GC metrics");
                FormatUtil formatUtil = new FormatUtil();
                try {
                    if (this.perTargetOutput != null) {
                        printWriter = new PrintWriter(this.perTargetOutput);
                        printWriter.println("chrom\tstart\tend\tlength\tname\t%gc\tmean_coverage\tnormalized_coverage");
                    } else {
                        printWriter = null;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException);
                }
                long[] lArray = new long[101];
                long[] lArray2 = new long[101];
                for (Map.Entry<Interval, Coverage> entry : this.coverageByTarget.entrySet()) {
                    int n2;
                    Interval interval = entry.getKey();
                    Coverage coverage = entry.getValue();
                    double d2 = this.intervalToGc.get(interval);
                    int n3 = n2 = (int)Math.round(d2 * 100.0);
                    lArray[n3] = lArray[n3] + (long)interval.length();
                    int n4 = n2;
                    lArray2[n4] = lArray2[n4] + (long)coverage.getTotal();
                    if (printWriter == null) continue;
                    d = (double)coverage.getTotal() / (double)interval.length();
                    printWriter.println(interval.getSequence() + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\t" + interval.length() + "\t" + interval.getName() + "\t" + formatUtil.format(d2) + "\t" + formatUtil.format(d) + "\t" + formatUtil.format(d / this.metrics.MEAN_TARGET_COVERAGE));
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                long l = 0L;
                long l2 = 0L;
                for (n = 0; n < lArray.length; ++n) {
                    l += lArray[n];
                    l2 += lArray2[n];
                }
                for (n = 0; n < lArray.length; ++n) {
                    d = (double)lArray2[n] / (double)l2;
                    double d3 = (double)lArray[n] / (double)l;
                    double d4 = (d - d3) * 100.0;
                    if (!(d4 < 0.0)) continue;
                    d4 = Math.abs(d4);
                    if (n <= 50) {
                        this.metrics.AT_DROPOUT += d4;
                    }
                    if (n < 50) continue;
                    this.metrics.GC_DROPOUT += d4;
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<METRIC_TYPE, Integer> metricsFile) {
            metricsFile.addMetric(TargetMetricsCollector.this.convertMetric(this.metrics));
        }
    }
}

