/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.util.UnsignedTypeUtil;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.StringUtil;

class ClusterIntensityFileReader {
    private static final byte[] IDENTIFIER = StringUtil.stringToBytes("CIF");
    private static final byte FILE_VERSION = 1;
    private static final int HEADER_SIZE = 13;
    private static final int NUM_CHANNELS = IntensityChannel.values().length;
    private final File file;
    private final MappedByteBuffer buf;
    private final ClusterIntensityFileHeader header;
    private final int cycleSize;
    private final int channelSize;

    public ClusterIntensityFileReader(File file) {
        try {
            this.file = file;
            FileInputStream fileInputStream = new FileInputStream(this.file);
            FileChannel fileChannel = fileInputStream.getChannel();
            long l = fileChannel.size();
            this.buf = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
            this.buf.order(ByteOrder.LITTLE_ENDIAN);
            CloserUtil.close(fileChannel);
            CloserUtil.close(fileInputStream);
            byte[] byArray = new byte[13];
            this.buf.get(byArray);
            this.header = new ClusterIntensityFileHeader(byArray, this.file);
        }
        catch (IOException iOException) {
            throw new PicardException("IOException opening cluster intensity file " + file, iOException);
        }
        this.cycleSize = NUM_CHANNELS * this.header.numClusters * this.header.elementSize;
        this.channelSize = this.header.numClusters * this.header.elementSize;
    }

    public short getValue(int n, IntensityChannel intensityChannel, int n2) {
        if (n2 < this.header.firstCycle || n2 >= this.header.firstCycle + this.header.numCycles) {
            throw new IllegalArgumentException("Requested cycle (" + n2 + ") number out of range.  First cycle=" + this.header.firstCycle + "; numCycles=" + this.header.numCycles);
        }
        if (n < 0 || n >= this.header.numClusters) {
            throw new IllegalArgumentException("Requested cluster (" + n + ") number out of range. numClusters=" + this.header.numClusters);
        }
        int n3 = n2 - this.header.firstCycle;
        int n4 = 13 + n3 * this.cycleSize + intensityChannel.ordinal() * this.channelSize + n * this.header.elementSize;
        this.buf.position(n4);
        if (this.header.elementSize == 1) {
            return this.buf.get();
        }
        return this.buf.getShort();
    }

    public File getFile() {
        return this.file;
    }

    public int getFirstCycle() {
        return this.header.firstCycle;
    }

    public int getNumClusters() {
        return this.header.numClusters;
    }

    public int getNumCycles() {
        return this.header.numCycles;
    }

    public int getElementSize() {
        return this.header.elementSize;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClusterIntensityFileHeader readHeaders(File file) {
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[13];
        int n = 0;
        try {
            fileInputStream = new FileInputStream(file);
            n = fileInputStream.read(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new PicardException("Error opening intensity file (" + file.getAbsolutePath() + ")", fileNotFoundException);
                catch (IOException iOException) {
                    throw new PicardException("Error reading values from header for intensity file (" + file.getAbsolutePath() + ")", iOException);
                }
            }
            catch (Throwable throwable) {
                CloserUtil.close(fileInputStream);
                throw throwable;
            }
        }
        CloserUtil.close(fileInputStream);
        if (n == 13) {
            return new ClusterIntensityFileHeader(byArray, file);
        }
        throw new PicardException("Error reading intensity file header, too few bytes read, expected( 13) read(" + n + ")");
    }

    public static class ClusterIntensityFileHeader {
        public final int elementSize;
        public final int firstCycle;
        public final int numCycles;
        public final int numClusters;

        public ClusterIntensityFileHeader(byte[] byArray, File file) {
            if (byArray.length < 13) {
                throw new PicardException("Bytes past to header constructor are too short excpected(13) received (" + byArray.length);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(byArray);
            byteBuffer.position(0);
            byte[] byArray2 = new byte[IDENTIFIER.length];
            byteBuffer.get(byArray2);
            if (!Arrays.equals(byArray2, IDENTIFIER)) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected header: " + StringUtil.bytesToString(byArray2));
            }
            byte by2 = byteBuffer.get();
            if (by2 != 1) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected version: " + by2);
            }
            this.elementSize = byteBuffer.get();
            if (this.elementSize < 1 || this.elementSize > 2) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected element size: " + this.elementSize);
            }
            this.firstCycle = UnsignedTypeUtil.uShortToInt(byteBuffer.getShort());
            this.numCycles = UnsignedTypeUtil.uShortToInt(byteBuffer.getShort());
            if (this.numCycles == 0) {
                throw new PicardException("Cluster intensity file " + file + " has zero cycles.");
            }
            this.numClusters = byteBuffer.getInt();
            if (this.numClusters < 0) {
                throw new PicardException("Cluster intensity file " + file + " has negative number of clusters: " + this.numClusters);
            }
        }
    }
}

