/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public class ClippingUtility {
    public static final int MIN_MATCH_BASES = 12;
    public static final int MIN_MATCH_PE_BASES = 6;
    public static final double MAX_ERROR_RATE = 0.1;
    public static final double MAX_PE_ERROR_RATE = 0.1;
    public static final int NO_MATCH = -1;
    private static final Log log = Log.getInstance(ClippingUtility.class);

    public static void adapterTrimIlluminaSingleRead(SAMRecord sAMRecord, AdapterPair adapterPair) {
        ClippingUtility.adapterTrimIlluminaSingleRead(sAMRecord, 12, 0.1, adapterPair);
    }

    public static void adapterTrimIlluminaSingleRead(SAMRecord sAMRecord, AdapterPair adapterPair, int n, double d) {
        ClippingUtility.adapterTrimIlluminaSingleRead(sAMRecord, n, d, adapterPair);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord sAMRecord, AdapterPair ... adapterPairArray) {
        return ClippingUtility.adapterTrimIlluminaSingleRead(sAMRecord, 12, 0.1, adapterPairArray);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord sAMRecord, int n, double d, AdapterPair ... adapterPairArray) {
        for (AdapterPair adapterPair : adapterPairArray) {
            int n2 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(sAMRecord), adapterPair.get3PrimeAdapterBytes(), n, d);
            if (n2 == -1) continue;
            sAMRecord.setAttribute("XT", (Object)(n2 + 1));
            return adapterPair;
        }
        return null;
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2, AdapterPair adapterPair) {
        ClippingUtility.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2, 6, 0.1, adapterPair);
        return null;
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2, AdapterPair adapterPair, int n, double d) {
        ClippingUtility.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2, n, d, adapterPair);
        return null;
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2, AdapterPair ... adapterPairArray) {
        return ClippingUtility.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2, 6, 0.1, adapterPairArray);
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2, int n, double d, AdapterPair ... adapterPairArray) {
        AdapterPair adapterPair = null;
        for (AdapterPair adapterPair2 : adapterPairArray) {
            int n2;
            int n3 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(sAMRecord), adapterPair2.get3PrimeAdapterBytes(), n, d);
            if (n3 == (n2 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(sAMRecord2), adapterPair2.get5PrimeAdapterBytesInReadOrder(), n, d))) {
                if (n3 == -1) continue;
                sAMRecord.setAttribute("XT", (Object)(n3 + 1));
                sAMRecord2.setAttribute("XT", (Object)(n2 + 1));
                return adapterPair2;
            }
            if (n3 != -1 && n2 != -1 || !ClippingUtility.attemptOneSidedMatch(sAMRecord, sAMRecord2, n3, n2, 2 * n)) continue;
            adapterPair = adapterPair2;
        }
        return adapterPair;
    }

    private static boolean attemptOneSidedMatch(SAMRecord sAMRecord, SAMRecord sAMRecord2, int n, int n2, int n3) {
        SAMRecord sAMRecord3;
        int n4 = n == -1 ? n2 : n;
        SAMRecord sAMRecord4 = sAMRecord3 = n == -1 ? sAMRecord2 : sAMRecord;
        if (sAMRecord3.getReadLength() - n4 >= n3) {
            if (sAMRecord.getReadBases().length > n4) {
                sAMRecord.setAttribute("XT", (Object)(n4 + 1));
            }
            if (sAMRecord2.getReadBases().length > n4) {
                sAMRecord2.setAttribute("XT", (Object)(n4 + 1));
            }
            return true;
        }
        return false;
    }

    private static byte[] getReadBases(SAMRecord sAMRecord) {
        if (!sAMRecord.getReadNegativeStrandFlag()) {
            return sAMRecord.getReadBases();
        }
        byte[] byArray = new byte[sAMRecord.getReadBases().length];
        System.arraycopy(sAMRecord.getReadBases(), 0, byArray, 0, byArray.length);
        SequenceUtil.reverseComplement(byArray);
        return byArray;
    }

    public static int findIndexOfClipSequence(byte[] byArray, byte[] byArray2, int n, double d) {
        if (byArray == null || byArray.length < n) {
            return -1;
        }
        block0: for (int i = byArray.length - n; i > -1; --i) {
            int n2 = Math.min(byArray.length - i, byArray2.length);
            int n3 = (int)((double)n2 * d);
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!SequenceUtil.isNoCall(byArray2[j]) && !SequenceUtil.basesEqual(byArray2[j], byArray[i + j]) && ++n4 > n3) continue block0;
            }
            return i;
        }
        return -1;
    }
}

