/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileReader;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BrowseableBAMIndex;
import net.sf.samtools.DefaultSAMRecordFactory;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMTextReader;
import net.sf.samtools.seekablestream.SeekableBufferedStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;

public class SAMFileReader
implements Iterable<SAMRecord>,
Closeable {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean mIsBinary = false;
    private BAMIndex mIndex = null;
    private SAMRecordFactory samRecordFactory = new DefaultSAMRecordFactory();
    private ReaderImplementation mReader = null;
    private File samFile = null;

    public static ValidationStringency getDefaultValidationStringency() {
        return defaultValidationStringency;
    }

    public static void setDefaultValidationStringency(ValidationStringency validationStringency) {
        defaultValidationStringency = validationStringency;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMFileReader sAMFileReader = new SAMFileReader(file);
        SAMSequenceDictionary sAMSequenceDictionary = sAMFileReader.getFileHeader().getSequenceDictionary();
        CloserUtil.close(file);
        return sAMSequenceDictionary;
    }

    public SAMFileReader(InputStream inputStream) {
        this(inputStream, false);
    }

    public SAMFileReader(File file) {
        this(file, null, false);
    }

    public SAMFileReader(File file, File file2) {
        this(file, file2, false);
    }

    public SAMFileReader(InputStream inputStream, boolean bl) {
        this.init(inputStream, null, null, bl, defaultValidationStringency);
    }

    public SAMFileReader(File file, boolean bl) {
        this(file, null, bl);
    }

    public SAMFileReader(File file, File file2, boolean bl) {
        this.init(null, file, file2, bl, defaultValidationStringency);
    }

    public SAMFileReader(URL uRL, File file, boolean bl) {
        this.init((SeekableStream)new SeekableBufferedStream(new SeekableHTTPStream(uRL)), file, bl, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream seekableStream, File file, boolean bl) {
        this.init(seekableStream, file, bl, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl) {
        this.init(seekableStream, seekableStream2, bl, defaultValidationStringency);
    }

    @Override
    public void close() {
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mIndex = null;
    }

    public void enableFileSource(boolean bl) {
        this.mReader.enableFileSource(this, bl);
    }

    public void enableIndexCaching(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mReader.enableIndexCaching(bl);
    }

    public void enableIndexMemoryMapping(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mReader.enableIndexMemoryMapping(bl);
    }

    public void enableCrcChecking(boolean bl) {
        this.mReader.enableCrcChecking(bl);
    }

    public void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        this.samRecordFactory = sAMRecordFactory;
        this.mReader.setSAMRecordFactory(sAMRecordFactory);
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    public boolean hasIndex() {
        return this.mReader.hasIndex();
    }

    public BAMIndex getIndex() {
        return this.mReader.getIndex();
    }

    public boolean hasBrowseableIndex() {
        return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
    }

    public BrowseableBAMIndex getBrowseableIndex() {
        BAMIndex bAMIndex = this.getIndex();
        if (!(bAMIndex instanceof BrowseableBAMIndex)) {
            throw new SAMException("Cannot return index: index created by BAM is not browseable.");
        }
        return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(bAMIndex);
    }

    public SAMFileHeader getFileHeader() {
        return this.mReader.getFileHeader();
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mReader.setValidationStringency(validationStringency);
    }

    public SAMRecordIterator iterator() {
        return new AssertableIterator(this.mReader.getIterator());
    }

    public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
        return new AssertableIterator(this.mReader.getIterator(sAMFileSpan));
    }

    public SAMFileSpan getFilePointerSpanningReads() {
        return this.mReader.getFilePointerSpanningReads();
    }

    public SAMRecordIterator query(String string2, int n, int n2, boolean bl) {
        return new AssertableIterator(this.mReader.query(string2, n, n2, bl));
    }

    public SAMRecordIterator queryOverlapping(String string2, int n, int n2) {
        return this.query(string2, n, n2, false);
    }

    public SAMRecordIterator queryContained(String string2, int n, int n2) {
        return this.query(string2, n, n2, true);
    }

    public SAMRecordIterator queryUnmapped() {
        return new AssertableIterator(this.mReader.queryUnmapped());
    }

    public SAMRecordIterator queryAlignmentStart(String string2, int n) {
        return new AssertableIterator(this.mReader.queryAlignmentStart(string2, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAMRecord queryMate(SAMRecord sAMRecord) {
        if (!sAMRecord.getReadPairedFlag()) {
            throw new IllegalArgumentException("queryMate called for unpaired read.");
        }
        if (sAMRecord.getFirstOfPairFlag() == sAMRecord.getSecondOfPairFlag()) {
            throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
        }
        boolean bl = sAMRecord.getFirstOfPairFlag();
        SAMRecordIterator sAMRecordIterator = sAMRecord.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(sAMRecord.getMateReferenceName(), sAMRecord.getMateAlignmentStart());
        try {
            SAMRecord sAMRecord2;
            SAMRecord sAMRecord3 = null;
            while (sAMRecordIterator.hasNext()) {
                sAMRecord2 = (SAMRecord)sAMRecordIterator.next();
                if (!sAMRecord2.getReadPairedFlag()) {
                    if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                    throw new SAMFormatException("Paired and unpaired reads with same name: " + sAMRecord.getReadName());
                }
                if ((!bl ? sAMRecord2.getSecondOfPairFlag() : sAMRecord2.getFirstOfPairFlag()) || !sAMRecord.getReadName().equals(sAMRecord2.getReadName())) continue;
                if (sAMRecord3 != null) {
                    throw new SAMFormatException("Multiple SAMRecord with read name " + sAMRecord.getReadName() + " for " + (bl ? "second" : "first") + " end.");
                }
                sAMRecord3 = sAMRecord2;
            }
            sAMRecord2 = sAMRecord3;
            return sAMRecord2;
        }
        finally {
            sAMRecordIterator.close();
        }
    }

    private void init(SeekableStream seekableStream, File file, boolean bl, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(seekableStream)) {
                throw new SAMFormatException("Unrecognized file format: " + seekableStream);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(seekableStream, file, bl, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private void init(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(seekableStream)) {
                throw new SAMFormatException("Unrecognized file format: " + seekableStream);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(seekableStream, seekableStream2, bl, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private boolean streamLooksLikeBam(SeekableStream seekableStream) {
        String string2 = seekableStream.getSource();
        if (string2 == null) {
            return true;
        }
        return (string2 = string2.toLowerCase()).endsWith(".bam") || string2.contains(".bam?") || string2.contains(".bam&") || string2.contains(".bam%26");
    }

    private void init(InputStream inputStream, File file, File file2, boolean bl, ValidationStringency validationStringency) {
        if (inputStream != null && file != null) {
            throw new IllegalArgumentException("stream and file are mutually exclusive");
        }
        this.samFile = file;
        try {
            BufferedInputStream bufferedInputStream = file != null ? new BufferedInputStream(new FileInputStream(file), IOUtil.STANDARD_BUFFER_SIZE) : IOUtil.toBufferedStream(inputStream);
            if (this.isBAMFile(bufferedInputStream)) {
                this.mIsBinary = true;
                if (file == null || !file.isFile()) {
                    this.mReader = new BAMFileReader(bufferedInputStream, file2, bl, validationStringency, this.samRecordFactory);
                } else {
                    bufferedInputStream.close();
                    this.mReader = new BAMFileReader(file, file2, bl, validationStringency, this.samRecordFactory);
                }
            } else if (BlockCompressedInputStream.isValidFile(bufferedInputStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new BlockCompressedInputStream(bufferedInputStream), validationStringency, this.samRecordFactory);
            } else if (this.isGzippedSAMFile(bufferedInputStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedInputStream), validationStringency, this.samRecordFactory);
            } else if (this.isSAMFile(bufferedInputStream)) {
                if (file2 != null) {
                    bufferedInputStream.close();
                    throw new RuntimeException("Cannot use index file with textual SAM file");
                }
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedInputStream, file, validationStringency, this.samRecordFactory);
            } else {
                bufferedInputStream.close();
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(validationStringency);
            this.mReader.setSAMRecordFactory(this.samRecordFactory);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private boolean isBAMFile(InputStream inputStream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(inputStream)) {
            return false;
        }
        inputStream.mark(65536);
        byte[] byArray = new byte[65536];
        SAMFileReader.readBytes(inputStream, byArray, 0, 65536);
        inputStream.reset();
        byte[] byArray2 = new byte[4];
        int n = SAMFileReader.readBytes(new BlockCompressedInputStream(new ByteArrayInputStream(byArray)), byArray2, 0, 4);
        return n == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, byArray2);
    }

    private static int readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzippedSAMFile(BufferedInputStream bufferedInputStream) {
        if (!bufferedInputStream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        bufferedInputStream.mark(8000);
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            int n = gZIPInputStream.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedInputStream.reset();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }

    private boolean isSAMFile(InputStream inputStream) {
        return true;
    }

    public String toString() {
        if (this.samFile == null) {
            return this.getClass().getSimpleName() + "{initialized with stream}";
        }
        return this.getClass().getSimpleName() + "{" + this.samFile.getAbsolutePath() + "}";
    }

    static class AssertableIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord previous = null;
        private SAMRecordComparator comparator = null;

        public AssertableIterator(CloseableIterator<SAMRecord> closeableIterator) {
            this.wrappedIterator = closeableIterator;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            if (sortOrder == null || sortOrder == SAMFileHeader.SortOrder.unsorted) {
                this.comparator = null;
                return this;
            }
            this.comparator = sortOrder.getComparatorInstance();
            return this;
        }

        @Override
        public SAMRecord next() {
            SAMRecord sAMRecord = (SAMRecord)this.wrappedIterator.next();
            if (this.comparator != null) {
                if (this.previous != null && this.comparator.fileOrderCompare(this.previous, sAMRecord) > 0) {
                    throw new IllegalStateException("Records " + this.previous.getReadName() + " (" + this.previous.getReferenceName() + ":" + this.previous.getAlignmentStart() + ") " + "should come after " + sAMRecord.getReadName() + " (" + sAMRecord.getReferenceName() + ":" + sAMRecord.getAlignmentStart() + ") when sorting with " + this.comparator.getClass().getName());
                }
                this.previous = sAMRecord;
            }
            return sAMRecord;
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }

    static abstract class ReaderImplementation {
        ReaderImplementation() {
        }

        abstract void enableFileSource(SAMFileReader var1, boolean var2);

        abstract void enableIndexCaching(boolean var1);

        abstract void enableIndexMemoryMapping(boolean var1);

        abstract void enableCrcChecking(boolean var1);

        abstract void setSAMRecordFactory(SAMRecordFactory var1);

        abstract boolean hasIndex();

        abstract BAMIndex getIndex();

        abstract SAMFileHeader getFileHeader();

        abstract CloseableIterator<SAMRecord> getIterator();

        abstract CloseableIterator<SAMRecord> getIterator(SAMFileSpan var1);

        abstract SAMFileSpan getFilePointerSpanningReads();

        abstract CloseableIterator<SAMRecord> query(String var1, int var2, int var3, boolean var4);

        abstract CloseableIterator<SAMRecord> queryAlignmentStart(String var1, int var2);

        public abstract CloseableIterator<SAMRecord> queryUnmapped();

        abstract void close();

        abstract void setValidationStringency(ValidationStringency var1);

        abstract ValidationStringency getValidationStringency();
    }

    public static enum ValidationStringency {
        STRICT,
        LENIENT,
        SILENT;

        public static final ValidationStringency DEFAULT_STRINGENCY;

        static {
            DEFAULT_STRINGENCY = STRICT;
        }
    }
}

