/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.samtools.AsyncSAMFileWriter;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.Defaults;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMTextWriter;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.Md5CalculatingOutputStream;
import net.sf.samtools.util.RuntimeIOException;

public class SAMFileWriterFactory {
    private static boolean defaultCreateIndexWhileWriting = Defaults.CREATE_INDEX;
    private boolean createIndex = defaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = Defaults.CREATE_MD5;
    private boolean createMd5File = defaultCreateMd5File;
    private boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    private int asyncOutputBufferSize = 2000;
    private File tmpDir;
    private Integer maxRecordsInRam;

    public static void setDefaultCreateMd5File(boolean bl) {
        defaultCreateMd5File = bl;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean bl) {
        this.createMd5File = bl;
        return this;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean bl) {
        defaultCreateIndexWhileWriting = bl;
    }

    public SAMFileWriterFactory setCreateIndex(boolean bl) {
        this.createIndex = bl;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int n) {
        this.maxRecordsInRam = n;
        return this;
    }

    public void setUseAsyncIo(boolean bl) {
        this.useAsyncIo = bl;
    }

    public void setAsyncOutputBufferSize(int n) {
        this.asyncOutputBufferSize = n;
    }

    public SAMFileWriterFactory setTempDirectory(File file) {
        this.tmpDir = file;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        return this.makeBAMWriter(sAMFileHeader, bl, file, BlockCompressedOutputStream.getDefaultCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, int n) {
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = this.createMd5File && IOUtil.isRegularPath(file);
            if (this.createMd5File && !bl3) {
                System.err.println("Cannot create MD5 file for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            BAMFileWriter bAMFileWriter = bl3 ? new BAMFileWriter(new Md5CalculatingOutputStream(new FileOutputStream(file, false), new File(file.getAbsolutePath() + ".md5")), file, n) : new BAMFileWriter(file, n);
            boolean bl5 = bl2 = this.createIndex && IOUtil.isRegularPath(file);
            if (this.createIndex && !bl2) {
                System.err.println("Cannot create index for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            if (this.tmpDir != null) {
                bAMFileWriter.setTempDirectory(this.tmpDir);
            }
            this.initializeBAMWriter(bAMFileWriter, sAMFileHeader, bl, bl2);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(bAMFileWriter, this.asyncOutputBufferSize);
            }
            return bAMFileWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter bAMFileWriter, SAMFileHeader sAMFileHeader, boolean bl, boolean bl2) {
        bAMFileWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            bAMFileWriter.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        bAMFileWriter.setHeader(sAMFileHeader);
        if (bl2 && bAMFileWriter.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            bAMFileWriter.enableBamIndexConstruction();
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        try {
            SAMTextWriter sAMTextWriter = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream(new FileOutputStream(file, false), new File(file.getAbsolutePath() + ".md5"))) : new SAMTextWriter(file);
            sAMTextWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
            if (this.maxRecordsInRam != null) {
                sAMTextWriter.setMaxRecordsInRam(this.maxRecordsInRam);
            }
            sAMTextWriter.setHeader(sAMFileHeader);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(sAMTextWriter, this.asyncOutputBufferSize);
            }
            return sAMTextWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, OutputStream outputStream) {
        SAMTextWriter sAMTextWriter = new SAMTextWriter(outputStream);
        sAMTextWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            sAMTextWriter.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        sAMTextWriter.setHeader(sAMFileHeader);
        if (this.useAsyncIo) {
            return new AsyncSAMFileWriter(sAMTextWriter, this.asyncOutputBufferSize);
        }
        return sAMTextWriter;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        String string2 = file.getName();
        if (string2.endsWith(".bam")) {
            return this.makeBAMWriter(sAMFileHeader, bl, file);
        }
        if (string2.endsWith(".sam")) {
            return this.makeSAMWriter(sAMFileHeader, bl, file);
        }
        return this.makeBAMWriter(sAMFileHeader, bl, file);
    }
}

