/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMException;

public class SAMSequenceRecord
extends AbstractSAMHeaderRecord
implements Cloneable {
    private String mSequenceName = null;
    private int mSequenceIndex = -1;
    private int mSequenceLength = 0;
    public static final String SEQUENCE_NAME_TAG = "SN";
    public static final String SEQUENCE_LENGTH_TAG = "LN";
    public static final String MD5_TAG = "M5";
    public static final String ASSEMBLY_TAG = "AS";
    public static final String URI_TAG = "UR";
    public static final String SPECIES_TAG = "SP";
    public static final int UNKNOWN_SEQUENCE_LENGTH = 0;
    public static final String RESERVED_MRNM_SEQUENCE_NAME = "=";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("SN", "LN", "AS", "M5", "UR", "SP"));
    private static Pattern SEQUENCE_NAME_SPLITTER = Pattern.compile("\\s");
    private static char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};

    public SAMSequenceRecord(String string2) {
        this(string2, 0);
    }

    public SAMSequenceRecord(String string2, int n) {
        if (string2 != null) {
            if (SEQUENCE_NAME_SPLITTER.matcher(string2).find()) {
                throw new SAMException("Sequence name contains invalid character: " + string2);
            }
            SAMSequenceRecord.validateSequenceName(string2);
            this.mSequenceName = string2.intern();
        }
        this.mSequenceLength = n;
    }

    public String getSequenceName() {
        return this.mSequenceName;
    }

    private void setSequenceName(String string2) {
        this.mSequenceName = string2 != null ? string2.intern() : null;
    }

    public int getSequenceLength() {
        return this.mSequenceLength;
    }

    public void setSequenceLength(int n) {
        this.mSequenceLength = n;
    }

    public String getAssembly() {
        return this.getAttribute(ASSEMBLY_TAG);
    }

    public void setAssembly(String string2) {
        this.setAttribute(ASSEMBLY_TAG, string2);
    }

    public String getSpecies() {
        return this.getAttribute(SPECIES_TAG);
    }

    public void setSpecies(String string2) {
        this.setAttribute(SPECIES_TAG, string2);
    }

    public int getSequenceIndex() {
        return this.mSequenceIndex;
    }

    public void setSequenceIndex(int n) {
        this.mSequenceIndex = n;
    }

    public boolean isSameSequence(SAMSequenceRecord sAMSequenceRecord) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this == sAMSequenceRecord) {
            return true;
        }
        if (sAMSequenceRecord == null) {
            return false;
        }
        if (this.mSequenceIndex != sAMSequenceRecord.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != 0 && sAMSequenceRecord.mSequenceLength != 0 && this.mSequenceLength != sAMSequenceRecord.mSequenceLength) {
            return false;
        }
        return !(this.getAttribute(MD5_TAG) != null && sAMSequenceRecord.getAttribute(MD5_TAG) != null ? !(bigInteger2 = new BigInteger(this.getAttribute(MD5_TAG), 16)).equals(bigInteger = new BigInteger(sAMSequenceRecord.getAttribute(MD5_TAG), 16)) : this.mSequenceName != sAMSequenceRecord.mSequenceName);
    }

    private URI makeURI(String string2) throws URISyntaxException {
        URI uRI = new URI(string2);
        if (uRI.getScheme() == null) {
            uRI = new URI("file", uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
        }
        return uRI;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SAMSequenceRecord)) {
            return false;
        }
        SAMSequenceRecord sAMSequenceRecord = (SAMSequenceRecord)object;
        if (this.mSequenceIndex != sAMSequenceRecord.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != sAMSequenceRecord.mSequenceLength) {
            return false;
        }
        if (!this.attributesEqual(sAMSequenceRecord)) {
            return false;
        }
        return this.mSequenceName == sAMSequenceRecord.mSequenceName;
    }

    public int hashCode() {
        return this.mSequenceName != null ? this.mSequenceName.hashCode() : 0;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public final SAMSequenceRecord clone() {
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(this.mSequenceName, this.mSequenceLength);
        sAMSequenceRecord.mSequenceIndex = this.mSequenceIndex;
        for (Map.Entry<String, String> entry : this.getAttributes()) {
            sAMSequenceRecord.setAttribute(entry.getKey(), entry.getValue());
        }
        return sAMSequenceRecord;
    }

    public static String truncateSequenceName(String string2) {
        int n = string2.length();
        for (char c : WHITESPACE_CHARS) {
            int n2 = string2.indexOf(c);
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        return string2.substring(0, n);
    }

    public static void validateSequenceName(String string2) {
        if (RESERVED_MRNM_SEQUENCE_NAME.equals(string2)) {
            throw new SAMException("'=' is not a valid sequence name");
        }
    }
}

