/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.Iterator;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TabixFeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.TribbleIndexedFeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string2, FeatureCodec<FEATURE, SOURCE> featureCodec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(string2, featureCodec, true);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string2, FeatureCodec<FEATURE, SOURCE> featureCodec, boolean bl) throws TribbleException {
        try {
            if (string2.endsWith(".gz") && ParsingUtils.resourceExists(string2 + ".tbi")) {
                if (!(featureCodec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + featureCodec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(string2, (AsciiFeatureCodec)featureCodec);
            }
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(string2, featureCodec, bl);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", string2, iOException);
        }
        catch (TribbleException tribbleException) {
            tribbleException.setSource(string2);
            throw tribbleException;
        }
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String string2, FeatureCodec<FEATURE, SOURCE> featureCodec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(string2, featureCodec, index);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", string2, iOException);
        }
    }

    protected AbstractFeatureReader(String string2, FeatureCodec<T, SOURCE> featureCodec) {
        this.path = string2;
        this.codec = featureCodec;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

