/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.Closeable;
import java.io.IOException;
import net.sf.samtools.util.AbstractIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.Tuple;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineIterator;
import org.broad.tribble.readers.LocationAware;

public class AsciiLineReaderIterator
implements LocationAware,
LineIterator,
Closeable {
    private final AsciiLineReader asciiLineReader;
    private final TupleIterator i;
    private Tuple<String, Long> current = null;

    public AsciiLineReaderIterator(AsciiLineReader asciiLineReader) {
        this.asciiLineReader = asciiLineReader;
        this.i = new TupleIterator();
    }

    @Override
    public void close() throws IOException {
        CloserUtil.close(this.asciiLineReader);
    }

    @Override
    public boolean hasNext() {
        return this.i.hasNext();
    }

    @Override
    public String next() {
        this.current = (Tuple)this.i.next();
        return (String)this.current.a;
    }

    @Override
    public void remove() {
        this.i.remove();
    }

    @Override
    public long getPosition() {
        return this.i.getPosition();
    }

    @Override
    public String peek() {
        return (String)((Tuple)this.i.peek()).a;
    }

    private class TupleIterator
    extends AbstractIterator<Tuple<String, Long>>
    implements LocationAware {
        public TupleIterator() {
            this.hasNext();
        }

        @Override
        protected Tuple<String, Long> advance() {
            String string2;
            long l = AsciiLineReaderIterator.this.asciiLineReader.getPosition();
            try {
                string2 = AsciiLineReaderIterator.this.asciiLineReader.readLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return string2 == null ? null : new Tuple<String, Long>(string2, l);
        }

        @Override
        public long getPosition() {
            Tuple tuple = (Tuple)this.peek();
            return tuple != null ? ((Long)tuple.b).longValue() : AsciiLineReaderIterator.this.asciiLineReader.getPosition();
        }
    }
}

