/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.data.ScoreAggregator;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizer;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;

public final class LogNormalizedScoresFileWriter
extends ScoresFileWriter {
    private final LogNormalizer normalizer = new LogNormalizer();

    public LogNormalizedScoresFileWriter(boolean bl) {
        super(bl);
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        ScoreAggregator scoreAggregator = new ScoreAggregator(poolQScores.getConditionToBarcodeMap());
        for (String string2 : poolQScores.getConstructBarcodes()) {
            Collection<String> collection = poolQScores.getIdsForConstructBarcode(string2);
            this.printConstructAndConstructIds(printWriter, string2, collection);
            Map<String, Integer> map2 = poolQScores.getScoresBySampleForConstruct(string2);
            Map<String, Integer> map3 = scoreAggregator.getScoresByCondition(map2);
            for (String string3 : poolQScores.getConditions()) {
                Integer n = poolQScores.getMatchingConstructReadCountForCondition(string3);
                double d = this.normalizer.normalize((Number)map3.get(string3), n);
                printWriter.append('\t').append(String.valueOf(d));
            }
            printWriter.append('\n');
        }
    }
}

