/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import java.util.Iterator;

public class ThreadLocker
extends BasicLocker {
    private boolean allowMultithreadedAccess;

    public ThreadLocker(EnvironmentImpl env) {
        super(env);
        this.lockManager.registerThreadLocker(this);
    }

    public static ThreadLocker createThreadLocker(EnvironmentImpl env) throws DatabaseException {
        return env.isReplicated() ? env.createRepThreadLocker() : new ThreadLocker(env);
    }

    void close() {
        super.close();
        this.lockManager.unregisterThreadLocker(this);
    }

    public void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        Iterator<ThreadLocker> iter2 = this.lockManager.getThreadLockers(this.thread);
        while (iter2.hasNext()) {
            ThreadLocker locker = iter2.next();
            locker.throwIfPreempted(allowPreemptedLocker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockAfterLsnChange(long oldLsn, long newLsn, DatabaseImpl dbImpl) {
        boolean oldVal = this.allowMultithreadedAccess;
        this.allowMultithreadedAccess = true;
        try {
            super.lockAfterLsnChange(oldLsn, newLsn, dbImpl);
            Object var8_5 = null;
            this.allowMultithreadedAccess = oldVal;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.allowMultithreadedAccess = oldVal;
            throw throwable;
        }
    }

    protected synchronized void checkState(boolean ignoreCalledByAbort) {
        if (!this.allowMultithreadedAccess && this.thread != Thread.currentThread()) {
            throw new IllegalStateException("Non-transactional Cursors may not be used in multiple threads; Cursor was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        this.checkState(false);
        return ThreadLocker.createThreadLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (other instanceof ThreadLocker) {
            return this.thread == other.thread;
        }
        return false;
    }
}

