/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.AsciiWriter;

public class ViewSam
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Prints a SAM or BAM file to the screen.";
    @Option(shortName="I", doc="The SAM or BAM file to view.")
    public File INPUT;
    @Option(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Option(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;

    public static void main(String[] stringArray) {
        new ViewSam().instanceMain(stringArray);
    }

    @Override
    protected int doWork() {
        return this.writeSamText(System.out);
    }

    int writeSamText(PrintStream printStream) {
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
            AsciiWriter asciiWriter = new AsciiWriter(printStream);
            SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader();
            if (sAMFileHeader.getTextHeader() != null) {
                asciiWriter.write(sAMFileHeader.getTextHeader());
            } else {
                new SAMTextHeaderCodec().encode(asciiWriter, sAMFileHeader, true);
            }
            for (SAMRecord sAMRecord : sAMFileReader) {
                if (printStream.checkError()) {
                    return 1;
                }
                if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && sAMRecord.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !sAMRecord.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && sAMRecord.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !sAMRecord.getReadFailsVendorQualityCheckFlag()) continue;
                asciiWriter.write(sAMRecord.getSAMString());
            }
            asciiWriter.flush();
            if (printStream.checkError()) {
                return 1;
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception writing SAM text", iOException);
        }
    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }
}

