/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Collection;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CoordMath;

public class Interval
implements Comparable<Interval>,
Cloneable {
    private final String sequence;
    private final int start;
    private final int end;
    private final boolean negativeStrand;
    private final String name;

    public Interval(String string2, int n, int n2) {
        this(string2, n, n2, false, null);
    }

    public Interval(String string2, int n, int n2, boolean bl, String string3) {
        this.sequence = string2;
        this.start = n;
        this.end = n2;
        this.negativeStrand = bl;
        this.name = string3;
        if (this.end < this.start - 1) {
            throw new IllegalArgumentException("start must be less than or equal to end!");
        }
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public boolean isPositiveStrand() {
        return !this.negativeStrand;
    }

    public String getName() {
        return this.name;
    }

    public boolean intersects(Interval interval) {
        return this.getSequence().equals(interval.getSequence()) && CoordMath.overlaps(this.start, this.end, interval.start, interval.end);
    }

    public int getIntersectionLength(Interval interval) {
        if (this.intersects(interval)) {
            return CoordMath.getOverlap(this.getStart(), this.getEnd(), interval.getStart(), interval.getEnd());
        }
        return 0;
    }

    public Interval intersect(Interval interval) {
        if (!this.intersects(interval)) {
            throw new IllegalArgumentException(interval + " does not intersect " + this);
        }
        return new Interval(this.sequence, Math.max(this.start, interval.start), Math.min(this.end, interval.end), this.negativeStrand, this.name + " intersection " + interval.name);
    }

    public boolean abuts(Interval interval) {
        return this.getSequence().equals(interval.getSequence()) && (this.start == interval.end + 1 || interval.start == this.end + 1);
    }

    public int length() {
        return this.end - this.start + 1;
    }

    public Interval pad(int n, int n2) {
        return new Interval(this.sequence, this.start - n, this.end + n2, this.negativeStrand, this.name);
    }

    public static long countBases(Collection<Interval> collection) {
        long l = 0L;
        for (Interval interval : collection) {
            l += (long)interval.length();
        }
        return l;
    }

    @Override
    public int compareTo(Interval interval) {
        if (interval == null) {
            return -1;
        }
        int n = this.sequence.compareTo(interval.sequence);
        if (n == 0) {
            n = this.start == interval.start ? this.end - interval.end : this.start - interval.start;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Interval interval = (Interval)object;
        return this.compareTo(interval) == 0;
    }

    public int hashCode() {
        int n = this.sequence.hashCode();
        n = 31 * n + this.start;
        n = 31 * n + this.end;
        return n;
    }

    public String toString() {
        return this.getSequence() + ":" + this.start + "-" + this.end;
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PicardException("That's unpossible", cloneNotSupportedException);
        }
    }
}

