/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;

public class SAMRecordCoordinateComparator
implements SAMRecordComparator {
    @Override
    public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n = this.fileOrderCompare(sAMRecord, sAMRecord2);
        if (n != 0) {
            return n;
        }
        if (sAMRecord.getReadNegativeStrandFlag() == sAMRecord2.getReadNegativeStrandFlag()) {
            n = sAMRecord.getReadName().compareTo(sAMRecord2.getReadName());
            if (n != 0) {
                return n;
            }
            n = this.compareInts(sAMRecord.getFlags(), sAMRecord2.getFlags());
            if (n != 0) {
                return n;
            }
            n = this.compareInts(sAMRecord.getMappingQuality(), sAMRecord2.getMappingQuality());
            if (n != 0) {
                return n;
            }
            n = this.compareInts(sAMRecord.getMateReferenceIndex(), sAMRecord2.getMateReferenceIndex());
            if (n != 0) {
                return n;
            }
            n = this.compareInts(sAMRecord.getMateAlignmentStart(), sAMRecord2.getMateAlignmentStart());
            if (n != 0) {
                return n;
            }
            n = this.compareInts(sAMRecord.getInferredInsertSize(), sAMRecord2.getInferredInsertSize());
            return n;
        }
        return sAMRecord.getReadNegativeStrandFlag() ? 1 : -1;
    }

    private int compareInts(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n = sAMRecord.getReferenceIndex();
        int n2 = sAMRecord2.getReferenceIndex();
        if (n == -1) {
            return n2 == -1 ? 0 : 1;
        }
        if (n2 == -1) {
            return -1;
        }
        int n3 = n - n2;
        if (n3 != 0) {
            return n3;
        }
        return sAMRecord.getAlignmentStart() - sAMRecord2.getAlignmentStart();
    }
}

