/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class SAMTools {
    private String mCommand = null;
    private File mInputFile = null;

    public static void main(String[] stringArray) throws Exception {
        int n = new SAMTools().run(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    private SAMTools() {
    }

    private void usage() {
        System.out.println();
        System.out.println("SAMTools version 0.1.0");
        System.out.println("Tools for manipulating SAM/BAM files");
        System.out.println();
        System.out.println("Usage: SAMTools <command> <options...>");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("  help");
        System.out.println("  view        <file>");
        System.out.println();
    }

    private boolean parseArguments(String[] stringArray) {
        if (stringArray.length == 0) {
            this.usage();
            return true;
        }
        String string2 = stringArray[0];
        int n = stringArray.length - 1;
        if (string2.equals("help")) {
            this.usage();
            return true;
        }
        if (string2.equals("view")) {
            if (n != 1) {
                this.usage();
                return false;
            }
            this.mInputFile = new File(stringArray[1]);
            if (!this.mInputFile.exists()) {
                System.out.println("Input file not found: " + this.mInputFile);
                return false;
            }
        } else {
            System.out.println("Unrecognized command: " + string2);
            System.out.println();
            this.usage();
            return false;
        }
        this.mCommand = string2;
        return true;
    }

    private int run(String[] stringArray) throws Exception {
        if (!this.parseArguments(stringArray)) {
            return 1;
        }
        if (this.mCommand == null) {
            return 0;
        }
        if (this.mCommand.equals("view")) {
            return this.runView();
        }
        return 1;
    }

    private int runView() {
        SAMFileReader sAMFileReader = new SAMFileReader(this.mInputFile);
        SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator();
        while (sAMRecordIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            System.out.println(sAMRecord.format());
        }
        sAMRecordIterator.close();
        return 0;
    }
}

