/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionContainer;

public class Union
extends BaseResourceCollectionContainer {
    public static Union getInstance(ResourceCollection rc) {
        return rc instanceof Union ? (Union)rc : new Union(rc);
    }

    public Union() {
    }

    public Union(Project project) {
        super(project);
    }

    public Union(ResourceCollection rc) {
        this(Project.getProject(rc), rc);
    }

    public Union(Project project, ResourceCollection rc) {
        super(project);
        this.add(rc);
    }

    public String[] list() {
        if (this.isReference()) {
            return ((Union)this.getCheckedRef()).list();
        }
        Collection result2 = this.getCollection(true);
        return result2.toArray(new String[result2.size()]);
    }

    public Resource[] listResources() {
        if (this.isReference()) {
            return ((Union)this.getCheckedRef()).listResources();
        }
        Collection result2 = this.getCollection();
        return result2.toArray(new Resource[result2.size()]);
    }

    protected Collection getCollection() {
        return this.getCollection(false);
    }

    protected Collection getCollection(boolean asString) {
        List rc = this.getResourceCollections();
        if (rc.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashSet set = new LinkedHashSet(rc.size() * 2);
        Iterator rcIter = rc.iterator();
        while (rcIter.hasNext()) {
            Iterator r = Union.nextRC(rcIter).iterator();
            while (r.hasNext()) {
                Object o = r.next();
                if (asString) {
                    o = o.toString();
                }
                set.add(o);
            }
        }
        return set;
    }

    private static ResourceCollection nextRC(Iterator i) {
        return (ResourceCollection)i.next();
    }
}

