/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.cli;

import java.io.Serializable;
import org.broadinstitute.rnai.poolq.api.PoolQArgs;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OptionsSummary$ {
    public static final OptionsSummary$ MODULE$;

    static {
        new OptionsSummary$();
    }

    public String summarize(PoolQArgs inputs) {
        Serializable serializable;
        Serializable serializable2;
        StringBuilder builder = new StringBuilder();
        Buffer<String> readsFiles = JavaConverters$.MODULE$.asScalaBufferConverter(inputs.getReadsFilenames()).asScala();
        builder.append("PoolQ runtime configuration summary\n");
        builder.append("Input files:\n");
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConditions file:         ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getConditionsFilename()})));
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tReference file:          ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getReferenceFilename()})));
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tReads files:             ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{readsFiles.mkString(", ")})));
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tReads file type:         ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getReadsFileType()})));
        String platformReference = inputs.getPlatformReferenceFilename();
        Serializable serializable3 = platformReference == null ? BoxedUnit.UNIT : builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tPlatform Reference file: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{platformReference})));
        builder.append('\n');
        builder.append("Options:\n");
        StringBuilder stringBuilder = inputs.requireExactMatch() ? builder.append("\tExact matching for construct barcodes\n") : builder.append("\tAllow 1-base mismatches for construct barcodes\n");
        StringBuilder stringBuilder2 = inputs.includeAmbiguous() ? builder.append("\tCount reads for all 1-base mismatches\n") : builder.append("\tDiscard reads with ambiguous 1-base mismatches\n");
        StringBuilder stringBuilder3 = inputs.includeNonPfReads() ? builder.append("\tInclude reads failing purity filter\n") : builder.append("\tDiscard reads failing purity filter\n");
        builder.append('\n');
        builder.append("Read structure:\n");
        Serializable serializable4 = inputs.getConstructBarcodeMatchLength() == null ? BoxedUnit.UNIT : builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConstruct match length: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getConstructBarcodeMatchLength()})));
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tSample barcode start index: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(inputs.getSampleBarcodeStartIndex())})));
        if (inputs.getConstructBarcodeSearchPrefix() == null) {
            serializable2 = builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConstruct barcode start index: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(inputs.getConstructBarcodeStartIndex())})));
        } else {
            builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConstruct barcode search prefix: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getConstructBarcodeSearchPrefix()})));
            builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConstruct barcode search start offset: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getConstructBarcodeSearchStartIndex()})));
            serializable2 = inputs.getConstructBarcodeSearchEndIndex() == null ? BoxedUnit.UNIT : builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tConstruct barcode search end offset: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getConstructBarcodeSearchEndIndex()})));
        }
        builder.append('\n');
        builder.append("Output files:\n");
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tQuality file:               ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getQualityFilename()})));
        builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tScores file:                ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputs.getScoresFilename()})));
        String logNormalizedFile = inputs.getLogNormalizedScoresFilename();
        Serializable serializable5 = logNormalizedFile == null ? BoxedUnit.UNIT : builder.append("\tLog-Normalized Scores file: ").append(logNormalizedFile).append('\n');
        String barcodeScoresFile = inputs.getBarcodeScoresFilename();
        Serializable serializable6 = barcodeScoresFile == null ? BoxedUnit.UNIT : builder.append("\tBarcode scores file:        ").append(barcodeScoresFile).append('\n');
        String unexpectedSequenceFile = inputs.getUnexpectedSequenceFilename();
        if (unexpectedSequenceFile == null) {
            serializable = BoxedUnit.UNIT;
        } else {
            builder.append("\tUnexpected sequence file:   ").append(unexpectedSequenceFile).append('\n');
            serializable = builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tIncluding the top ", " unexpected sequences.\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(inputs.getUnexpectedSequenceThreshold())})));
        }
        return builder.toString();
    }

    private OptionsSummary$() {
        MODULE$ = this;
    }
}

