/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;
import org.broadinstitute.rnai.poolq.impl.fileparser.AbstractReadsFileIterator;

class SamReadsFileIterator
extends AbstractReadsFileIterator {
    private final SAMFileReader samFileReader;
    private final Iterator<SAMRecord> iterator;
    private final boolean includeNonPf;

    SamReadsFileIterator(InputStream inputStream, boolean bl) {
        this.samFileReader = new SAMFileReader(inputStream);
        this.iterator = this.samFileReader.iterator();
        this.includeNonPf = bl;
    }

    SamReadsFileIterator(InputStream inputStream) {
        this(inputStream, true);
    }

    @Override
    protected String getNextRead() {
        while (this.iterator.hasNext()) {
            SAMRecord sAMRecord = this.iterator.next();
            if (sAMRecord.getReadFailsVendorQualityCheckFlag() && !this.includeNonPf) continue;
            if (sAMRecord.getReadNegativeStrandFlag()) {
                return SequenceUtil.reverseComplement(sAMRecord.getReadString());
            }
            return sAMRecord.getReadString();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.samFileReader.close();
    }
}

